/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.painter;

import com.seaglasslookandfeel.painter.AbstractRegionPainter;
import com.seaglasslookandfeel.painter.util.ShapeGenerator;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;

public final class TabbedPaneTabCloseButtonPainter
extends AbstractRegionPainter {
    private Color borderMouseOver = this.decodeColor("seaGlassTabbedPaneTabCloseBorderBase", 0.0f, 0.0f, 0.0f, -170);
    private Color borderFocused = this.decodeColor("seaGlassTabbedPaneTabCloseBorderBase", 0.0f, 0.0f, 0.0f, -100);
    private Color borderPressed = this.decodeColor("seaGlassTabbedPaneTabCloseBorderBase", 0.0f, 0.0f, 0.0f, -40);
    private Color graphicInnerShadow1 = this.decodeColor("seaGlassTabbedPaneTabCloseGraphicInnerShadowBase", 0.0f, 0.0f, 0.0f, -130);
    private Color graphicInnerShadow2 = this.decodeColor("seaGlassTabbedPaneTabCloseGraphicInnerShadowBase", 0.0f, 0.0f, 0.0f, -170);
    private Color graphicInnerShadow3 = this.decodeColor("seaGlassTabbedPaneTabCloseGraphicInnerShadowBase", 0.0f, 0.0f, 0.0f, -190);
    private Color graphicInnerShadow4 = this.decodeColor("seaGlassTabbedPaneTabCloseGraphicInnerShadowBase", 0.0f, 0.0f, 0.0f, -150);
    private Color graphicBase = this.decodeColor("seaGlassTabbedPaneTabCloseGraphicBase");
    private Color graphicDropShadow1 = this.decodeColor("seaGlassTabbedPaneTabCloseGraphicDropShadowBase", 0.0f, 0.0f, 0.0f, -230);
    private Color graphicDropShadow2 = this.decodeColor("seaGlassTabbedPaneTabCloseGraphicDropShadowBase", 0.0f, 0.0f, 0.0f, -240);
    private Color graphicDropShadow3 = this.decodeColor("seaGlassTabbedPaneTabCloseGraphicDropShadowBase", 0.0f, 0.0f, 0.0f, -240);
    private Color graphicDropShadow4 = this.decodeColor("seaGlassTabbedPaneTabCloseGraphicDropShadowBase", 0.0f, 0.0f, 0.0f, -230);
    private Which state;
    private AbstractRegionPainter.PaintContext ctx;

    public TabbedPaneTabCloseButtonPainter(Which state) {
        this.state = state;
        this.ctx = new AbstractRegionPainter.PaintContext(AbstractRegionPainter.PaintContext.CacheMode.FIXED_SIZES);
    }

    @Override
    protected void doPaint(Graphics2D g, JComponent c, int width, int height, Object[] extendedCacheKeys) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        switch (this.state) {
            case ENABLED: {
                this.drawEnabledGraphic(g, width, height);
                break;
            }
            case MOUSEOVER: {
                this.drawBorder(g, width, height, this.borderMouseOver, 0.4f);
                this.drawOverlayGraphic(g, width, height);
                break;
            }
            case FOCUSED: {
                this.drawBorder(g, width, height, this.borderFocused, 0.4f);
                this.drawOverlayGraphic(g, width, height);
                break;
            }
            case PRESSED: {
                this.drawBorder(g, width, height, this.borderPressed, 0.5f);
                this.drawOverlayGraphic(g, width, height);
            }
        }
    }

    @Override
    protected AbstractRegionPainter.PaintContext getPaintContext() {
        return this.ctx;
    }

    private void drawBorder(Graphics2D g, int width, int height, Color color, float size) {
        int max = (int)((double)Math.min((float)(height - 2) * size, (float)height / 2.0f) + 0.5);
        int alphaDelta = color.getAlpha() / max;
        for (int i = 0; i < max; ++i) {
            Shape s = this.shapeGenerator.createRoundRectangle(i, i, width - 2 * i - 1, height - 2 * i - 1, ShapeGenerator.CornerSize.CHECKBOX_INTERIOR);
            Color newColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha() - i * alphaDelta);
            g.setPaint(newColor);
            g.draw(s);
        }
    }

    private void drawEnabledGraphic(Graphics2D g, int width, int height) {
        Shape s = this.shapeGenerator.createTabCloseIcon(2, 2, width - 4, height - 4);
        g.setPaint(this.createGraphicInnerShadowGradient(s));
        g.fill(s);
    }

    private void drawOverlayGraphic(Graphics2D g, int width, int height) {
        Shape s = this.shapeGenerator.createTabCloseIcon(2, 2, width - 4, height - 4);
        g.setPaint(this.graphicBase);
        g.fill(s);
        s = this.shapeGenerator.createTabCloseIcon(2, 3, width - 4, height - 4);
        g.setPaint(this.createGraphicDropShadowGradient(s));
        Shape oldClip = g.getClip();
        g.setClip(2, 3, width - 4, height - 4);
        g.fill(s);
        g.setClip(oldClip);
    }

    private Paint createGraphicInnerShadowGradient(Shape s) {
        Rectangle2D b = s.getBounds2D();
        float midX = (float)b.getCenterX();
        float y1 = (float)b.getMinY();
        float y2 = (float)b.getMaxY();
        return this.createGradient(midX, y1, midX, y2, new float[]{0.0f, 0.43f, 0.57f, 1.0f}, new Color[]{this.graphicInnerShadow1, this.graphicInnerShadow2, this.graphicInnerShadow3, this.graphicInnerShadow4});
    }

    private Paint createGraphicDropShadowGradient(Shape s) {
        Rectangle2D b = s.getBounds2D();
        float midX = (float)b.getCenterX();
        float y1 = (float)b.getMinY();
        float y2 = (float)b.getMaxY();
        return this.createGradient(midX, y1, midX, y2, new float[]{0.0f, 0.43f, 0.57f, 1.0f}, new Color[]{this.graphicDropShadow1, this.graphicDropShadow2, this.graphicDropShadow3, this.graphicDropShadow4});
    }

    public static enum Which {
        DISABLED,
        ENABLED,
        MOUSEOVER,
        FOCUSED,
        PRESSED;

    }
}

