/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.painter;

import com.seaglasslookandfeel.painter.AbstractRegionPainter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;

public final class TabbedPaneTabAreaPainter
extends AbstractRegionPainter {
    private Color baseColor = this.decodeColor("toolbarToggleButtonBase");
    private AbstractRegionPainter.TwoColors tabLineInner = new AbstractRegionPainter.TwoColors(this.baseColor, this.deriveColor(this.baseColor, 0.0f, 0.0f, 0.0f, 40));
    private AbstractRegionPainter.TwoColors tabLineInnerEdge = new AbstractRegionPainter.TwoColors(this.baseColor, this.deriveColor(this.baseColor, 0.0f, 0.0f, 0.0f, 240));
    public Which state;
    private AbstractRegionPainter.PaintContext ctx;
    private boolean isDisabled;

    public TabbedPaneTabAreaPainter(Which state) {
        this.state = state;
        this.ctx = new AbstractRegionPainter.PaintContext(AbstractRegionPainter.PaintContext.CacheMode.NO_CACHING);
        switch (state) {
            case BACKGROUND_DISABLED_TOP: 
            case BACKGROUND_DISABLED_LEFT: 
            case BACKGROUND_DISABLED_BOTTOM: 
            case BACKGROUND_DISABLED_RIGHT: {
                this.isDisabled = true;
                break;
            }
            case BACKGROUND_ENABLED_TOP: 
            case BACKGROUND_ENABLED_LEFT: 
            case BACKGROUND_ENABLED_BOTTOM: 
            case BACKGROUND_ENABLED_RIGHT: {
                this.isDisabled = false;
            }
        }
    }

    @Override
    protected void doPaint(Graphics2D g, JComponent c, int width, int height, Object[] extendedCacheKeys) {
        JTabbedPane tabPane = (JTabbedPane)c;
        int orientation = tabPane.getTabPlacement();
        if (orientation == 2 || orientation == 4) {
            this.paintVerticalLine(g, c, 0, height / 2, width, height);
        } else {
            this.paintHorizontalLine(g, c, 0, height / 2, width, height);
        }
    }

    @Override
    protected AbstractRegionPainter.PaintContext getPaintContext() {
        return this.ctx;
    }

    private void paintHorizontalLine(Graphics2D g, JComponent c, int x, int y, int width, int height) {
        this.paintLine(g, width, height);
    }

    private void paintVerticalLine(Graphics2D g, JComponent c, int x, int y, int width, int height) {
        this.paintLine(g, width, height);
    }

    private void paintLine(Graphics2D g, int width, int height) {
        Shape s = this.shapeGenerator.createRectangle(0, height / 2, width, 1);
        g.setPaint(this.getLinePaint(s, this.tabLineInnerEdge));
        g.fill(s);
        s = this.shapeGenerator.createRectangle(0, height / 2 - 1, width, 1);
        g.setPaint(this.getLinePaint(s, this.tabLineInner));
        g.fill(s);
        s = this.shapeGenerator.createRectangle(0, height / 2 + 1, width, 1);
        g.setPaint(this.getLinePaint(s, this.tabLineInner));
        g.fill(s);
    }

    public Paint getLinePaint(Shape s, AbstractRegionPainter.TwoColors colors) {
        return this.createLineGradient(s, colors);
    }

    private Paint createLineGradient(Shape s, AbstractRegionPainter.TwoColors colors) {
        Rectangle2D bounds = s.getBounds2D();
        float x = (float)bounds.getX();
        float y = (float)bounds.getY();
        float w = (float)bounds.getWidth();
        return this.createGradient(x, y, w + x, y, new float[]{0.0f, 0.02f, 0.98f, 1.0f}, new Color[]{colors.top, colors.bottom, colors.bottom, colors.top});
    }

    public static enum Which {
        BACKGROUND_ENABLED_TOP,
        BACKGROUND_ENABLED_LEFT,
        BACKGROUND_ENABLED_BOTTOM,
        BACKGROUND_ENABLED_RIGHT,
        BACKGROUND_DISABLED_TOP,
        BACKGROUND_DISABLED_LEFT,
        BACKGROUND_DISABLED_BOTTOM,
        BACKGROUND_DISABLED_RIGHT;

    }
}

