/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.painter;

import com.seaglasslookandfeel.painter.AbstractCommonColorsPainter;
import com.seaglasslookandfeel.painter.AbstractRegionPainter;
import com.seaglasslookandfeel.painter.util.ShapeGenerator;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;

public final class SplitPaneDividerPainter
extends AbstractCommonColorsPainter {
    private Color splitPaneDividerBackgroundEnabled = this.decodeColor("control");
    private Color splitPaneDividerBackgroundOuter = this.decodeColor("splitPaneDividerBackgroundOuter");
    private AbstractRegionPainter.FourColors button = this.getCommonInteriorColors(AbstractCommonColorsPainter.CommonControlState.ENABLED);
    private AbstractRegionPainter.TwoColors splitPaneDividerBorder = this.getCommonBorderColors(AbstractCommonColorsPainter.CommonControlState.ENABLED);
    private AbstractRegionPainter.ThreeColors splitPaneDividerInterior;
    private Which state;
    private AbstractRegionPainter.PaintContext ctx;

    public SplitPaneDividerPainter(Which state) {
        this.splitPaneDividerInterior = new AbstractRegionPainter.ThreeColors(this.button.top, this.button.lowerMid, this.button.bottom);
        this.state = state;
        this.ctx = new AbstractRegionPainter.PaintContext(AbstractRegionPainter.PaintContext.CacheMode.FIXED_SIZES);
    }

    @Override
    protected void doPaint(Graphics2D g, JComponent c, int width, int height, Object[] extendedCacheKeys) {
        switch (this.state) {
            case BACKGROUND_ENABLED: {
                this.paintBackgroundEnabled(g, width, height);
                break;
            }
            case BACKGROUND_FOCUSED: {
                this.paintBackgroundFocused(g, c, width, height);
                break;
            }
            case FOREGROUND_ENABLED: {
                this.paintForegroundEnabled(g, width, height);
                break;
            }
            case FOREGROUND_ENABLED_VERTICAL: {
                this.paintForegroundEnabledAndVertical(g, width, height);
                break;
            }
            case FOREGROUND_FOCUSED: {
                this.paintForegroundFocused(g, c, width, height);
                break;
            }
            case FOREGROUND_FOCUSED_VERTICAL: {
                this.paintForegroundFocusedAndVertical(g, c, width, height);
            }
        }
    }

    @Override
    protected final AbstractRegionPainter.PaintContext getPaintContext() {
        return this.ctx;
    }

    private void paintBackgroundEnabled(Graphics2D g, int width, int height) {
        g.setPaint(this.getSplitPaneDividerBackgroundPaint());
        g.fillRect(0, 0, width, height);
        g.setPaint(this.getSplitPaneDividerBackgroundOuterPaint());
        int y = height / 2;
        g.drawLine(0, y, width - 1, y);
    }

    private void paintBackgroundFocused(Graphics2D g, JComponent c, int width, int height) {
        boolean useToolBarColors = this.isInToolBar(c);
        int y = height / 2;
        g.setPaint(this.getSplitPaneDividerBackgroundPaint());
        g.fillRect(0, 0, width, height);
        Shape s = this.shapeGenerator.createRectangle(0, y - 1, width, 3);
        g.setPaint(this.getFocusPaint(s, AbstractRegionPainter.FocusType.OUTER_FOCUS, useToolBarColors));
        g.fill(s);
        s = this.shapeGenerator.createRectangle(0, y, width, 1);
        g.setPaint(this.getFocusPaint(s, AbstractRegionPainter.FocusType.INNER_FOCUS, useToolBarColors));
        g.fill(s);
    }

    private void paintForegroundEnabledAndVertical(Graphics2D g, int width, int height) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.translate(0, height);
        g2.rotate(Math.toRadians(-90.0));
        this.paintForegroundEnabled(g2, height, width);
    }

    private void paintForegroundFocusedAndVertical(Graphics2D g, JComponent c, int width, int height) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.translate(0, height);
        g2.rotate(Math.toRadians(-90.0));
        this.paintForegroundFocused(g2, c, height, width);
    }

    private void paintForegroundFocused(Graphics2D g, JComponent c, int width, int height) {
        this.paintFocus(g, c, width, height);
        this.paintForegroundEnabled(g, width, height);
    }

    private void paintForegroundEnabled(Graphics2D g, int width, int height) {
        Shape s = this.shapeGenerator.createRoundRectangle(width / 2 - 9, height / 2 - 2, 18, 5, ShapeGenerator.CornerSize.ROUND_HEIGHT);
        g.setPaint(this.getSplitPaneDividerBorderPaint(s));
        g.fill(s);
        s = this.shapeGenerator.createRoundRectangle(width / 2 - 8, height / 2 - 1, 16, 3, ShapeGenerator.CornerSize.ROUND_HEIGHT);
        g.setPaint(this.getSplitPaneDividerInteriorPaint(s));
        g.fill(s);
    }

    private void paintFocus(Graphics2D g, JComponent c, int width, int height) {
        boolean useToolBarColors = this.isInToolBar(c);
        Shape s = this.shapeGenerator.createRoundRectangle(width / 2 - 11, height / 2 - 4, 22, 9, ShapeGenerator.CornerSize.ROUND_HEIGHT);
        g.setPaint(this.getFocusPaint(s, AbstractRegionPainter.FocusType.OUTER_FOCUS, useToolBarColors));
        g.fill(s);
        s = this.shapeGenerator.createRoundRectangle(width / 2 - 10, height / 2 - 3, 20, 7, ShapeGenerator.CornerSize.ROUND_HEIGHT);
        g.setPaint(this.getFocusPaint(s, AbstractRegionPainter.FocusType.INNER_FOCUS, useToolBarColors));
        g.fill(s);
    }

    public Paint getSplitPaneDividerBackgroundPaint() {
        return this.splitPaneDividerBackgroundEnabled;
    }

    public Paint getSplitPaneDividerBackgroundOuterPaint() {
        return this.splitPaneDividerBackgroundOuter;
    }

    public Paint getSplitPaneDividerBorderPaint(Shape s) {
        return this.decodeSplitPaneDividerBorderGradient(s, this.splitPaneDividerBorder.top, this.splitPaneDividerBorder.bottom);
    }

    public Paint getSplitPaneDividerInteriorPaint(Shape s) {
        return this.decodeSplitPaneDividerInsideGradient(s, this.splitPaneDividerInterior.top, this.splitPaneDividerInterior.mid, this.splitPaneDividerInterior.bottom);
    }

    private Paint decodeSplitPaneDividerBorderGradient(Shape s, Color border1, Color border2) {
        Rectangle2D bounds = s.getBounds2D();
        float midX = (float)bounds.getCenterX();
        float y = (float)bounds.getY();
        float h = (float)bounds.getHeight();
        return this.createGradient(midX, y, midX, y + h, new float[]{0.20645161f, 0.5f, 0.7935484f}, new Color[]{border1, this.decodeColor(border1, border2, 0.5f), border2});
    }

    private Paint decodeSplitPaneDividerInsideGradient(Shape s, Color inside1, Color inside2, Color inside3) {
        Rectangle2D bounds = s.getBounds2D();
        float midX = (float)bounds.getCenterX();
        float y = (float)bounds.getY();
        float h = (float)bounds.getHeight();
        return this.createGradient(midX, y, midX, y + h, new float[]{0.090322584f, 0.2951613f, 0.5f, 0.5822581f, 0.66451615f}, new Color[]{inside1, this.decodeColor(inside1, inside2, 0.5f), inside2, this.decodeColor(inside2, inside3, 0.5f), inside3});
    }

    public static enum Which {
        BACKGROUND_ENABLED,
        BACKGROUND_FOCUSED,
        FOREGROUND_ENABLED,
        FOREGROUND_ENABLED_VERTICAL,
        FOREGROUND_FOCUSED,
        FOREGROUND_FOCUSED_VERTICAL;

    }
}

