/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.painter;

import com.seaglasslookandfeel.painter.AbstractCommonColorsPainter;
import com.seaglasslookandfeel.painter.AbstractRegionPainter;
import com.seaglasslookandfeel.painter.util.ShapeGenerator;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import javax.swing.JComponent;

public final class SpinnerPreviousButtonPainter
extends AbstractCommonColorsPainter {
    private Color spinnerPrevBorderTopEnabled = this.decodeColor("spinnerPrevBorderTopEnabled");
    private Color spinnerPrevInteriorTopEnabled = this.decodeColor("spinnerPrevInteriorTopEnabled");
    private Color spinnerPrevInteriorBottomEnabled = this.decodeColor("spinnerPrevInteriorBottomEnabled");
    private Color spinnerPrevInteriorPressedTop = this.decodeColor("spinnerPrevInteriorPressedTop");
    private Color spinnerPrevInteriorPressedBottom = this.decodeColor("spinnerPrevInteriorPressedBottom");
    private Color spinnerPrevTopLineEnabled = this.decodeColor("spinnerPrevTopLineEnabled");
    private Color spinnerPrevTopLinePressed = this.decodeColor("spinnerPrevTopLinePressed");
    private Color scrollBarThumbBorderBasePressed = this.decodeColor("scrollBarThumbBorderBasePressed");
    private Color scrollBarThumbBorderTopPressed = this.deriveColor(this.scrollBarThumbBorderBasePressed, -0.002239f, 0.041885f, 0.0f, 0);
    private AbstractRegionPainter.TwoColors spinnerPrevBorderEnabled = new AbstractRegionPainter.TwoColors(this.spinnerPrevBorderTopEnabled, this.scrollBarThumbBorderTopPressed);
    private AbstractRegionPainter.TwoColors spinnerPrevBorderPressed = new AbstractRegionPainter.TwoColors(this.spinnerPrevBorderTopEnabled, this.scrollBarThumbBorderTopPressed);
    private AbstractRegionPainter.TwoColors spinnerPrevBorderDisabled = this.disable(this.spinnerPrevBorderEnabled);
    private AbstractRegionPainter.TwoColors spinnerPrevInteriorEnabled = new AbstractRegionPainter.TwoColors(this.spinnerPrevInteriorTopEnabled, this.spinnerPrevInteriorBottomEnabled);
    private AbstractRegionPainter.TwoColors spinnerPrevInteriorPressed = new AbstractRegionPainter.TwoColors(this.spinnerPrevInteriorPressedTop, this.spinnerPrevInteriorPressedBottom);
    private AbstractRegionPainter.TwoColors spinnerPrevInteriorDisabled = this.desaturate(this.desaturate(this.spinnerPrevInteriorEnabled));
    private Color spinnerPrevTopLineDisabled = this.desaturate(this.spinnerPrevTopLineEnabled);
    private AbstractRegionPainter.PaintContext ctx = new AbstractRegionPainter.PaintContext(AbstractRegionPainter.PaintContext.CacheMode.FIXED_SIZES);
    private AbstractCommonColorsPainter.CommonControlState type;
    private boolean focused;
    private boolean isForeground;

    public SpinnerPreviousButtonPainter(Which state) {
        this.type = this.getButtonType(state);
        this.focused = state == Which.BACKGROUND_FOCUSED || state == Which.BACKGROUND_PRESSED_FOCUSED;
        this.isForeground = this.isForeground(state);
    }

    @Override
    protected void doPaint(Graphics2D g, JComponent c, int width, int height, Object[] extendedCacheKeys) {
        if (this.isForeground) {
            this.paintArrow(g, width, height);
        } else {
            this.paintButton(g, c, width, height);
        }
    }

    @Override
    protected AbstractRegionPainter.PaintContext getPaintContext() {
        return this.ctx;
    }

    private AbstractCommonColorsPainter.CommonControlState getButtonType(Which state) {
        switch (state) {
            case BACKGROUND_DISABLED: 
            case FOREGROUND_DISABLED: {
                return AbstractCommonColorsPainter.CommonControlState.DISABLED;
            }
            case BACKGROUND_ENABLED: 
            case BACKGROUND_FOCUSED: 
            case FOREGROUND_ENABLED: 
            case FOREGROUND_FOCUSED: {
                return AbstractCommonColorsPainter.CommonControlState.ENABLED;
            }
            case BACKGROUND_PRESSED_FOCUSED: 
            case BACKGROUND_PRESSED: 
            case FOREGROUND_PRESSED_FOCUSED: 
            case FOREGROUND_PRESSED: {
                return AbstractCommonColorsPainter.CommonControlState.PRESSED;
            }
        }
        return null;
    }

    private boolean isForeground(Which state) {
        switch (state) {
            case FOREGROUND_DISABLED: 
            case FOREGROUND_ENABLED: 
            case FOREGROUND_FOCUSED: 
            case FOREGROUND_PRESSED_FOCUSED: 
            case FOREGROUND_PRESSED: {
                return true;
            }
        }
        return false;
    }

    private void paintButton(Graphics2D g, JComponent c, int width, int height) {
        Shape s;
        boolean useToolBarColors = this.isInToolBar(c);
        if (this.focused) {
            s = this.createButtonShape(0, 0, width, height, ShapeGenerator.CornerSize.OUTER_FOCUS);
            g.setPaint(this.getFocusPaint(s, AbstractRegionPainter.FocusType.OUTER_FOCUS, useToolBarColors));
            g.fill(s);
            s = this.createButtonShape(0, 0, width - 1, height - 1, ShapeGenerator.CornerSize.INNER_FOCUS);
            g.setPaint(this.getFocusPaint(s, AbstractRegionPainter.FocusType.INNER_FOCUS, useToolBarColors));
            g.fill(s);
        }
        s = this.createButtonShape(0, 0, width - 2, height - 2, ShapeGenerator.CornerSize.BORDER);
        g.setPaint(this.getSpinnerPrevBorderPaint(s, this.type));
        g.fill(s);
        s = this.createButtonShape(1, 1, width - 4, height - 4, ShapeGenerator.CornerSize.INTERIOR);
        g.setPaint(this.getSpinnerPrevInteriorPaint(s, this.type));
        g.fill(s);
        s = this.shapeGenerator.createRectangle(1, 0, width - 4, 1);
        g.setPaint(this.getSpinnerPrevTopLinePaint(s, this.type));
        g.fill(s);
    }

    private void paintArrow(Graphics2D g, int width, int height) {
        Shape s = this.createArrowShape(width, height);
        g.setPaint(this.getCommonArrowPaint(s, this.type));
        g.fill(s);
    }

    private Shape createButtonShape(int x, int y, int width, int height, ShapeGenerator.CornerSize size) {
        return this.shapeGenerator.createRoundRectangle(x, y, width, height, size, ShapeGenerator.CornerStyle.SQUARE, ShapeGenerator.CornerStyle.SQUARE, ShapeGenerator.CornerStyle.ROUNDED, ShapeGenerator.CornerStyle.SQUARE);
    }

    private Shape createArrowShape(int left, int height) {
        int centerX = left / 2 - 3;
        int centerY = height / 2;
        return this.shapeGenerator.createArrowDown(centerX, centerY - 2, 4.0, 3.0);
    }

    public Paint getSpinnerPrevBorderPaint(Shape s, AbstractCommonColorsPainter.CommonControlState type) {
        AbstractRegionPainter.TwoColors colors = this.getSpinnerPrevBorderColors(type);
        return this.createVerticalGradient(s, colors);
    }

    public Paint getSpinnerPrevTopLinePaint(Shape s, AbstractCommonColorsPainter.CommonControlState type) {
        return this.getSpinnerPrevTopLineColors(type);
    }

    public Paint getSpinnerPrevInteriorPaint(Shape s, AbstractCommonColorsPainter.CommonControlState type) {
        AbstractRegionPainter.TwoColors colors = this.getSpinnerPrevInteriorColors(type);
        return this.createVerticalGradient(s, colors);
    }

    private AbstractRegionPainter.TwoColors getSpinnerPrevBorderColors(AbstractCommonColorsPainter.CommonControlState type) {
        switch (type) {
            case DISABLED: {
                return this.spinnerPrevBorderDisabled;
            }
            case ENABLED: {
                return this.spinnerPrevBorderEnabled;
            }
            case PRESSED: {
                return this.spinnerPrevBorderPressed;
            }
        }
        return null;
    }

    private AbstractRegionPainter.TwoColors getSpinnerPrevInteriorColors(AbstractCommonColorsPainter.CommonControlState type) {
        switch (type) {
            case DISABLED: {
                return this.spinnerPrevInteriorDisabled;
            }
            case ENABLED: {
                return this.spinnerPrevInteriorEnabled;
            }
            case PRESSED: {
                return this.spinnerPrevInteriorPressed;
            }
        }
        return null;
    }

    private Color getSpinnerPrevTopLineColors(AbstractCommonColorsPainter.CommonControlState type) {
        switch (type) {
            case DISABLED: {
                return this.spinnerPrevTopLineDisabled;
            }
            case ENABLED: {
                return this.spinnerPrevTopLineEnabled;
            }
            case PRESSED: {
                return this.spinnerPrevTopLinePressed;
            }
        }
        return null;
    }

    public static enum Which {
        BACKGROUND_DISABLED,
        BACKGROUND_ENABLED,
        BACKGROUND_FOCUSED,
        BACKGROUND_PRESSED_FOCUSED,
        BACKGROUND_PRESSED,
        FOREGROUND_DISABLED,
        FOREGROUND_ENABLED,
        FOREGROUND_FOCUSED,
        FOREGROUND_PRESSED_FOCUSED,
        FOREGROUND_PRESSED;

    }
}

