/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.painter;

import com.seaglasslookandfeel.painter.AbstractCommonColorsPainter;
import com.seaglasslookandfeel.painter.AbstractRegionPainter;
import com.seaglasslookandfeel.painter.util.ShapeGenerator;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import javax.swing.JComponent;

public final class SpinnerNextButtonPainter
extends AbstractCommonColorsPainter {
    private Color spinnerNextBorderBottomEnabled = this.decodeColor("spinnerNextBorderBottomEnabled");
    private Color spinnerNextBorderBottomPressed = this.decodeColor("spinnerNextBorderBottomPressed");
    private Color spinnerNextInteriorBottomEnabled = this.decodeColor("spinnerNextInteriorBottomEnabled");
    private Color spinnerNextInteriorBottomPressed = this.decodeColor("spinnerNextInteriorBottomPressed");
    private AbstractRegionPainter.TwoColors pressedButtonBorder = this.getCommonBorderColors(AbstractCommonColorsPainter.CommonControlState.PRESSED);
    private AbstractRegionPainter.TwoColors spinnerNextBorderEnabled;
    private AbstractRegionPainter.TwoColors spinnerNextBorderPressed;
    private AbstractRegionPainter.TwoColors spinnerNextBorderDisabled;
    private AbstractRegionPainter.FourColors pressedButtonInterior;
    private AbstractRegionPainter.FourColors selectedButtonInterior;
    private AbstractRegionPainter.TwoColors spinnerNextInteriorEnabled;
    private AbstractRegionPainter.TwoColors spinnerNextInteriorPressed;
    private AbstractRegionPainter.TwoColors spinnerNextInteriorDisabled;
    private AbstractRegionPainter.PaintContext ctx;
    private AbstractCommonColorsPainter.CommonControlState type;
    private boolean focused;
    private boolean isForeground;

    public SpinnerNextButtonPainter(Which state) {
        this.spinnerNextBorderEnabled = new AbstractRegionPainter.TwoColors(this.pressedButtonBorder.top, this.spinnerNextBorderBottomEnabled);
        this.spinnerNextBorderPressed = new AbstractRegionPainter.TwoColors(this.pressedButtonBorder.top, this.spinnerNextBorderBottomPressed);
        this.spinnerNextBorderDisabled = this.disable(this.spinnerNextBorderEnabled);
        this.pressedButtonInterior = this.getCommonInteriorColors(AbstractCommonColorsPainter.CommonControlState.PRESSED);
        this.selectedButtonInterior = this.getCommonInteriorColors(AbstractCommonColorsPainter.CommonControlState.SELECTED);
        this.spinnerNextInteriorEnabled = new AbstractRegionPainter.TwoColors(this.selectedButtonInterior.top, this.spinnerNextInteriorBottomEnabled);
        this.spinnerNextInteriorPressed = new AbstractRegionPainter.TwoColors(this.pressedButtonInterior.top, this.spinnerNextInteriorBottomPressed);
        this.spinnerNextInteriorDisabled = this.desaturate(this.desaturate(this.spinnerNextInteriorEnabled));
        this.ctx = new AbstractRegionPainter.PaintContext(AbstractRegionPainter.PaintContext.CacheMode.FIXED_SIZES);
        this.type = this.getButtonType(state);
        this.focused = state == Which.BACKGROUND_FOCUSED || state == Which.BACKGROUND_PRESSED_FOCUSED;
        this.isForeground = this.isForeground(state);
    }

    @Override
    protected void doPaint(Graphics2D g, JComponent c, int width, int height, Object[] extendedCacheKeys) {
        if (this.isForeground) {
            this.paintArrow(g, width, height);
        } else {
            this.paintButton(g, c, width, height);
        }
    }

    @Override
    protected AbstractRegionPainter.PaintContext getPaintContext() {
        return this.ctx;
    }

    private AbstractCommonColorsPainter.CommonControlState getButtonType(Which state) {
        switch (state) {
            case BACKGROUND_DISABLED: 
            case FOREGROUND_DISABLED: {
                return AbstractCommonColorsPainter.CommonControlState.DISABLED;
            }
            case BACKGROUND_ENABLED: 
            case BACKGROUND_FOCUSED: 
            case FOREGROUND_ENABLED: 
            case FOREGROUND_FOCUSED: {
                return AbstractCommonColorsPainter.CommonControlState.ENABLED;
            }
            case BACKGROUND_PRESSED_FOCUSED: 
            case BACKGROUND_PRESSED: 
            case FOREGROUND_PRESSED_FOCUSED: 
            case FOREGROUND_PRESSED: {
                return AbstractCommonColorsPainter.CommonControlState.PRESSED;
            }
        }
        return null;
    }

    private boolean isForeground(Which state) {
        switch (state) {
            case FOREGROUND_DISABLED: 
            case FOREGROUND_ENABLED: 
            case FOREGROUND_FOCUSED: 
            case FOREGROUND_PRESSED_FOCUSED: 
            case FOREGROUND_PRESSED: {
                return true;
            }
        }
        return false;
    }

    private void paintButton(Graphics2D g, JComponent c, int width, int height) {
        Shape s;
        boolean useToolBarColors = this.isInToolBar(c);
        if (this.focused) {
            s = this.createButtonShape(0, 0, width, height, ShapeGenerator.CornerSize.OUTER_FOCUS);
            g.setPaint(this.getFocusPaint(s, AbstractRegionPainter.FocusType.OUTER_FOCUS, useToolBarColors));
            g.fill(s);
            s = this.createButtonShape(0, 1, width - 1, height - 1, ShapeGenerator.CornerSize.INNER_FOCUS);
            g.setPaint(this.getFocusPaint(s, AbstractRegionPainter.FocusType.INNER_FOCUS, useToolBarColors));
            g.fill(s);
        }
        s = this.createButtonShape(0, 2, width - 2, height - 2, ShapeGenerator.CornerSize.BORDER);
        g.setPaint(this.getSpinnerNextBorderPaint(s, this.type));
        g.fill(s);
        s = this.createButtonShape(1, 3, width - 4, height - 4, ShapeGenerator.CornerSize.INTERIOR);
        g.setPaint(this.getSpinnerNextInteriorPaint(s, this.type));
        g.fill(s);
    }

    private void paintArrow(Graphics2D g, int width, int height) {
        Shape s = this.createArrowShape(width, height);
        g.setPaint(this.getCommonArrowPaint(s, this.type));
        g.fill(s);
    }

    private Shape createButtonShape(int x, int y, int width, int height, ShapeGenerator.CornerSize size) {
        return this.shapeGenerator.createRoundRectangle(x, y, width, height, size, ShapeGenerator.CornerStyle.SQUARE, ShapeGenerator.CornerStyle.SQUARE, ShapeGenerator.CornerStyle.SQUARE, ShapeGenerator.CornerStyle.ROUNDED);
    }

    private Shape createArrowShape(int left, int height) {
        int centerX = left / 2 - 3;
        int centerY = height / 2;
        return this.shapeGenerator.createArrowUp(centerX, centerY, 4.0, 3.0);
    }

    public Paint getSpinnerNextBorderPaint(Shape s, AbstractCommonColorsPainter.CommonControlState type) {
        AbstractRegionPainter.TwoColors colors = this.getSpinnerNextBorderColors(type);
        return this.createVerticalGradient(s, colors);
    }

    public Paint getSpinnerNextInteriorPaint(Shape s, AbstractCommonColorsPainter.CommonControlState type) {
        AbstractRegionPainter.TwoColors colors = this.getSpinnerNextInteriorColors(type);
        return this.createVerticalGradient(s, colors);
    }

    private AbstractRegionPainter.TwoColors getSpinnerNextBorderColors(AbstractCommonColorsPainter.CommonControlState type) {
        switch (type) {
            case DISABLED: {
                return this.spinnerNextBorderDisabled;
            }
            case ENABLED: {
                return this.spinnerNextBorderEnabled;
            }
            case PRESSED: {
                return this.spinnerNextBorderPressed;
            }
        }
        return null;
    }

    private AbstractRegionPainter.TwoColors getSpinnerNextInteriorColors(AbstractCommonColorsPainter.CommonControlState type) {
        switch (type) {
            case DISABLED: {
                return this.spinnerNextInteriorDisabled;
            }
            case ENABLED: {
                return this.spinnerNextInteriorEnabled;
            }
            case PRESSED: {
                return this.spinnerNextInteriorPressed;
            }
        }
        return null;
    }

    public static enum Which {
        BACKGROUND_DISABLED,
        BACKGROUND_ENABLED,
        BACKGROUND_FOCUSED,
        BACKGROUND_PRESSED_FOCUSED,
        BACKGROUND_PRESSED,
        FOREGROUND_DISABLED,
        FOREGROUND_ENABLED,
        FOREGROUND_FOCUSED,
        FOREGROUND_PRESSED_FOCUSED,
        FOREGROUND_PRESSED;

    }
}

