/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.painter;

import com.seaglasslookandfeel.effect.SeaGlassInternalShadowEffect;
import com.seaglasslookandfeel.painter.AbstractCommonColorsPainter;
import com.seaglasslookandfeel.painter.AbstractRegionPainter;
import com.seaglasslookandfeel.painter.util.ShapeGenerator;
import java.awt.Graphics2D;
import java.awt.Shape;
import javax.swing.JComponent;

public final class SpinnerFormattedTextFieldPainter
extends AbstractCommonColorsPainter {
    private SeaGlassInternalShadowEffect internalShadow = new SeaGlassInternalShadowEffect();
    private AbstractRegionPainter.PaintContext ctx = new AbstractRegionPainter.PaintContext(AbstractRegionPainter.PaintContext.CacheMode.FIXED_SIZES);
    private AbstractCommonColorsPainter.CommonControlState type;
    private boolean focused;

    public SpinnerFormattedTextFieldPainter(Which state) {
        this.type = state == Which.BACKGROUND_DISABLED ? AbstractCommonColorsPainter.CommonControlState.DISABLED : AbstractCommonColorsPainter.CommonControlState.ENABLED;
        this.focused = state == Which.BACKGROUND_FOCUSED || state == Which.BACKGROUND_SELECTED_FOCUSED;
    }

    @Override
    protected void doPaint(Graphics2D g, JComponent c, int width, int height, Object[] extendedCacheKeys) {
        Shape s;
        boolean useFocusColors = this.isInToolBar(c);
        if (this.focused) {
            s = this.shapeGenerator.createRoundRectangle(0, 0, width, height, ShapeGenerator.CornerSize.OUTER_FOCUS, ShapeGenerator.CornerStyle.ROUNDED, ShapeGenerator.CornerStyle.ROUNDED, ShapeGenerator.CornerStyle.SQUARE, ShapeGenerator.CornerStyle.SQUARE);
            g.setPaint(this.getFocusPaint(s, AbstractRegionPainter.FocusType.OUTER_FOCUS, useFocusColors));
            g.fill(s);
            s = this.shapeGenerator.createRoundRectangle(1, 1, width - 1, height - 2, ShapeGenerator.CornerSize.INNER_FOCUS, ShapeGenerator.CornerStyle.ROUNDED, ShapeGenerator.CornerStyle.ROUNDED, ShapeGenerator.CornerStyle.SQUARE, ShapeGenerator.CornerStyle.SQUARE);
            g.setPaint(this.getFocusPaint(s, AbstractRegionPainter.FocusType.INNER_FOCUS, useFocusColors));
            g.fill(s);
        }
        g.setPaint(c.getBackground());
        s = this.shapeGenerator.createRoundRectangle(3, 3, width - 3, height - 6, ShapeGenerator.CornerSize.BORDER, ShapeGenerator.CornerStyle.ROUNDED, ShapeGenerator.CornerStyle.ROUNDED, ShapeGenerator.CornerStyle.SQUARE, ShapeGenerator.CornerStyle.SQUARE);
        g.fill(s);
        if (this.type != AbstractCommonColorsPainter.CommonControlState.DISABLED) {
            s = this.shapeGenerator.createRoundRectangle(3, 3, width - 3, height - 6, ShapeGenerator.CornerSize.BORDER, ShapeGenerator.CornerStyle.ROUNDED, ShapeGenerator.CornerStyle.ROUNDED, ShapeGenerator.CornerStyle.SQUARE, ShapeGenerator.CornerStyle.SQUARE);
            this.internalShadow.fill(g, s, false, false);
        }
        s = this.shapeGenerator.createRoundRectangle(2, 2, width - 2, height - 4 - 1, ShapeGenerator.CornerSize.BORDER, ShapeGenerator.CornerStyle.ROUNDED, ShapeGenerator.CornerStyle.ROUNDED, ShapeGenerator.CornerStyle.SQUARE, ShapeGenerator.CornerStyle.SQUARE);
        g.setPaint(this.getTextBorderPaint(this.type, false));
        g.draw(s);
    }

    @Override
    protected AbstractRegionPainter.PaintContext getPaintContext() {
        return this.ctx;
    }

    public static enum Which {
        BACKGROUND_DISABLED,
        BACKGROUND_ENABLED,
        BACKGROUND_SELECTED,
        BACKGROUND_FOCUSED,
        BACKGROUND_SELECTED_FOCUSED;

    }
}

