/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.painter;

import com.seaglasslookandfeel.effect.SeaGlassInternalShadowEffect;
import com.seaglasslookandfeel.painter.AbstractCommonColorsPainter;
import com.seaglasslookandfeel.painter.AbstractRegionPainter;
import com.seaglasslookandfeel.painter.util.ShapeGenerator;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import javax.swing.JComponent;
import javax.swing.JSlider;

public final class SliderTrackPainter
extends AbstractCommonColorsPainter {
    private Color sliderTrackInteriorBase = this.decodeColor("sliderTrackInteriorBase");
    private AbstractRegionPainter.TwoColors sliderTrackInteriorEnabled = new AbstractRegionPainter.TwoColors(this.deriveColor(this.sliderTrackInteriorBase, 0.0f, 0.0f, 0.078431f, 0), this.deriveColor(this.sliderTrackInteriorBase, 0.0f, 0.0f, 0.47451f, 0));
    private AbstractRegionPainter.TwoColors sliderTrackInteriorDisabled = this.disable(this.sliderTrackInteriorEnabled);
    private AbstractRegionPainter.FourColors interiorValueEnabled = this.getCommonInteriorColors(AbstractCommonColorsPainter.CommonControlState.SELECTED);
    private AbstractRegionPainter.FourColors interiorValueDisabled = this.disable(this.interiorValueEnabled);
    SeaGlassInternalShadowEffect effect = new SeaGlassInternalShadowEffect();
    private Which state;
    private AbstractRegionPainter.PaintContext ctx;

    public SliderTrackPainter(Which state) {
        this.state = state;
        this.ctx = new AbstractRegionPainter.PaintContext(AbstractRegionPainter.PaintContext.CacheMode.NO_CACHING);
    }

    @Override
    protected void doPaint(Graphics2D g, JComponent c, int width, int height, Object[] extendedCacheKeys) {
        Shape s = this.shapeGenerator.createRoundRectangle(0, 0, width, height, ShapeGenerator.CornerSize.ROUND_HEIGHT);
        g.setPaint(this.getSliderTrackBorderPaint(s));
        g.fill(s);
        s = this.shapeGenerator.createRoundRectangle(1, 1, width - 2, height - 2, ShapeGenerator.CornerSize.ROUND_HEIGHT);
        g.setPaint(this.getSliderTrackInteriorPaint(s));
        g.fill(s);
        this.effect.fill(g, s, false, false);
        this.paintValueTrack(g, c, width, height);
    }

    private void paintValueTrack(Graphics2D g, JComponent c, int width, int height) {
        JSlider slider = (JSlider)c;
        int orientation = slider.getOrientation();
        double trackLength = slider.getMaximum() - slider.getMinimum();
        double percentFilled = (double)slider.getValue() / trackLength;
        if (percentFilled > 0.0) {
            Shape s = this.getValueShape(c, width, height, orientation, percentFilled);
            g.setPaint(this.getValuePaint(s));
            g.fill(s);
        }
    }

    private Shape getValueShape(JComponent c, int width, int height, int orientation, double percentFilled) {
        JSlider slider = (JSlider)c;
        Shape s = orientation == 0 && slider.getComponentOrientation().isLeftToRight() || slider.getInverted() ? this.shapeGenerator.createRoundRectangle(1, 1, (int)((double)width * percentFilled), height - 2, ShapeGenerator.CornerSize.ROUND_HEIGHT) : this.shapeGenerator.createRoundRectangle(width - (int)((double)width * percentFilled), 1, width, height - 2, ShapeGenerator.CornerSize.ROUND_HEIGHT);
        return s;
    }

    public Paint getValuePaint(Shape s) {
        AbstractRegionPainter.FourColors colors = this.getValueColors();
        return this.createVerticalGradient(s, colors);
    }

    private AbstractRegionPainter.FourColors getValueColors() {
        switch (this.state) {
            case BACKGROUND_ENABLED: {
                return this.interiorValueEnabled;
            }
            case BACKGROUND_DISABLED: {
                return this.interiorValueDisabled;
            }
        }
        return null;
    }

    @Override
    protected AbstractRegionPainter.PaintContext getPaintContext() {
        return this.ctx;
    }

    public Paint getSliderTrackBorderPaint(Shape s) {
        return this.getSliderTrackBorderColors();
    }

    public Paint getSliderTrackInteriorPaint(Shape s) {
        return this.createVerticalGradient(s, this.getSliderTrackInteriorColors());
    }

    private Paint getSliderTrackBorderColors() {
        switch (this.state) {
            case BACKGROUND_DISABLED: {
                return this.getTextBorderPaint(AbstractCommonColorsPainter.CommonControlState.DISABLED, false);
            }
            case BACKGROUND_ENABLED: {
                return this.getTextBorderPaint(AbstractCommonColorsPainter.CommonControlState.ENABLED, false);
            }
        }
        return null;
    }

    private AbstractRegionPainter.TwoColors getSliderTrackInteriorColors() {
        switch (this.state) {
            case BACKGROUND_DISABLED: {
                return this.sliderTrackInteriorDisabled;
            }
            case BACKGROUND_ENABLED: {
                return this.sliderTrackInteriorEnabled;
            }
        }
        return null;
    }

    public static enum Which {
        BACKGROUND_DISABLED,
        BACKGROUND_ENABLED;

    }
}

