/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.painter;

import com.seaglasslookandfeel.effect.Effect;
import com.seaglasslookandfeel.effect.SeaGlassDropShadowEffect;
import com.seaglasslookandfeel.painter.AbstractCommonColorsPainter;
import com.seaglasslookandfeel.painter.AbstractRegionPainter;
import com.seaglasslookandfeel.painter.util.ShapeGenerator;
import java.awt.Graphics2D;
import java.awt.Shape;
import javax.swing.JComponent;

public final class SliderThumbPainter
extends AbstractCommonColorsPainter {
    private static final Effect dropShadow = new SeaGlassDropShadowEffect();
    private AbstractRegionPainter.PaintContext ctx = new AbstractRegionPainter.PaintContext(AbstractRegionPainter.PaintContext.CacheMode.FIXED_SIZES);
    private AbstractCommonColorsPainter.CommonControlState type;
    private boolean isFocused;
    private boolean isDiscrete;

    public SliderThumbPainter(Which state) {
        switch (state) {
            case BACKGROUND_DISABLED: {
                this.type = AbstractCommonColorsPainter.CommonControlState.DISABLED;
                this.isFocused = false;
                this.isDiscrete = false;
                break;
            }
            case BACKGROUND_ENABLED: 
            case BACKGROUND_MOUSEOVER: {
                this.type = AbstractCommonColorsPainter.CommonControlState.ENABLED;
                this.isFocused = false;
                this.isDiscrete = false;
                break;
            }
            case BACKGROUND_PRESSED: {
                this.type = AbstractCommonColorsPainter.CommonControlState.PRESSED;
                this.isFocused = false;
                this.isDiscrete = false;
                break;
            }
            case BACKGROUND_FOCUSED: 
            case BACKGROUND_FOCUSED_MOUSEOVER: {
                this.type = AbstractCommonColorsPainter.CommonControlState.ENABLED;
                this.isFocused = true;
                this.isDiscrete = false;
                break;
            }
            case BACKGROUND_FOCUSED_PRESSED: {
                this.type = AbstractCommonColorsPainter.CommonControlState.PRESSED;
                this.isFocused = true;
                this.isDiscrete = false;
                break;
            }
            case BACKGROUND_DISABLED_ARROWSHAPE: {
                this.type = AbstractCommonColorsPainter.CommonControlState.DISABLED;
                this.isFocused = false;
                this.isDiscrete = true;
                break;
            }
            case BACKGROUND_ENABLED_ARROWSHAPE: 
            case BACKGROUND_MOUSEOVER_ARROWSHAPE: {
                this.type = AbstractCommonColorsPainter.CommonControlState.ENABLED;
                this.isFocused = false;
                this.isDiscrete = true;
                break;
            }
            case BACKGROUND_PRESSED_ARROWSHAPE: {
                this.type = AbstractCommonColorsPainter.CommonControlState.PRESSED;
                this.isFocused = false;
                this.isDiscrete = true;
                break;
            }
            case BACKGROUND_FOCUSED_ARROWSHAPE: 
            case BACKGROUND_FOCUSED_MOUSEOVER_ARROWSHAPE: {
                this.type = AbstractCommonColorsPainter.CommonControlState.ENABLED;
                this.isFocused = true;
                this.isDiscrete = true;
                break;
            }
            case BACKGROUND_FOCUSED_PRESSED_ARROWSHAPE: {
                this.type = AbstractCommonColorsPainter.CommonControlState.PRESSED;
                this.isFocused = true;
                this.isDiscrete = true;
            }
        }
    }

    @Override
    protected void doPaint(Graphics2D g, JComponent c, int width, int height, Object[] extendedCacheKeys) {
        Boolean forceArrow = (Boolean)c.getClientProperty("Slider.paintThumbArrowShape");
        if (this.isDiscrete || forceArrow != null && forceArrow == Boolean.TRUE) {
            this.paintDiscrete(g, c, width, height);
        } else {
            this.paintContinuous(g, c, width, height);
        }
    }

    @Override
    protected AbstractRegionPainter.PaintContext getPaintContext() {
        return this.ctx;
    }

    private void paintDiscrete(Graphics2D g, JComponent c, int width, int height) {
        Shape s;
        boolean useToolBarColors = this.isInToolBar(c);
        if (this.isFocused) {
            s = this.shapeGenerator.createSliderThumbDiscrete(0, 0, width, height, ShapeGenerator.CornerSize.SLIDER_OUTER_FOCUS);
            g.setPaint(this.getFocusPaint(s, AbstractRegionPainter.FocusType.OUTER_FOCUS, useToolBarColors));
            g.fill(s);
            s = this.shapeGenerator.createSliderThumbDiscrete(1, 1, width - 2, height - 2, ShapeGenerator.CornerSize.SLIDER_INNER_FOCUS);
            g.setPaint(this.getFocusPaint(s, AbstractRegionPainter.FocusType.INNER_FOCUS, useToolBarColors));
            g.fill(s);
        }
        s = this.shapeGenerator.createSliderThumbDiscrete(2, 2, width - 4, height - 4, ShapeGenerator.CornerSize.SLIDER_BORDER);
        if (!this.isFocused) {
            dropShadow.fill(g, s);
        }
        g.setPaint(this.getCommonBorderPaint(s, this.type));
        g.fill(s);
        s = this.shapeGenerator.createSliderThumbDiscrete(3, 3, width - 6, height - 6, ShapeGenerator.CornerSize.SLIDER_INTERIOR);
        g.setPaint(this.getCommonInteriorPaint(s, this.type));
        g.fill(s);
    }

    private void paintContinuous(Graphics2D g, JComponent c, int width, int height) {
        Shape s;
        boolean useToolBarColors = this.isInToolBar(c);
        if (this.isFocused) {
            s = this.shapeGenerator.createSliderThumbContinuous(0, 1, width);
            g.setPaint(this.getFocusPaint(s, AbstractRegionPainter.FocusType.OUTER_FOCUS, useToolBarColors));
            g.fill(s);
            s = this.shapeGenerator.createSliderThumbContinuous(1, 2, width - 2);
            g.setPaint(this.getFocusPaint(s, AbstractRegionPainter.FocusType.INNER_FOCUS, useToolBarColors));
            g.fill(s);
        }
        s = this.shapeGenerator.createSliderThumbContinuous(2, 3, width - 4);
        if (!this.isFocused) {
            dropShadow.fill(g, s);
        }
        g.setPaint(this.getCommonBorderPaint(s, this.type));
        g.fill(s);
        s = this.shapeGenerator.createSliderThumbContinuous(3, 4, width - 6);
        g.setPaint(this.getCommonInteriorPaint(s, this.type));
        g.fill(s);
    }

    public static enum Which {
        BACKGROUND_DISABLED,
        BACKGROUND_ENABLED,
        BACKGROUND_FOCUSED,
        BACKGROUND_FOCUSED_MOUSEOVER,
        BACKGROUND_FOCUSED_PRESSED,
        BACKGROUND_MOUSEOVER,
        BACKGROUND_PRESSED,
        BACKGROUND_ENABLED_ARROWSHAPE,
        BACKGROUND_DISABLED_ARROWSHAPE,
        BACKGROUND_MOUSEOVER_ARROWSHAPE,
        BACKGROUND_PRESSED_ARROWSHAPE,
        BACKGROUND_FOCUSED_ARROWSHAPE,
        BACKGROUND_FOCUSED_MOUSEOVER_ARROWSHAPE,
        BACKGROUND_FOCUSED_PRESSED_ARROWSHAPE;

    }
}

