/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.painter;

import com.seaglasslookandfeel.effect.SeaGlassInternalShadowEffect;
import com.seaglasslookandfeel.painter.AbstractCommonColorsPainter;
import com.seaglasslookandfeel.painter.AbstractRegionPainter;
import com.seaglasslookandfeel.painter.util.ShapeGenerator;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import javax.swing.JComponent;

public final class SearchFieldPainter
extends AbstractCommonColorsPainter {
    private SeaGlassInternalShadowEffect internalShadow = new SeaGlassInternalShadowEffect();
    private Which state;
    private AbstractRegionPainter.PaintContext ctx;
    private AbstractCommonColorsPainter.CommonControlState type;
    private boolean focused;

    public SearchFieldPainter(Which state) {
        this.state = state;
        this.ctx = new AbstractRegionPainter.PaintContext(AbstractRegionPainter.PaintContext.CacheMode.FIXED_SIZES);
        this.type = state == Which.BACKGROUND_DISABLED || state == Which.BORDER_DISABLED ? AbstractCommonColorsPainter.CommonControlState.DISABLED : AbstractCommonColorsPainter.CommonControlState.ENABLED;
        this.focused = state == Which.BORDER_FOCUSED;
    }

    @Override
    protected void doPaint(Graphics2D g, JComponent c, int width, int height, Object[] extendedCacheKeys) {
        int x = this.focusInsets.left;
        int y = this.focusInsets.top;
        width -= this.focusInsets.left + this.focusInsets.right;
        height -= this.focusInsets.top + this.focusInsets.bottom;
        switch (this.state) {
            case BACKGROUND_DISABLED: 
            case BACKGROUND_ENABLED: 
            case BACKGROUND_SELECTED: {
                this.paintBackground(g, c, x, y, width, height);
                break;
            }
            case BORDER_DISABLED: 
            case BORDER_ENABLED: 
            case BORDER_FOCUSED: {
                this.paintBorder(g, c, x, y, width, height);
            }
        }
    }

    @Override
    protected AbstractRegionPainter.PaintContext getPaintContext() {
        return this.ctx;
    }

    private void paintBackground(Graphics2D g, JComponent c, int x, int y, int width, int height) {
        Color color = c.getBackground();
        if (this.type == AbstractCommonColorsPainter.CommonControlState.DISABLED) {
            color = new Color(color.getRed(), color.getGreen(), color.getBlue(), 128);
        }
        Shape s = this.shapeGenerator.createRoundRectangle(x + 1, y + 1, width - 2, height - 2, ShapeGenerator.CornerSize.ROUND_HEIGHT);
        g.setPaint(color);
        g.fill(s);
    }

    private void paintBorder(Graphics2D g, JComponent c, int x, int y, int width, int height) {
        Shape s;
        boolean useToolBarColors = this.isInToolBar(c);
        if (this.focused) {
            s = this.shapeGenerator.createRoundRectangle(x - 2, y - 2, width + 4 - 1, height + 4 - 1, ShapeGenerator.CornerSize.ROUND_HEIGHT_DRAW);
            g.setPaint(this.getFocusPaint(s, AbstractRegionPainter.FocusType.OUTER_FOCUS, useToolBarColors));
            g.draw(s);
            s = this.shapeGenerator.createRoundRectangle(x - 1, y - 1, width + 2 - 1, height + 2 - 1, ShapeGenerator.CornerSize.ROUND_HEIGHT_DRAW);
            g.setPaint(this.getFocusPaint(s, AbstractRegionPainter.FocusType.INNER_FOCUS, useToolBarColors));
            g.draw(s);
        }
        if (this.type != AbstractCommonColorsPainter.CommonControlState.DISABLED) {
            s = this.shapeGenerator.createInternalDropShadowRounded(x + 1, y + 1, width - 2, height - 2);
            this.internalShadow.fill(g, s, true, true);
        }
        g.setPaint(this.getTextBorderPaint(this.type, !this.focused && useToolBarColors));
        s = this.shapeGenerator.createRoundRectangle(x, y, width - 1, height - 1, ShapeGenerator.CornerSize.ROUND_HEIGHT_DRAW);
        g.draw(s);
    }

    public static enum Which {
        BACKGROUND_DISABLED,
        BACKGROUND_ENABLED,
        BACKGROUND_SELECTED,
        BORDER_DISABLED,
        BORDER_FOCUSED,
        BORDER_ENABLED;

    }
}

