/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.painter;

import com.seaglasslookandfeel.painter.AbstractRegionPainter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import javax.swing.JComponent;

public final class SearchFieldIconPainter
extends AbstractRegionPainter {
    private Color searchIconColor = this.decodeColor("seaGlassSearchIcon");
    private Color cancelIconColor = this.decodeColor("seaGlassCancelIcon");
    private Color cancelIconPressedColor = this.decodeColor("seaGlassCancelIconPressed");
    private Which state;
    private AbstractRegionPainter.PaintContext ctx;

    public SearchFieldIconPainter(Which state) {
        this.state = state;
        this.ctx = new AbstractRegionPainter.PaintContext(AbstractRegionPainter.PaintContext.CacheMode.FIXED_SIZES);
    }

    @Override
    protected void doPaint(Graphics2D g, JComponent c, int width, int height, Object[] extendedCacheKeys) {
        switch (this.state) {
            case FIND_ICON_ENABLED: {
                this.paintSearchGlass(g, 0, 0, width, height, false);
                break;
            }
            case FIND_ICON_ENABLED_POPUP: {
                this.paintSearchGlass(g, 0, 0, width, height, true);
                break;
            }
            case CANCEL_ICON_ENABLED: {
                this.paintCancelIcon(g, 0, 0, width, height, this.cancelIconColor);
                break;
            }
            case CANCEL_ICON_PRESSED: {
                this.paintCancelIcon(g, 0, 0, width, height, this.cancelIconPressedColor);
            }
        }
    }

    @Override
    protected AbstractRegionPainter.PaintContext getPaintContext() {
        return this.ctx;
    }

    private void paintSearchGlass(Graphics2D g, int x, int y, int width, int height, boolean hasPopup) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int glassX = 2;
        int glassY = 2;
        int glassRadius = 8;
        g.setStroke(new BasicStroke(2.0f));
        g.setColor(this.searchIconColor);
        g.drawOval(2, 2, 8, 8);
        int handleOffset = 7;
        int handleX = 9;
        int handleY = 9;
        int handleLength = 3;
        g.drawLine(9, 9, 12, 12);
        if (hasPopup) {
            int popupX = 13;
            int popupY = 5;
            Shape s = this.shapeGenerator.createArrowDown(13.0, 5.0, 7.0, 4.0);
            g.setColor(this.searchIconColor);
            g.fill(s);
        }
    }

    private void paintCancelIcon(Graphics2D g, int x, int y, int width, int height, Color color) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Shape s = this.shapeGenerator.createCancelIcon(2, 2, width - 4, height - 4);
        g.setColor(color);
        g.fill(s);
    }

    public static enum Which {
        FIND_ICON_DISABLED,
        FIND_ICON_ENABLED,
        FIND_ICON_ENABLED_POPUP,
        CANCEL_ICON_DISABLED,
        CANCEL_ICON_ENABLED,
        CANCEL_ICON_PRESSED;

    }
}

