/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.painter;

import com.seaglasslookandfeel.painter.AbstractRegionPainter;
import com.seaglasslookandfeel.painter.util.ShapeGenerator;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public final class ScrollPanePainter
extends AbstractRegionPainter {
    private Which state;
    private AbstractRegionPainter.PaintContext ctx;
    private Color borderColor = this.decodeColor("seaGlassTextEnabledBorder");
    private Color cornerColor1 = new Color(250, 250, 250);
    private Color cornerColor2 = new Color(190, 190, 190);

    public ScrollPanePainter(Which state) {
        this.state = state;
        this.ctx = new AbstractRegionPainter.PaintContext(AbstractRegionPainter.PaintContext.CacheMode.FIXED_SIZES);
    }

    @Override
    protected void doPaint(Graphics2D g, JComponent c, int width, int height, Object[] extendedCacheKeys) {
        switch (this.state) {
            case BACKGROUND_ENABLED: {
                this.paintBackground(g, c, width, height);
                break;
            }
            case BORDER_ENABLED: {
                this.paintBorderEnabled(g, width, height);
                break;
            }
            case BORDER_ENABLED_FOCUSED: {
                this.paintBorderFocused(g, width, height);
                break;
            }
            case CORNER_ENABLED: {
                this.paintCornerEnabled(g, width, height);
            }
        }
    }

    private void paintBackground(Graphics2D g, JComponent c, int width, int height) {
        JViewport viewport = ((JScrollPane)c).getViewport();
        if (viewport.isOpaque()) {
            Shape s = this.shapeGenerator.createRoundRectangle(0, 0, width - 1, height - 1, ShapeGenerator.CornerSize.BORDER);
            g.setPaint(viewport.getBackground());
            g.fill(s);
        }
    }

    @Override
    protected AbstractRegionPainter.PaintContext getPaintContext() {
        return this.ctx;
    }

    private void paintBorderEnabled(Graphics2D g, int width, int height) {
        Shape s = this.shapeGenerator.createRoundRectangle(0, 0, width - 1, height - 1, ShapeGenerator.CornerSize.BORDER);
        g.setPaint(this.borderColor);
        g.draw(s);
    }

    private void paintBorderFocused(Graphics2D g, int width, int height) {
        Shape s = this.shapeGenerator.createRoundRectangle(0, 0, width - 1, height - 1, ShapeGenerator.CornerSize.OUTER_FOCUS);
        g.setPaint(this.getFocusPaint(s, AbstractRegionPainter.FocusType.OUTER_FOCUS, false));
        g.draw(s);
        s = this.shapeGenerator.createRoundRectangle(1, 1, width - 3, height - 3, ShapeGenerator.CornerSize.INNER_FOCUS);
        g.setPaint(this.getFocusPaint(s, AbstractRegionPainter.FocusType.INNER_FOCUS, false));
        g.draw(s);
        s = this.shapeGenerator.createRoundRectangle(2, 2, width - 5, height - 5, ShapeGenerator.CornerSize.BORDER);
        g.setPaint(this.borderColor);
        g.draw(s);
    }

    private void paintCornerEnabled(Graphics2D g, int width, int height) {
        Shape s = this.decodeCornerBorder(width, height);
        s = this.decodeCornerInside(width, height);
        g.setPaint(this.decodeCornerGradient(s));
        g.fill(s);
    }

    private Shape decodeCornerBorder(int width, int height) {
        return this.shapeGenerator.createRectangle(0, 0, width, height);
    }

    private Shape decodeCornerInside(int width, int height) {
        return this.shapeGenerator.createRectangle(0, 0, width, height);
    }

    private Paint decodeCornerGradient(Shape s) {
        Rectangle2D bounds = s.getBounds2D();
        float w = (float)bounds.getWidth();
        float h = (float)bounds.getHeight();
        return this.createGradient(0.0f, 0.0f, w - 1.0f, h - 1.0f, new float[]{0.0f, 1.0f}, new Color[]{this.cornerColor2, this.cornerColor1});
    }

    public static enum Which {
        BACKGROUND_ENABLED,
        BORDER_ENABLED,
        BORDER_ENABLED_FOCUSED,
        CORNER_ENABLED;

    }
}

