/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.painter;

import com.seaglasslookandfeel.painter.AbstractRegionPainter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.JComponent;

public final class ScrollBarTrackPainter
extends AbstractRegionPainter {
    private Color scrollBarTrackBackgroundBase = this.decodeColor("scrollBarTrackBackgroundBase");
    private Color scrollBarTrackGradientBase = this.decodeColor("scrollBarTrackGradientBase");
    private Color scrollBarTrackBackgroundTop = this.deriveColor(this.scrollBarTrackBackgroundBase, 0.0f, 0.0f, -0.066667f, 0);
    private Color scrollBarTrackBackgroundBottom = this.scrollBarTrackBackgroundBase;
    private Color scrollBarTrackGradientTop = this.deriveColor(this.scrollBarTrackGradientBase, 0.0f, 0.0f, 0.0f, 51);
    private Color scrollBarTrackGradientUpperMid = this.deriveColor(this.scrollBarTrackGradientBase, 0.0f, 0.0f, 0.0f, 21);
    private Color scrollBarTrackGradientLowerMid = this.scrollBarTrackGradientBase;
    private Color scrollBarTrackGradientBottom = this.deriveColor(this.scrollBarTrackGradientBase, 0.0f, 0.0f, 0.0f, 18);
    private AbstractRegionPainter.TwoColors scrollBarTrackBackground = new AbstractRegionPainter.TwoColors(this.scrollBarTrackBackgroundTop, this.scrollBarTrackBackgroundBottom);
    private AbstractRegionPainter.FourColors scrollBarTrackGradient = new AbstractRegionPainter.FourColors(this.scrollBarTrackGradientTop, this.scrollBarTrackGradientUpperMid, this.scrollBarTrackGradientLowerMid, this.scrollBarTrackGradientBottom);
    private AbstractRegionPainter.PaintContext ctx = new AbstractRegionPainter.PaintContext(AbstractRegionPainter.PaintContext.CacheMode.FIXED_SIZES);

    public ScrollBarTrackPainter(Which state) {
    }

    @Override
    protected void doPaint(Graphics2D g, JComponent c, int width, int height, Object[] extendedCacheKeys) {
        Shape s = this.shapeGenerator.createRectangle(0, 0, width, height);
        g.setPaint(this.getScrollBarTrackBackgroundPaint(s));
        g.fill(s);
        g.setPaint(this.getScrollBarTrackShadowPaint(s));
        g.fill(s);
    }

    @Override
    protected AbstractRegionPainter.PaintContext getPaintContext() {
        return this.ctx;
    }

    public Paint getScrollBarTrackBackgroundPaint(Shape s) {
        return this.createVerticalGradient(s, this.scrollBarTrackBackground);
    }

    public Paint getScrollBarTrackShadowPaint(Shape s) {
        return this.createScrollBarTrackInnerShadowGradient(s, this.scrollBarTrackGradient);
    }

    private Paint createScrollBarTrackInnerShadowGradient(Shape s, AbstractRegionPainter.FourColors colors) {
        Rectangle bounds = s.getBounds();
        int width = bounds.width;
        int height = bounds.height;
        return this.createGradient((float)width * 0.5f, 0.0f, (float)width * 0.5f, height - 1, new float[]{0.0f, 0.14285715f, 0.5f, 0.78571427f, 1.0f}, new Color[]{colors.top, colors.upperMid, colors.lowerMid, colors.lowerMid, colors.bottom});
    }

    public static enum Which {
        BACKGROUND_DISABLED,
        BACKGROUND_ENABLED;

    }
}

