/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.painter;

import com.seaglasslookandfeel.painter.AbstractCommonColorsPainter;
import com.seaglasslookandfeel.painter.AbstractRegionPainter;
import com.seaglasslookandfeel.painter.util.ShapeGenerator;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import javax.swing.JComponent;

public final class ScrollBarThumbPainter
extends AbstractCommonColorsPainter {
    private Color scrollBarThumbBorderBasePressed = this.decodeColor("scrollBarThumbBorderBasePressed");
    private Color scrollBarThumbInteriorBasePressed = this.decodeColor("scrollBarThumbInteriorBasePressed");
    private Color scrollBarThumbBorderTopPressed = this.deriveColor(this.scrollBarThumbBorderBasePressed, -0.002239f, 0.041885f, 0.0f, 0);
    private Color scrollBarThumbBorderBottomPressed = this.deriveColor(this.scrollBarThumbBorderBasePressed, 0.003151f, -0.036649f, 0.0f, 0);
    private AbstractRegionPainter.TwoColors scrollBarThumbBorderPressed = new AbstractRegionPainter.TwoColors(this.scrollBarThumbBorderTopPressed, this.scrollBarThumbBorderBottomPressed);
    private Color scrollBarThumbInteriorTopPressed = this.deriveColor(this.scrollBarThumbInteriorBasePressed, -0.014978f, -0.078885f, 0.168627f, 0);
    private Color scrollBarThumbInteriorUpperMidPressed = this.deriveColor(this.scrollBarThumbInteriorBasePressed, 5.65E-4f, 0.041623f, 0.015686f, 0);
    private Color scrollBarThumbInteriorLowerMidPressed = this.deriveColor(this.scrollBarThumbInteriorBasePressed, 3.56E-4f, 0.025917f, 0.007843f, 0);
    private Color scrollBarThumbInteriorBottomPressed = this.deriveColor(this.scrollBarThumbInteriorBasePressed, 0.0f, -0.195001f, 0.082353f, 0);
    private AbstractRegionPainter.FourColors scrollBarThumbInteriorPressed = new AbstractRegionPainter.FourColors(this.scrollBarThumbInteriorTopPressed, this.scrollBarThumbInteriorUpperMidPressed, this.scrollBarThumbInteriorLowerMidPressed, this.scrollBarThumbInteriorBottomPressed);
    private AbstractRegionPainter.PaintContext ctx = new AbstractRegionPainter.PaintContext(AbstractRegionPainter.PaintContext.CacheMode.FIXED_SIZES);
    private AbstractCommonColorsPainter.CommonControlState type;

    public ScrollBarThumbPainter(Which state) {
        this.type = this.getButtonType(state);
    }

    @Override
    protected void doPaint(Graphics2D g, JComponent c, int width, int height, Object[] extendedCacheKeys) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Shape s = this.shapeGenerator.createRoundRectangle(0, 0, width, height, ShapeGenerator.CornerSize.ROUND_HEIGHT);
        g.setPaint(this.getScrollBarThumbBorderPaint(s, this.type));
        g.fill(s);
        s = this.shapeGenerator.createRoundRectangle(1, 1, width - 2, height - 2, ShapeGenerator.CornerSize.ROUND_HEIGHT);
        g.setPaint(this.getScrollBarThumbInteriorPaint(s, this.type));
        g.fill(s);
    }

    @Override
    protected AbstractRegionPainter.PaintContext getPaintContext() {
        return this.ctx;
    }

    private AbstractCommonColorsPainter.CommonControlState getButtonType(Which state) {
        switch (state) {
            case BACKGROUND_DISABLED: {
                return AbstractCommonColorsPainter.CommonControlState.DISABLED;
            }
            case BACKGROUND_ENABLED: {
                return AbstractCommonColorsPainter.CommonControlState.ENABLED;
            }
            case BACKGROUND_PRESSED: {
                return AbstractCommonColorsPainter.CommonControlState.PRESSED;
            }
        }
        return null;
    }

    public Paint getScrollBarThumbBorderPaint(Shape s, AbstractCommonColorsPainter.CommonControlState type) {
        AbstractRegionPainter.TwoColors colors = this.getCommonBorderColors(type);
        return this.createVerticalGradient(s, colors);
    }

    public Paint getScrollBarThumbInteriorPaint(Shape s, AbstractCommonColorsPainter.CommonControlState type) {
        AbstractRegionPainter.FourColors colors = this.getCommonInteriorColors(type);
        return this.createVerticalGradient(s, colors);
    }

    @Override
    public AbstractRegionPainter.TwoColors getCommonBorderColors(AbstractCommonColorsPainter.CommonControlState type) {
        switch (type) {
            case DISABLED: 
            case DISABLED_SELECTED: 
            case ENABLED: {
                return super.getCommonBorderColors(type);
            }
            case PRESSED: {
                return this.scrollBarThumbBorderPressed;
            }
        }
        return null;
    }

    @Override
    public AbstractRegionPainter.FourColors getCommonInteriorColors(AbstractCommonColorsPainter.CommonControlState type) {
        switch (type) {
            case DISABLED: 
            case DISABLED_SELECTED: 
            case ENABLED: {
                return super.getCommonInteriorColors(type);
            }
            case PRESSED: {
                return this.scrollBarThumbInteriorPressed;
            }
        }
        return null;
    }

    public static enum Which {
        BACKGROUND_DISABLED,
        BACKGROUND_ENABLED,
        BACKGROUND_PRESSED;

    }
}

