/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.painter;

import com.seaglasslookandfeel.effect.DropShadowEffect;
import com.seaglasslookandfeel.effect.Effect;
import com.seaglasslookandfeel.painter.AbstractRegionPainter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import javax.swing.JComponent;

public final class ScrollBarButtonPainter
extends AbstractRegionPainter {
    private Color scrollBarButtonBase = this.decodeColor("scrollBarButtonBase");
    private Color scrollBarButtonBasePressed = this.decodeColor("scrollBarButtonBasePressed");
    private AbstractRegionPainter.TwoColors scrollBarCapColors = new AbstractRegionPainter.TwoColors(this.scrollBarButtonBase, this.deriveColor(this.scrollBarButtonBase, 0.0f, 0.0f, -0.266667f, 0));
    private Color scrollBarButtonTopPressed = this.deriveColor(this.scrollBarButtonBasePressed, 7.37E-4f, -0.105657f, 0.101961f, 0);
    private Color scrollBarButtonMiddlePressed = this.deriveColor(this.scrollBarButtonBasePressed, 0.00124f, -0.041156f, 0.035294f, 0);
    private Color scrollBarButtonBottomPressed = this.deriveColor(this.scrollBarButtonBasePressed, 3.48E-4f, 0.050949f, -0.039216f, 0);
    private Color scrollBarButtonLinePressedColor = this.deriveColor(this.scrollBarButtonBasePressed, -0.0014f, 0.11016f, -0.043137f, 0);
    private AbstractRegionPainter.TwoColors scrollBarButtonIncreaseApart = new AbstractRegionPainter.TwoColors(this.deriveColor(this.scrollBarButtonBase, 0.0f, 0.0f, -0.180392f, 0), this.scrollBarButtonBase);
    private AbstractRegionPainter.TwoColors scrollBarButtonIncreaseTogether = new AbstractRegionPainter.TwoColors(this.deriveColor(this.scrollBarButtonBase, 0.0f, 0.0f, -0.180392f, 0), this.deriveColor(this.scrollBarButtonBase, 0.0f, 0.0f, -0.101961f, 0));
    private AbstractRegionPainter.TwoColors scrollBarButtonIncreasePressed = new AbstractRegionPainter.TwoColors(this.scrollBarButtonMiddlePressed, this.scrollBarButtonBottomPressed);
    private AbstractRegionPainter.TwoColors scrollBarButtonDecreaseApart = new AbstractRegionPainter.TwoColors(this.scrollBarButtonBase, this.deriveColor(this.scrollBarButtonBase, 0.0f, 0.0f, -0.2f, 0));
    private AbstractRegionPainter.TwoColors scrollBarButtonDecreaseTogether = new AbstractRegionPainter.TwoColors(this.scrollBarButtonBase, this.deriveColor(this.scrollBarButtonBase, 0.0f, 0.0f, -0.086275f, 0));
    private AbstractRegionPainter.TwoColors scrollBarButtonDecreasePressed = new AbstractRegionPainter.TwoColors(this.scrollBarButtonTopPressed, this.scrollBarButtonMiddlePressed);
    private Color scrollBarButtonLine = this.deriveColor(this.scrollBarButtonBase, 0.0f, 0.0f, -0.258824f, 0);
    private Color scrollBarButtonLinePressed = this.scrollBarButtonLinePressedColor;
    private Color scrollBarButtonArrow = this.deriveColor(this.scrollBarButtonBase, 0.0f, 0.0f, -0.666667f, 0);
    private Color scrollBarButtonArrowDisabled = this.disable(this.scrollBarButtonArrow);
    private Color scrollBarButtonDarkDivider = this.deriveColor(this.scrollBarButtonBase, 0.0f, 0.0f, -1.0f, -((int)((float)this.scrollBarButtonBase.getAlpha() * 0.8784314f)));
    private Color scrollBarButtonLightDivider = this.deriveColor(this.scrollBarButtonBase, 0.0f, 0.0f, 0.0f, -((int)((float)this.scrollBarButtonBase.getAlpha() * 0.7529412f)));
    private Effect dropShadow = new ScrollButtonDropShadowEffect();
    private Which state;
    private AbstractRegionPainter.PaintContext ctx;
    private boolean isPressed;
    private boolean isDisabled;
    private boolean isIncrease;
    private boolean buttonsTogether;

    public ScrollBarButtonPainter(Which state) {
        this.state = state;
        this.ctx = new AbstractRegionPainter.PaintContext(AbstractRegionPainter.PaintContext.CacheMode.FIXED_SIZES);
        this.isPressed = false;
        this.isDisabled = false;
        switch (state) {
            case FOREGROUND_DISABLED: {
                this.isDisabled = true;
                this.isIncrease = false;
                this.buttonsTogether = false;
                break;
            }
            case FOREGROUND_DISABLED_TOGETHER: {
                this.isDisabled = true;
                this.isIncrease = false;
                this.buttonsTogether = true;
                break;
            }
            case FOREGROUND_ENABLED: {
                this.isIncrease = false;
                this.buttonsTogether = false;
                break;
            }
            case FOREGROUND_ENABLED_TOGETHER: {
                this.isIncrease = false;
                this.buttonsTogether = true;
                break;
            }
            case FOREGROUND_PRESSED: {
                this.isPressed = true;
                this.isIncrease = false;
                this.buttonsTogether = false;
                break;
            }
            case FOREGROUND_PRESSED_TOGETHER: {
                this.isPressed = true;
                this.isIncrease = false;
                this.buttonsTogether = true;
                break;
            }
            case FOREGROUND_INCREASE_DISABLED: {
                this.isDisabled = true;
                this.isIncrease = true;
                this.buttonsTogether = false;
                break;
            }
            case FOREGROUND_INCREASE_DISABLED_TOGETHER: {
                this.isDisabled = true;
                this.isIncrease = true;
                this.buttonsTogether = true;
                break;
            }
            case FOREGROUND_INCREASE_ENABLED: {
                this.isIncrease = true;
                this.buttonsTogether = false;
                break;
            }
            case FOREGROUND_INCREASE_ENABLED_TOGETHER: {
                this.isIncrease = true;
                this.buttonsTogether = true;
                break;
            }
            case FOREGROUND_INCREASE_PRESSED: {
                this.isPressed = true;
                this.isIncrease = true;
                this.buttonsTogether = false;
                break;
            }
            case FOREGROUND_INCREASE_PRESSED_TOGETHER: {
                this.isPressed = true;
                this.isIncrease = true;
                this.buttonsTogether = true;
                break;
            }
            case FOREGROUND_CAP: {
                this.isIncrease = false;
                this.buttonsTogether = true;
            }
        }
    }

    @Override
    protected void doPaint(Graphics2D g, JComponent c, int width, int height, Object[] extendedCacheKeys) {
        switch (this.state) {
            case FOREGROUND_DISABLED: 
            case FOREGROUND_ENABLED: 
            case FOREGROUND_PRESSED: {
                this.paintBackgroundApart(g, width, height);
                this.paintDecreaseButtonApart(g, width, height);
                break;
            }
            case FOREGROUND_DISABLED_TOGETHER: 
            case FOREGROUND_ENABLED_TOGETHER: 
            case FOREGROUND_PRESSED_TOGETHER: {
                this.paintBackgroundTogetherDecrease(g, width, height);
                this.paintDecreaseButtonTogether(g, width, height);
                break;
            }
            case FOREGROUND_INCREASE_DISABLED: 
            case FOREGROUND_INCREASE_ENABLED: 
            case FOREGROUND_INCREASE_PRESSED: {
                this.paintBackgroundApart(g, width, height);
                this.paintIncreaseButtonApart(g, width, height);
                break;
            }
            case FOREGROUND_INCREASE_DISABLED_TOGETHER: 
            case FOREGROUND_INCREASE_ENABLED_TOGETHER: 
            case FOREGROUND_INCREASE_PRESSED_TOGETHER: {
                this.paintBackgroundTogetherIncrease(g, width, height);
                this.paintIncreaseButtonTogether(g, width, height);
                break;
            }
            case FOREGROUND_CAP: {
                this.paintBackgroundCap(g, width, height);
            }
        }
    }

    @Override
    protected AbstractRegionPainter.PaintContext getPaintContext() {
        return this.ctx;
    }

    private void paintBackgroundCap(Graphics2D g, int width, int height) {
        Shape s = this.shapeGenerator.createScrollCap(0, 0, width, height);
        this.dropShadow.fill(g, s);
        this.fillScrollBarButtonInteriorColors(g, s, this.isIncrease, this.buttonsTogether);
    }

    private void paintBackgroundApart(Graphics2D g, int width, int height) {
        Shape s = this.shapeGenerator.createScrollButtonApart(0, 0, width, height);
        this.dropShadow.fill(g, s);
        this.fillScrollBarButtonInteriorColors(g, s, this.isIncrease, this.buttonsTogether);
    }

    private void paintBackgroundTogetherDecrease(Graphics2D g, int width, int height) {
        Shape s = this.shapeGenerator.createScrollButtonTogetherDecrease(0, 0, width, height);
        this.dropShadow.fill(g, s);
        this.fillScrollBarButtonInteriorColors(g, s, this.isIncrease, this.buttonsTogether);
    }

    private void paintBackgroundTogetherIncrease(Graphics2D g, int width, int height) {
        Shape s = this.shapeGenerator.createScrollButtonTogetherIncrease(0, 0, width, height);
        this.dropShadow.fill(g, s);
        this.fillScrollBarButtonInteriorColors(g, s, this.isIncrease, this.buttonsTogether);
    }

    private void fillScrollBarButtonInteriorColors(Graphics2D g, Shape s, boolean isIncrease, boolean buttonsTogether) {
        g.setPaint(this.getScrollBarButtonBackgroundPaint(s, isIncrease, buttonsTogether));
        g.fill(s);
        int width = s.getBounds().width;
        g.setPaint(this.getScrollBarButtonLinePaint());
        g.drawLine(0, 0, width - 1, 0);
        if (this.state != Which.FOREGROUND_CAP && buttonsTogether) {
            int height = s.getBounds().height;
            g.setPaint(this.getScrollBarButtonDividerPaint(isIncrease));
            g.drawLine(width - 1, 1, width - 1, height - 1);
        }
    }

    private void paintIncreaseButtonApart(Graphics2D g, int width, int height) {
        this.paintArrowButton(g, (double)width / 2.0 - 5.0, (double)height / 2.0 - 2.0);
    }

    private void paintDecreaseButtonApart(Graphics2D g, int width, int height) {
        this.paintArrowButton(g, (double)width / 2.0 - 4.0, (double)height / 2.0 - 3.0);
    }

    private void paintIncreaseButtonTogether(Graphics2D g, int width, int height) {
        this.paintArrowButton(g, (double)width / 2.0 - 3.0, (double)height / 2.0 - 3.0);
    }

    private void paintDecreaseButtonTogether(Graphics2D g, int width, int height) {
        this.paintArrowButton(g, (double)width / 2.0, (double)height / 2.0 - 3.0);
    }

    private void paintArrowButton(Graphics2D g, double x, double y) {
        Shape s = this.shapeGenerator.createArrowLeft(x, y, 4.0, 6.0);
        g.setPaint(this.getScrollBarButtonArrowPaint());
        g.fill(s);
    }

    public Paint getScrollBarButtonBackgroundPaint(Shape s, boolean isIncrease, boolean buttonsTogether) {
        AbstractRegionPainter.TwoColors colors = this.getScrollBarButtonBackgroundColors(buttonsTogether, isIncrease);
        return this.createHorizontalGradient(s, colors);
    }

    public Paint getScrollBarButtonLinePaint() {
        return this.getScrollBarButtonLineColor();
    }

    public Paint getScrollBarButtonDividerPaint(boolean isIncrease) {
        return isIncrease ? this.scrollBarButtonLightDivider : this.scrollBarButtonDarkDivider;
    }

    public Paint getScrollBarButtonArrowPaint() {
        return this.getScrollBarButtonArrowColor();
    }

    private AbstractRegionPainter.TwoColors getScrollBarButtonBackgroundColors(boolean buttonsTogether, boolean isIncrease) {
        if (this.state == Which.FOREGROUND_CAP) {
            return this.scrollBarCapColors;
        }
        if (this.isPressed) {
            return isIncrease ? this.scrollBarButtonIncreasePressed : this.scrollBarButtonDecreasePressed;
        }
        if (buttonsTogether) {
            return isIncrease ? this.scrollBarButtonIncreaseTogether : this.scrollBarButtonDecreaseTogether;
        }
        return isIncrease ? this.scrollBarButtonIncreaseApart : this.scrollBarButtonDecreaseApart;
    }

    private Color getScrollBarButtonLineColor() {
        if (this.isPressed) {
            return this.scrollBarButtonLinePressed;
        }
        return this.scrollBarButtonLine;
    }

    private Color getScrollBarButtonArrowColor() {
        if (this.isDisabled) {
            return this.scrollBarButtonArrowDisabled;
        }
        return this.scrollBarButtonArrow;
    }

    private static class ScrollButtonDropShadowEffect
    extends DropShadowEffect {
        public ScrollButtonDropShadowEffect() {
            this.color = new Color(150, 150, 150);
            this.angle = 0;
            this.distance = 0;
            this.size = 3;
            this.opacity = 0.25f;
        }
    }

    public static enum Which {
        FOREGROUND_ENABLED,
        FOREGROUND_DISABLED,
        FOREGROUND_PRESSED,
        FOREGROUND_INCREASE_ENABLED,
        FOREGROUND_INCREASE_DISABLED,
        FOREGROUND_INCREASE_PRESSED,
        FOREGROUND_ENABLED_TOGETHER,
        FOREGROUND_DISABLED_TOGETHER,
        FOREGROUND_PRESSED_TOGETHER,
        FOREGROUND_INCREASE_ENABLED_TOGETHER,
        FOREGROUND_INCREASE_DISABLED_TOGETHER,
        FOREGROUND_INCREASE_PRESSED_TOGETHER,
        FOREGROUND_CAP;

    }
}

