/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.painter;

import com.seaglasslookandfeel.effect.Effect;
import com.seaglasslookandfeel.effect.SeaGlassDropShadowEffect;
import com.seaglasslookandfeel.painter.AbstractCommonColorsPainter;
import com.seaglasslookandfeel.painter.AbstractRegionPainter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import javax.swing.JComponent;

public final class RadioButtonPainter
extends AbstractCommonColorsPainter {
    private Color buttonBulletBottomEnabled = this.decodeColor("buttonBulletBottomEnabled");
    private AbstractRegionPainter.TwoColors buttonBulletEnabled = new AbstractRegionPainter.TwoColors(this.deriveColor(this.buttonBulletBottomEnabled, 0.0f, 0.0f, 0.2f, 0), this.buttonBulletBottomEnabled);
    private AbstractRegionPainter.TwoColors buttonbulletDisabled = this.disable(this.buttonBulletEnabled);
    private Effect dropShadow = new SeaGlassDropShadowEffect();
    private AbstractRegionPainter.PaintContext ctx = new AbstractRegionPainter.PaintContext(AbstractRegionPainter.PaintContext.CacheMode.FIXED_SIZES);
    private boolean focused;
    private boolean selected;
    private AbstractCommonColorsPainter.CommonControlState type;

    public RadioButtonPainter(Which state) {
        switch (state) {
            case ICON_DISABLED: 
            case ICON_ENABLED: 
            case ICON_PRESSED: 
            case ICON_SELECTED: 
            case ICON_PRESSED_SELECTED: 
            case ICON_DISABLED_SELECTED: {
                this.focused = false;
                break;
            }
            case ICON_FOCUSED: 
            case ICON_PRESSED_FOCUSED: 
            case ICON_SELECTED_FOCUSED: 
            case ICON_PRESSED_SELECTED_FOCUSED: {
                this.focused = true;
            }
        }
        switch (state) {
            case ICON_SELECTED: 
            case ICON_PRESSED_SELECTED: 
            case ICON_DISABLED_SELECTED: 
            case ICON_SELECTED_FOCUSED: 
            case ICON_PRESSED_SELECTED_FOCUSED: {
                this.selected = true;
                break;
            }
            default: {
                this.selected = false;
            }
        }
        this.type = this.getButtonType(state);
    }

    @Override
    protected void doPaint(Graphics2D g, JComponent c, int width, int height, Object[] extendedCacheKeys) {
        Shape s;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.focused) {
            boolean useToolBarFocus = this.isInToolBar(c);
            s = this.createBasicShape(width, width, height);
            g.setPaint(this.getFocusPaint(s, AbstractRegionPainter.FocusType.OUTER_FOCUS, useToolBarFocus));
            g.fill(s);
            s = this.createBasicShape(width - 2, width, height);
            g.setPaint(this.getFocusPaint(s, AbstractRegionPainter.FocusType.INNER_FOCUS, useToolBarFocus));
            g.fill(s);
        }
        s = this.createBasicShape(width - 4, width, height);
        if (!this.focused) {
            this.dropShadow.fill(g, s);
        }
        g.setPaint(this.getCommonBorderPaint(s, this.type));
        g.fill(s);
        s = this.createBasicShape(width - 6, width, height);
        g.setPaint(this.getCommonInteriorPaint(s, this.type));
        g.fill(s);
        if (this.selected) {
            s = this.createBasicShape((double)width / 4.5, width, height);
            g.setPaint(this.getRadioButtonBulletPaint(s, this.type));
            g.fill(s);
        }
    }

    private AbstractCommonColorsPainter.CommonControlState getButtonType(Which state) {
        switch (state) {
            case ICON_DISABLED: 
            case ICON_DISABLED_SELECTED: {
                return AbstractCommonColorsPainter.CommonControlState.DISABLED;
            }
            case ICON_ENABLED: 
            case ICON_FOCUSED: {
                return AbstractCommonColorsPainter.CommonControlState.ENABLED;
            }
            case ICON_PRESSED: 
            case ICON_PRESSED_FOCUSED: {
                return AbstractCommonColorsPainter.CommonControlState.PRESSED;
            }
            case ICON_SELECTED: 
            case ICON_SELECTED_FOCUSED: {
                return AbstractCommonColorsPainter.CommonControlState.SELECTED;
            }
            case ICON_PRESSED_SELECTED: 
            case ICON_PRESSED_SELECTED_FOCUSED: {
                return AbstractCommonColorsPainter.CommonControlState.PRESSED_SELECTED;
            }
        }
        return null;
    }

    @Override
    protected AbstractRegionPainter.PaintContext getPaintContext() {
        return this.ctx;
    }

    private Shape createBasicShape(double diameter, int width, int height) {
        int pos = (int)(((double)width - diameter) / 2.0 + 0.5);
        int iDiameter = (int)(diameter + 0.5);
        return this.shapeGenerator.createRadioButton(pos, pos, iDiameter);
    }

    public Paint getRadioButtonBulletPaint(Shape s, AbstractCommonColorsPainter.CommonControlState type) {
        AbstractRegionPainter.TwoColors colors = this.getRadioButtonBulletColors(type);
        return this.createVerticalGradient(s, colors);
    }

    private AbstractRegionPainter.TwoColors getRadioButtonBulletColors(AbstractCommonColorsPainter.CommonControlState type) {
        switch (type) {
            case DISABLED: 
            case DISABLED_SELECTED: {
                return this.buttonbulletDisabled;
            }
            case ENABLED: 
            case PRESSED: 
            case SELECTED: 
            case PRESSED_SELECTED: {
                return this.buttonBulletEnabled;
            }
        }
        return null;
    }

    public static enum Which {
        ICON_DISABLED,
        ICON_ENABLED,
        ICON_FOCUSED,
        ICON_PRESSED,
        ICON_PRESSED_FOCUSED,
        ICON_SELECTED,
        ICON_SELECTED_FOCUSED,
        ICON_PRESSED_SELECTED,
        ICON_PRESSED_SELECTED_FOCUSED,
        ICON_DISABLED_SELECTED;

    }
}

