/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.painter;

import com.seaglasslookandfeel.painter.AbstractRegionPainter;
import com.seaglasslookandfeel.painter.MenuItemPainter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import javax.swing.JComponent;

public final class RadioButtonMenuItemPainter
extends MenuItemPainter {
    private Which state;
    private AbstractRegionPainter.PaintContext ctx;
    private Color iconDisabledSelected = this.decodeColor("seaGlassDisabledText");
    private Color iconEnabled = this.decodeColor("seaGlassMenuIcon");
    private Color iconEnabledSelected = this.decodeColor("seaGlassMenuIcon");
    private Color iconSelectedMouseOver = this.decodeColor("seaGlassSelectedText");

    public RadioButtonMenuItemPainter(Which state) {
        super(MenuItemPainter.Which.BACKGROUND_ENABLED);
        this.state = state;
        switch (state) {
            case BACKGROUND_DISABLED: 
            case BACKGROUND_ENABLED: 
            case BACKGROUND_MOUSEOVER: 
            case BACKGROUND_SELECTED_MOUSEOVER: {
                this.ctx = new AbstractRegionPainter.PaintContext(AbstractRegionPainter.PaintContext.CacheMode.NO_CACHING);
                break;
            }
            default: {
                this.ctx = new AbstractRegionPainter.PaintContext(AbstractRegionPainter.PaintContext.CacheMode.FIXED_SIZES);
            }
        }
    }

    @Override
    protected void doPaint(Graphics2D g, JComponent c, int width, int height, Object[] extendedCacheKeys) {
        switch (this.state) {
            case BACKGROUND_MOUSEOVER: {
                this.paintBackgroundMouseOver(g, c, width, height);
                break;
            }
            case BACKGROUND_SELECTED_MOUSEOVER: {
                this.paintBackgroundMouseOver(g, c, width, height);
                break;
            }
            case CHECKICON_DISABLED_SELECTED: {
                this.paintCheckIconDisabledAndSelected(g, width, height);
                break;
            }
            case CHECKICON_ENABLED_SELECTED: {
                this.paintCheckIconEnabledAndSelected(g, width, height);
                break;
            }
            case CHECKICON_ENABLED: {
                this.paintCheckIconEnabled(g, width, height);
                break;
            }
            case CHECKICON_ENABLED_MOUSEOVER: {
                this.paintCheckIconEnabledAndMouseOver(g, width, height);
                break;
            }
            case CHECKICON_SELECTED_MOUSEOVER: {
                this.paintCheckIconSelectedAndMouseOver(g, width, height);
            }
        }
    }

    @Override
    protected final AbstractRegionPainter.PaintContext getPaintContext() {
        return this.ctx;
    }

    private void paintCheckIconDisabledAndSelected(Graphics2D g, int width, int height) {
        g.setPaint(this.iconDisabledSelected);
        this.drawRadioIcon(g, width, height);
    }

    private void paintCheckIconEnabledAndSelected(Graphics2D g, int width, int height) {
        g.setPaint(this.iconEnabledSelected);
        this.drawRadioIcon(g, width, height);
    }

    private void drawRadioIcon(Graphics2D g, int width, int height) {
        Shape s = this.createRadioBullet(width, height);
        g.draw(s);
        g.fillOval(2, 3, 5, 5);
    }

    private void paintCheckIconEnabled(Graphics2D g, int width, int height) {
        g.setPaint(this.iconEnabled);
        Shape s = this.createRadioBullet(width, height);
        g.draw(s);
    }

    private void paintCheckIconSelectedAndMouseOver(Graphics2D g, int width, int height) {
        g.setPaint(this.iconSelectedMouseOver);
        this.drawRadioIcon(g, width, height);
    }

    private void paintCheckIconEnabledAndMouseOver(Graphics2D g, int width, int height) {
        g.setPaint(this.iconSelectedMouseOver);
        Shape s = this.createRadioBullet(width, height);
        g.draw(s);
    }

    private Shape createRadioBullet(int width, int height) {
        int radius = Math.min(width, height) - 1;
        return this.shapeGenerator.createBullet(0, 1, radius);
    }

    public static enum Which {
        BACKGROUND_DISABLED,
        BACKGROUND_ENABLED,
        BACKGROUND_MOUSEOVER,
        BACKGROUND_SELECTED_MOUSEOVER,
        CHECKICON_DISABLED_SELECTED,
        CHECKICON_ENABLED_SELECTED,
        CHECKICON_ENABLED_MOUSEOVER,
        CHECKICON_SELECTED_MOUSEOVER,
        CHECKICON_ENABLED;

    }
}

