/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.painter;

import com.seaglasslookandfeel.effect.Effect;
import com.seaglasslookandfeel.effect.SeaGlassDropShadowEffect;
import com.seaglasslookandfeel.effect.SeaGlassInternalShadowEffect;
import com.seaglasslookandfeel.painter.AbstractCommonColorsPainter;
import com.seaglasslookandfeel.painter.AbstractRegionPainter;
import com.seaglasslookandfeel.painter.util.ShapeGenerator;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import javax.swing.JComponent;

public final class ProgressBarPainter
extends AbstractCommonColorsPainter {
    private Color progressBarTrackInteriorEnabled = this.decodeColor("progressBarTrackInterior");
    private Color buttonInteriorBaseSelected = this.decodeColor("buttonInteriorBaseSelected");
    private Color progressBarTrackBase = this.decodeColor("progressBarTrackBase");
    private Color progressBarTrackInteriorDisabled = this.disable(this.progressBarTrackInteriorEnabled);
    private AbstractRegionPainter.TwoColors progressBarTrackEnabled = new AbstractRegionPainter.TwoColors(this.deriveColor(this.progressBarTrackBase, -7.49E-4f, 0.005236f, 0.0f, 0), this.progressBarTrackBase);
    private AbstractRegionPainter.TwoColors progressBarTrackDisabled = this.disable(this.progressBarTrackEnabled);
    private Color progressBarEndEnabled = this.deriveColor(this.buttonInteriorBaseSelected, 0.00637f, 0.274445f, -0.07451f, 0);
    private Color progressBarEndDisabled = this.disable(this.progressBarEndEnabled);
    private AbstractRegionPainter.FourColors progressBarEnabled = this.getCommonInteriorColors(AbstractCommonColorsPainter.CommonControlState.SELECTED);
    private AbstractRegionPainter.FourColors progressBarDisabled = this.disable(this.progressBarEnabled);
    private AbstractRegionPainter.FourColors progressBarIndeterminatePatternEnabled = this.getCommonInteriorColors(AbstractCommonColorsPainter.CommonControlState.ENABLED);
    private AbstractRegionPainter.FourColors progressBarIndeterminatePatternDisabled = this.disable(this.progressBarIndeterminatePatternEnabled);
    private Effect dropShadow = new SeaGlassDropShadowEffect();
    private SeaGlassInternalShadowEffect internalShadow = new SeaGlassInternalShadowEffect();
    private Which state;
    private AbstractRegionPainter.PaintContext ctx;
    private AbstractCommonColorsPainter.CommonControlState type;

    public ProgressBarPainter(Which state) {
        this.state = state;
        this.ctx = new AbstractRegionPainter.PaintContext(AbstractRegionPainter.PaintContext.CacheMode.FIXED_SIZES);
        this.type = this.getButtonType(state);
    }

    @Override
    protected void doPaint(Graphics2D g, JComponent c, int width, int height, Object[] extendedCacheKeys) {
        switch (this.state) {
            case BACKGROUND_ENABLED: {
                this.paintTrack(g, width, height);
                break;
            }
            case BACKGROUND_DISABLED: {
                this.paintTrack(g, width, height);
                break;
            }
            case FOREGROUND_ENABLED: {
                this.paintBar(g, width, height, false);
                break;
            }
            case FOREGROUND_ENABLED_FINISHED: {
                this.paintBar(g, width, height, true);
                break;
            }
            case FOREGROUND_ENABLED_INDETERMINATE: {
                this.paintIndeterminateBar(g, width, height);
                break;
            }
            case FOREGROUND_DISABLED: {
                this.paintBar(g, width, height, false);
                break;
            }
            case FOREGROUND_DISABLED_FINISHED: {
                this.paintBar(g, width, height, true);
                break;
            }
            case FOREGROUND_DISABLED_INDETERMINATE: {
                this.paintIndeterminateBar(g, width, height);
            }
        }
    }

    @Override
    protected AbstractRegionPainter.PaintContext getPaintContext() {
        return this.ctx;
    }

    private AbstractCommonColorsPainter.CommonControlState getButtonType(Which state) {
        switch (state) {
            case BACKGROUND_DISABLED: 
            case FOREGROUND_DISABLED: 
            case FOREGROUND_DISABLED_FINISHED: 
            case FOREGROUND_DISABLED_INDETERMINATE: {
                return AbstractCommonColorsPainter.CommonControlState.DISABLED;
            }
            case BACKGROUND_ENABLED: 
            case FOREGROUND_ENABLED: 
            case FOREGROUND_ENABLED_FINISHED: 
            case FOREGROUND_ENABLED_INDETERMINATE: {
                return AbstractCommonColorsPainter.CommonControlState.ENABLED;
            }
        }
        return null;
    }

    private void paintTrack(Graphics2D g, int width, int height) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Shape s = this.shapeGenerator.createRoundRectangle(2, 2, width - 5, height - 5, ShapeGenerator.CornerSize.ROUND_HEIGHT_DRAW);
        if (this.state != Which.BACKGROUND_DISABLED) {
            this.dropShadow.fill(g, s);
        }
        g.setPaint(this.getProgressBarBorderPaint(s, this.type));
        g.draw(s);
        s = this.shapeGenerator.createRoundRectangle(3, 3, width - 6, height - 6, ShapeGenerator.CornerSize.ROUND_HEIGHT);
        g.setPaint(this.getProgressBarTrackPaint(s, this.type));
        g.fill(s);
        s = this.shapeGenerator.createInternalDropShadowRounded(3, 3, width - 6, height - 8);
        this.internalShadow.fill(g, s, true, true);
    }

    private void paintBar(Graphics2D g, int width, int height, boolean isFinished) {
        Shape s = this.shapeGenerator.createRectangle(0, 0, width, height);
        g.setPaint(this.getProgressBarPaint(s, this.type));
        g.fill(s);
        if (!isFinished) {
            s = this.shapeGenerator.createRectangle(width - 1, 0, 1, height);
            g.setPaint(this.getProgressBarEndPaint(s, this.type));
            g.fill(s);
        }
    }

    private void paintIndeterminateBar(Graphics2D g, int width, int height) {
        Shape s = this.shapeGenerator.createRectangle(0, 0, width, height);
        g.setPaint(this.getProgressBarPaint(s, this.type));
        g.fill(s);
        s = this.shapeGenerator.createProgressBarIndeterminatePattern(0, 0, width, height);
        g.setPaint(this.getProgressBarIndeterminatePaint(s, this.type));
        g.fill(s);
    }

    public Paint getProgressBarEndPaint(Shape s, AbstractCommonColorsPainter.CommonControlState type) {
        return this.getProgressBarEndColor(type);
    }

    private Color getProgressBarEndColor(AbstractCommonColorsPainter.CommonControlState type) {
        switch (type) {
            case ENABLED: {
                return this.progressBarEndEnabled;
            }
            case DISABLED: {
                return this.progressBarEndDisabled;
            }
        }
        return null;
    }

    public Paint getProgressBarBorderPaint(Shape s, AbstractCommonColorsPainter.CommonControlState type) {
        AbstractRegionPainter.TwoColors colors = this.getProgressBarBorderColors(type);
        return this.createVerticalGradient(s, colors);
    }

    private AbstractRegionPainter.TwoColors getProgressBarBorderColors(AbstractCommonColorsPainter.CommonControlState type) {
        switch (type) {
            case ENABLED: {
                return this.progressBarTrackEnabled;
            }
            case DISABLED: {
                return this.progressBarTrackDisabled;
            }
        }
        return null;
    }

    public Paint getProgressBarTrackPaint(Shape s, AbstractCommonColorsPainter.CommonControlState type) {
        return this.getProgressBarTrackColors(type);
    }

    private Color getProgressBarTrackColors(AbstractCommonColorsPainter.CommonControlState type) {
        switch (type) {
            case ENABLED: {
                return this.progressBarTrackInteriorEnabled;
            }
            case DISABLED: {
                return this.progressBarTrackInteriorDisabled;
            }
        }
        return null;
    }

    public Paint getProgressBarPaint(Shape s, AbstractCommonColorsPainter.CommonControlState type) {
        AbstractRegionPainter.FourColors colors = this.getProgressBarColors(type);
        return this.createVerticalGradient(s, colors);
    }

    public Paint getProgressBarIndeterminatePaint(Shape s, AbstractCommonColorsPainter.CommonControlState type) {
        AbstractRegionPainter.FourColors colors = this.getProgressBarIndeterminateColors(type);
        return this.createVerticalGradient(s, colors);
    }

    private AbstractRegionPainter.FourColors getProgressBarColors(AbstractCommonColorsPainter.CommonControlState type) {
        switch (type) {
            case ENABLED: {
                return this.progressBarEnabled;
            }
            case DISABLED: {
                return this.progressBarDisabled;
            }
        }
        return null;
    }

    private AbstractRegionPainter.FourColors getProgressBarIndeterminateColors(AbstractCommonColorsPainter.CommonControlState type) {
        switch (type) {
            case ENABLED: {
                return this.progressBarIndeterminatePatternEnabled;
            }
            case DISABLED: {
                return this.progressBarIndeterminatePatternDisabled;
            }
        }
        return null;
    }

    public static enum Which {
        BACKGROUND_ENABLED,
        BACKGROUND_DISABLED,
        FOREGROUND_ENABLED,
        FOREGROUND_ENABLED_FINISHED,
        FOREGROUND_ENABLED_INDETERMINATE,
        FOREGROUND_DISABLED,
        FOREGROUND_DISABLED_FINISHED,
        FOREGROUND_DISABLED_INDETERMINATE;

    }
}

