/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.painter;

import com.seaglasslookandfeel.painter.AbstractRegionPainter;
import com.seaglasslookandfeel.painter.util.ShapeGenerator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;

public final class PopupMenuPainter
extends AbstractRegionPainter {
    private Color popupMenuInteriorEnabled = this.decodeColor("popupMenuInteriorEnabled");
    private Color popupMenuBorderEnabled = this.decodeColor("popupMenuBorderEnabled");
    private Color popupMenuBorderDisabled = this.disable(this.popupMenuBorderEnabled);
    private Color popupMenuInteriorDisabled = this.disable(this.popupMenuBorderEnabled);
    private Which state;
    private AbstractRegionPainter.PaintContext ctx;

    public PopupMenuPainter(Which state) {
        this.state = state;
        this.ctx = new AbstractRegionPainter.PaintContext(AbstractRegionPainter.PaintContext.CacheMode.NO_CACHING);
    }

    @Override
    protected void doPaint(Graphics2D g, JComponent c, int width, int height, Object[] extendedCacheKeys) {
        ShapeGenerator.CornerStyle topLeftCornerStyle = this.getTopLeftCornerStyle(c);
        Shape s = this.shapeGenerator.createRoundRectangle(0, 0, width, height, ShapeGenerator.CornerSize.POPUP_BORDER, topLeftCornerStyle, ShapeGenerator.CornerStyle.ROUNDED, ShapeGenerator.CornerStyle.ROUNDED, ShapeGenerator.CornerStyle.ROUNDED);
        g.setPaint(this.getPopupMenuBorderPaint(s));
        g.fill(s);
        s = this.shapeGenerator.createRoundRectangle(1, 1, width - 2, height - 2, ShapeGenerator.CornerSize.POPUP_INTERIOR, topLeftCornerStyle, ShapeGenerator.CornerStyle.ROUNDED, ShapeGenerator.CornerStyle.ROUNDED, ShapeGenerator.CornerStyle.ROUNDED);
        g.setPaint(this.getPopupMenuInteriorPaint(s));
        g.fill(s);
    }

    private ShapeGenerator.CornerStyle getTopLeftCornerStyle(JComponent c) {
        Component invoker = this.getInvoker(c);
        ShapeGenerator.CornerStyle topLeftCornerStyle = ShapeGenerator.CornerStyle.ROUNDED;
        if (invoker instanceof JMenu) {
            topLeftCornerStyle = ShapeGenerator.CornerStyle.SQUARE;
        }
        return topLeftCornerStyle;
    }

    private Component getInvoker(JComponent c) {
        JPopupMenu popup = (JPopupMenu)c;
        return popup.getInvoker();
    }

    @Override
    protected AbstractRegionPainter.PaintContext getPaintContext() {
        return this.ctx;
    }

    public Paint getPopupMenuBorderPaint(Shape s) {
        return this.getPopupMenuBorderColors();
    }

    public Paint getPopupMenuInteriorPaint(Shape s) {
        return this.getPopupMenuInteriorColors();
    }

    private Color getPopupMenuBorderColors() {
        switch (this.state) {
            case BACKGROUND_ENABLED: {
                return this.popupMenuBorderEnabled;
            }
            case BACKGROUND_DISABLED: {
                return this.popupMenuBorderDisabled;
            }
        }
        return null;
    }

    private Color getPopupMenuInteriorColors() {
        switch (this.state) {
            case BACKGROUND_ENABLED: {
                return this.popupMenuInteriorEnabled;
            }
            case BACKGROUND_DISABLED: {
                return this.popupMenuInteriorDisabled;
            }
        }
        return null;
    }

    public static enum Which {
        BACKGROUND_DISABLED,
        BACKGROUND_ENABLED;

    }
}

