/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.painter;

import com.seaglasslookandfeel.icons.ErrorSign;
import com.seaglasslookandfeel.icons.InfoSign;
import com.seaglasslookandfeel.icons.QuestionSign;
import com.seaglasslookandfeel.icons.WarningSign;
import com.seaglasslookandfeel.painter.AbstractRegionPainter;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.swing.JComponent;

public final class OptionPanePainter
extends AbstractRegionPainter {
    private Which state;
    private AbstractRegionPainter.PaintContext ctx;

    public OptionPanePainter(Which state) {
        this.state = state;
        this.ctx = new AbstractRegionPainter.PaintContext(AbstractRegionPainter.PaintContext.CacheMode.NO_CACHING);
    }

    @Override
    protected void doPaint(Graphics2D g, JComponent c, int width, int height, Object[] extendedCacheKeys) {
        switch (this.state) {
            case ERRORICON_ENABLED: {
                this.paintErrorSign(g, c, width, height);
                break;
            }
            case INFORMATIONICON_ENABLED: {
                this.paintInfoSign(g, c, width, height);
                break;
            }
            case QUESTIONICON_ENABLED: {
                this.paintQuestionSign(g, c, width, height);
                break;
            }
            case WARNINGICON_ENABLED: {
                this.paintWarningSign(g, c, width, height);
            }
        }
    }

    private void paintWarningSign(Graphics2D g, JComponent c, int width, int height) {
        WarningSign icon = new WarningSign();
        icon.setDimension(new Dimension(width, height));
        icon.paintIcon(c, g, -3, -3);
    }

    private void paintQuestionSign(Graphics2D g, JComponent c, int width, int height) {
        QuestionSign icon = new QuestionSign();
        icon.setDimension(new Dimension(width, height));
        icon.paintIcon(c, g, -3, -3);
    }

    private void paintInfoSign(Graphics2D g, JComponent c, int width, int height) {
        InfoSign icon = new InfoSign();
        icon.setDimension(new Dimension(width, height));
        icon.paintIcon(c, g, -3, -3);
    }

    private void paintErrorSign(Graphics2D g, JComponent c, int width, int height) {
        ErrorSign icon = new ErrorSign();
        icon.setDimension(new Dimension(width, height));
        icon.paintIcon(c, g, 0, 0);
    }

    @Override
    protected AbstractRegionPainter.PaintContext getPaintContext() {
        return this.ctx;
    }

    public static enum Which {
        ERRORICON_ENABLED,
        INFORMATIONICON_ENABLED,
        QUESTIONICON_ENABLED,
        WARNINGICON_ENABLED;

    }
}

