/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.painter;

import com.seaglasslookandfeel.painter.AbstractRegionPainter;
import com.seaglasslookandfeel.painter.MenuItemPainter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import javax.swing.JComponent;

public final class MenuPainter
extends MenuItemPainter {
    private Which state;
    private AbstractRegionPainter.PaintContext ctx;
    private Color iconDisabledSelected = this.decodeColor("seaGlassDisabledText");
    private Color iconEnabledSelected = this.decodeColor("seaGlassMenuIcon");
    private Color iconSelectedMouseOver = this.decodeColor("seaGlassSelectedText");

    public MenuPainter(Which state) {
        super(MenuItemPainter.Which.BACKGROUND_ENABLED);
        this.state = state;
        this.ctx = new AbstractRegionPainter.PaintContext(AbstractRegionPainter.PaintContext.CacheMode.NO_CACHING);
    }

    @Override
    protected void doPaint(Graphics2D g, JComponent c, int width, int height, Object[] extendedCacheKeys) {
        switch (this.state) {
            case BACKGROUND_ENABLED_SELECTED: {
                this.paintBackgroundMouseOver(g, c, width, height);
                break;
            }
            case ARROWICON_DISABLED: {
                this.paintArrowIconDisabled(g, c, width, height);
                break;
            }
            case ARROWICON_ENABLED: {
                this.paintArrowIconEnabled(g, c, width, height);
                break;
            }
            case ARROWICON_ENABLED_SELECTED: {
                this.paintArrowIconEnabledAndSelected(g, c, width, height);
            }
        }
    }

    @Override
    protected final AbstractRegionPainter.PaintContext getPaintContext() {
        return this.ctx;
    }

    private void paintArrowIconDisabled(Graphics2D g, JComponent c, int width, int height) {
        Shape s = this.decodeArrowPath(c, width, height);
        g.setPaint(this.iconDisabledSelected);
        g.fill(s);
    }

    private void paintArrowIconEnabled(Graphics2D g, JComponent c, int width, int height) {
        Shape s = this.decodeArrowPath(c, width, height);
        g.setPaint(this.iconEnabledSelected);
        g.fill(s);
    }

    private void paintArrowIconEnabledAndSelected(Graphics2D g, JComponent c, int width, int height) {
        Shape s = this.decodeArrowPath(c, width, height);
        g.setPaint(this.iconSelectedMouseOver);
        g.fill(s);
    }

    private Shape decodeArrowPath(JComponent c, int width, int height) {
        if (c.getComponentOrientation().isLeftToRight()) {
            return this.shapeGenerator.createArrowRight(1.0, 1.0, width - 2, height - 2);
        }
        return this.shapeGenerator.createArrowLeft(1.0, 1.0, width - 2, height - 2);
    }

    public static enum Which {
        BACKGROUND_DISABLED,
        BACKGROUND_ENABLED,
        BACKGROUND_ENABLED_SELECTED,
        ARROWICON_DISABLED,
        ARROWICON_ENABLED,
        ARROWICON_ENABLED_SELECTED;

    }
}

