/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.painter;

import com.seaglasslookandfeel.painter.AbstractRegionPainter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import javax.swing.JComponent;

public class MenuItemPainter
extends AbstractRegionPainter {
    private Color menuItemBackgroundBase = this.decodeColor("menuItemBackgroundBase");
    private Color menuItemBackgroundTop = this.deriveColor(this.menuItemBackgroundBase, -0.003425f, -0.02754f, 0.070588f, 0);
    private Color menuItemBackgroundBottom = this.deriveColor(this.menuItemBackgroundBase, 0.001337f, 0.040989f, -0.078431f, 0);
    private AbstractRegionPainter.TwoColors menuItemBackground = new AbstractRegionPainter.TwoColors(this.menuItemBackgroundTop, this.menuItemBackgroundBottom);
    private Color menuItemBottomLine = this.deriveColor(this.menuItemBackgroundBase, 0.006069f, 0.13152f, -0.105882f, 0);
    private Which state;
    private AbstractRegionPainter.PaintContext ctx;

    public MenuItemPainter(Which state) {
        this.state = state;
        this.ctx = new AbstractRegionPainter.PaintContext(AbstractRegionPainter.PaintContext.CacheMode.NO_CACHING);
    }

    @Override
    protected void doPaint(Graphics2D g, JComponent c, int width, int height, Object[] extendedCacheKeys) {
        switch (this.state) {
            case BACKGROUND_MOUSEOVER: {
                this.paintBackgroundMouseOver(g, c, width, height);
                break;
            }
            case BACKGROUND_MOUSEOVER_UNIFIED: {
                this.paintBackgroundMouseOverUnified(g, c, width, height);
            }
        }
    }

    @Override
    protected AbstractRegionPainter.PaintContext getPaintContext() {
        return this.ctx;
    }

    protected void paintBackgroundMouseOver(Graphics2D g, JComponent c, int width, int height) {
        Shape s = this.shapeGenerator.createRectangle(0, 0, width, height);
        g.setPaint(this.getMenuItemBackgroundPaint(s));
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.fill(s);
        Rectangle b = s.getBounds();
        int width1 = b.width;
        int height1 = b.height;
        g.setColor(this.getMenuItemBottomLinePaint(c));
        g.drawLine(0, height1 - 1, width1 - 1, height1 - 1);
    }

    protected void paintBackgroundMouseOverUnified(Graphics2D g, JComponent c, int width, int height) {
        Shape s = this.shapeGenerator.createRectangle(0, 0, width, height);
        g.setPaint(this.getMenuItemBackgroundPaintUnified(s));
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.fill(s);
    }

    public Paint getMenuItemBackgroundPaint(Shape s) {
        return this.createVerticalGradient(s, this.menuItemBackground);
    }

    public Paint getMenuItemBackgroundPaintUnified(Shape s) {
        return this.createVerticalGradient(s, new AbstractRegionPainter.TwoColors(Color.WHITE, Color.WHITE));
    }

    public Color getMenuItemBottomLinePaint(JComponent c) {
        return this.menuItemBottomLine;
    }

    public static enum Which {
        BACKGROUND_DISABLED,
        BACKGROUND_ENABLED,
        BACKGROUND_MOUSEOVER,
        BACKGROUND_MOUSEOVER_UNIFIED;

    }
}

