/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.painter;

import com.seaglasslookandfeel.painter.AbstractRegionPainter;
import com.seaglasslookandfeel.painter.util.ShapeGenerator;
import com.seaglasslookandfeel.state.State;
import com.seaglasslookandfeel.state.ToolBarNorthState;
import com.seaglasslookandfeel.state.ToolBarSouthState;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.JToolBar;

public final class FrameAndRootPainter
extends AbstractRegionPainter {
    public static final int TITLE_BAR_HEIGHT = 25;
    private static final State toolBarNorthState = new ToolBarNorthState();
    private static final State toolBarSouthState = new ToolBarSouthState();
    private Color frameBorderBase = this.decodeColor("frameBorderBase");
    private Color frameInnerHighlightInactive = this.decodeColor("frameInnerHighlightInactive");
    private Color frameInnerHighlightActive = this.decodeColor("frameInnerHighlightActive");
    private Color frameBaseActive = this.decodeColor("frameBaseActive");
    private Color frameBaseInactive = this.decodeColor("frameBaseInactive");
    private Color frameBorderActive = this.frameBorderBase;
    private Color frameBorderInactive = this.frameBorderBase;
    private Color frameTopActive = this.deriveColor(this.frameBaseActive, 0.005208f, -0.080105f, 0.043137f, 0);
    private Color frameUpperMidActive = this.frameBaseActive;
    private Color frameLowerMidActive = this.frameBaseActive;
    private Color frameBottomActive = this.deriveColor(this.frameBaseActive, 0.0f, 0.025723f, -0.015686f, 0);
    private Color frameTopInactive = this.deriveColor(this.frameBaseInactive, 0.0f, 0.0f, 0.05098f, 0);
    private Color frameUpperMidInactive = this.frameBaseInactive;
    private Color frameLowerMidInactive = this.frameBaseInactive;
    private Color frameBottomInactive = this.deriveColor(this.frameBaseInactive, 0.0f, 0.0f, -0.05098f, 0);
    private AbstractRegionPainter.FourColors frameActive = new AbstractRegionPainter.FourColors(this.frameTopActive, this.frameUpperMidActive, this.frameLowerMidActive, this.frameBottomActive);
    private AbstractRegionPainter.FourColors frameInactive = new AbstractRegionPainter.FourColors(this.frameTopInactive, this.frameUpperMidInactive, this.frameLowerMidInactive, this.frameBottomInactive);
    private Which state;
    private AbstractRegionPainter.PaintContext ctx;

    public FrameAndRootPainter(Which state) {
        this.state = state;
        this.ctx = new AbstractRegionPainter.PaintContext(AbstractRegionPainter.PaintContext.CacheMode.FIXED_SIZES);
    }

    @Override
    protected void doPaint(Graphics2D g, JComponent c, int width, int height, Object[] extendedCacheKeys) {
        if (this.state == Which.BACKGROUND_ENABLED_NOFRAME) {
            return;
        }
        Shape s = this.shapeGenerator.createRoundRectangle(0, 0, width - 1, height - 1, ShapeGenerator.CornerSize.FRAME_BORDER, ShapeGenerator.CornerStyle.ROUNDED, ShapeGenerator.CornerStyle.SQUARE, ShapeGenerator.CornerStyle.SQUARE, ShapeGenerator.CornerStyle.ROUNDED);
        g.setPaint(this.getFrameBorderPaint(s));
        g.draw(s);
        JMenuBar mb = null;
        Component[] cArray = null;
        if (c instanceof JInternalFrame) {
            JInternalFrame iframe = (JInternalFrame)c;
            mb = iframe.getJMenuBar();
            cArray = iframe.getContentPane().getComponents();
        } else if (c instanceof JRootPane) {
            JRootPane root = (JRootPane)c;
            mb = root.getJMenuBar();
            cArray = root.getContentPane().getComponents();
        }
        int topToolBarHeight = 0;
        int bottomToolBarHeight = 0;
        if (cArray != null) {
            for (Component comp : cArray) {
                if (!(comp instanceof JToolBar)) continue;
                if (toolBarNorthState.isInState((JComponent)comp)) {
                    topToolBarHeight = comp.getHeight();
                    continue;
                }
                if (!toolBarSouthState.isInState((JComponent)comp)) continue;
                bottomToolBarHeight = comp.getHeight();
            }
        }
        int titleHeight = 25;
        if (mb != null && c.getClientProperty("SeaGlass.JRootPane.MenuInTitle") == Boolean.TRUE) {
            titleHeight += mb.getHeight();
        }
        if (c.getClientProperty("SeaGlass.UnifiedToolbarLook") == Boolean.TRUE) {
            s = this.shapeGenerator.createRoundRectangle(1, 1, width - 2, height - 2, ShapeGenerator.CornerSize.FRAME_INNER_HIGHLIGHT, ShapeGenerator.CornerStyle.ROUNDED, ShapeGenerator.CornerStyle.SQUARE, ShapeGenerator.CornerStyle.SQUARE, ShapeGenerator.CornerStyle.ROUNDED);
            g.setPaint(this.getFrameInteriorPaint(s, titleHeight, topToolBarHeight, bottomToolBarHeight));
            g.fill(s);
        } else {
            s = this.shapeGenerator.createRoundRectangle(1, 1, width - 2, titleHeight, ShapeGenerator.CornerSize.FRAME_INNER_HIGHLIGHT, ShapeGenerator.CornerStyle.ROUNDED, ShapeGenerator.CornerStyle.SQUARE, ShapeGenerator.CornerStyle.SQUARE, ShapeGenerator.CornerStyle.ROUNDED);
            g.setPaint(this.getTitleBarInteriorPaint(s, titleHeight));
            g.fill(s);
            s = this.shapeGenerator.createRoundRectangle(1, titleHeight, width - 2, height - titleHeight - 1, ShapeGenerator.CornerSize.FRAME_INNER_HIGHLIGHT, ShapeGenerator.CornerStyle.SQUARE, ShapeGenerator.CornerStyle.SQUARE, ShapeGenerator.CornerStyle.SQUARE, ShapeGenerator.CornerStyle.SQUARE);
            g.setPaint(c.getBackground());
            g.fill(s);
            g.setPaint(this.decodeColor("seaGlassMenuIcon"));
            g.drawLine(1, titleHeight, width - 2, titleHeight);
        }
        s = this.shapeGenerator.createRoundRectangle(1, 1, width - 3, height - 3, ShapeGenerator.CornerSize.FRAME_INTERIOR);
        g.setPaint(this.getFrameInnerHighlightPaint(s));
        g.draw(s);
    }

    @Override
    protected AbstractRegionPainter.PaintContext getPaintContext() {
        return this.ctx;
    }

    public Paint getFrameBorderPaint(Shape s) {
        switch (this.state) {
            case BACKGROUND_ENABLED: {
                return this.frameBorderInactive;
            }
            case BACKGROUND_ENABLED_WINDOWFOCUSED: {
                return this.frameBorderActive;
            }
        }
        return null;
    }

    private AbstractRegionPainter.FourColors getFrameInteriorColors() {
        switch (this.state) {
            case BACKGROUND_ENABLED: {
                return this.frameInactive;
            }
            case BACKGROUND_ENABLED_WINDOWFOCUSED: {
                return this.frameActive;
            }
        }
        return null;
    }

    public Paint getFrameInteriorPaint(Shape s, int titleHeight, int topToolBarHeight, int bottomToolBarHeight) {
        return this.createFrameGradient(s, titleHeight, topToolBarHeight, bottomToolBarHeight, this.getFrameInteriorColors());
    }

    public Paint getTitleBarInteriorPaint(Shape s, int titleHeight) {
        return this.createTitleBarGradient(s, titleHeight, this.getFrameInteriorColors());
    }

    public Paint getFrameInnerHighlightPaint(Shape s) {
        switch (this.state) {
            case BACKGROUND_ENABLED: {
                return this.frameInnerHighlightInactive;
            }
            case BACKGROUND_ENABLED_WINDOWFOCUSED: {
                return this.frameInnerHighlightActive;
            }
        }
        return null;
    }

    private Paint createFrameGradient(Shape s, int titleHeight, int topToolBarHeight, int bottomToolBarHeight, AbstractRegionPainter.FourColors defColors) {
        Rectangle2D bounds = s.getBounds2D();
        float x = (float)bounds.getX();
        float y = (float)bounds.getY();
        float w = (float)bounds.getWidth();
        float h = (float)bounds.getHeight();
        float midX = x + w / 2.0f;
        float titleBottom = (float)titleHeight / h;
        if (titleBottom >= 1.0f) {
            titleBottom = 0.99996f;
        }
        float[] midPoints = null;
        Color[] colors = null;
        if (topToolBarHeight > 0 && bottomToolBarHeight > 0) {
            float bottomToolBarTop;
            float topToolBarBottom = (float)(titleHeight + topToolBarHeight) / h;
            if (topToolBarBottom >= 1.0f) {
                topToolBarBottom = 0.99998f;
            }
            if ((bottomToolBarTop = (h - 2.0f - (float)bottomToolBarHeight) / h) >= 1.0f) {
                bottomToolBarTop = 0.99998f;
            }
            midPoints = new float[]{0.0f, topToolBarBottom, bottomToolBarTop, 1.0f};
            colors = new Color[]{defColors.top, defColors.upperMid, defColors.lowerMid, defColors.bottom};
        } else if (topToolBarHeight > 0) {
            float toolBarBottom = (float)(titleHeight + topToolBarHeight) / h;
            if (toolBarBottom >= 1.0f) {
                toolBarBottom = 0.99998f;
            }
            midPoints = new float[]{0.0f, toolBarBottom, 1.0f};
            colors = new Color[]{defColors.top, defColors.upperMid, defColors.lowerMid};
        } else if (bottomToolBarHeight > 0) {
            float bottomToolBarTop = (h - 2.0f - (float)bottomToolBarHeight) / h;
            if (bottomToolBarTop >= 1.0f) {
                bottomToolBarTop = 0.99998f;
            }
            midPoints = new float[]{0.0f, titleBottom, bottomToolBarTop, 1.0f};
            colors = new Color[]{defColors.top, defColors.upperMid, defColors.lowerMid, defColors.bottom};
        } else {
            midPoints = new float[]{0.0f, titleBottom, 1.0f};
            colors = new Color[]{defColors.top, defColors.upperMid, defColors.bottom};
        }
        return this.createGradient(midX, y, midX, y + h, midPoints, colors);
    }

    private Paint createTitleBarGradient(Shape s, int titleHeight, AbstractRegionPainter.FourColors defColors) {
        Rectangle2D bounds = s.getBounds2D();
        float midX = (float)bounds.getCenterX();
        float y = (float)bounds.getY();
        float h = (float)bounds.getHeight();
        return this.createGradient(midX, y, midX, y + h, new float[]{0.0f, 1.0f}, new Color[]{defColors.top, defColors.upperMid});
    }

    public static enum Which {
        BACKGROUND_ENABLED,
        BACKGROUND_ENABLED_WINDOWFOCUSED,
        BACKGROUND_ENABLED_NOFRAME;

    }
}

