/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.painter;

import com.seaglasslookandfeel.icons.FileIcon;
import com.seaglasslookandfeel.icons.FloppyDiskIcon;
import com.seaglasslookandfeel.icons.FolderHomeIcon;
import com.seaglasslookandfeel.icons.FolderIcon;
import com.seaglasslookandfeel.icons.FolderNewIcon;
import com.seaglasslookandfeel.icons.FolderUpIcon;
import com.seaglasslookandfeel.icons.HardDiskIcon;
import com.seaglasslookandfeel.icons.ViewDetailsIcon;
import com.seaglasslookandfeel.icons.ViewListIcon;
import com.seaglasslookandfeel.painter.AbstractRegionPainter;
import java.awt.Dimension;
import java.awt.Graphics2D;
import javax.swing.JComponent;

public final class FileChooserPainter
extends AbstractRegionPainter {
    private Which state;
    private AbstractRegionPainter.PaintContext ctx;

    public FileChooserPainter(Which state) {
        this.state = state;
        this.ctx = new AbstractRegionPainter.PaintContext(AbstractRegionPainter.PaintContext.CacheMode.NO_CACHING);
    }

    @Override
    protected void doPaint(Graphics2D g, JComponent c, int width, int height, Object[] extendedCacheKeys) {
        switch (this.state) {
            case FILEICON_ENABLED: {
                this.paintFileIcon(g, c, width, height);
                break;
            }
            case DIRECTORYICON_ENABLED: {
                this.paintDirectoryIcon(g, c, width, height);
                break;
            }
            case UPFOLDERICON_ENABLED: {
                this.paintUpFolderIcon(g, c, width, height);
                break;
            }
            case NEWFOLDERICON_ENABLED: {
                this.paintNewFolderIcon(g, c, width, height);
                break;
            }
            case HOMEFOLDERICON_ENABLED: {
                this.paintHomeFolderIcon(g, c, width, height);
                break;
            }
            case DETAILSVIEWICON_ENABLED: {
                this.paintViewDetailsIcon(g, c, width, height);
                break;
            }
            case LISTVIEWICON_ENABLED: {
                this.paintViewListIcon(g, c, width, height);
                break;
            }
            case HARDDRIVEICON_ENABLED: {
                this.paintHardDriveIcon(g, c, width, height);
                break;
            }
            case FLOPPYDRIVEICON_ENABLED: {
                this.paintFloppyDiskIcon(g, c, width, height);
            }
        }
    }

    private void paintFloppyDiskIcon(Graphics2D g, JComponent c, int width, int height) {
        FloppyDiskIcon icon = new FloppyDiskIcon();
        icon.setDimension(new Dimension(width, height));
        icon.paintIcon(c, g, 0, 0);
    }

    private void paintHardDriveIcon(Graphics2D g, JComponent c, int width, int height) {
        HardDiskIcon icon = new HardDiskIcon();
        icon.setDimension(new Dimension(width, height));
        icon.paintIcon(c, g, 0, 0);
    }

    private void paintViewListIcon(Graphics2D g, JComponent c, int width, int height) {
        ViewListIcon icon = new ViewListIcon();
        icon.setDimension(new Dimension(width, height));
        icon.paintIcon(c, g, 0, 0);
    }

    private void paintViewDetailsIcon(Graphics2D g, JComponent c, int width, int height) {
        ViewDetailsIcon icon = new ViewDetailsIcon();
        icon.setDimension(new Dimension(width, height));
        icon.paintIcon(c, g, 0, 0);
    }

    private void paintHomeFolderIcon(Graphics2D g, JComponent c, int width, int height) {
        FolderHomeIcon icon = new FolderHomeIcon();
        icon.setDimension(new Dimension(width, height));
        icon.paintIcon(c, g, 0, 0);
    }

    private void paintNewFolderIcon(Graphics2D g, JComponent c, int width, int height) {
        FolderNewIcon icon = new FolderNewIcon();
        icon.setDimension(new Dimension(width, height));
        icon.paintIcon(c, g, 0, 0);
    }

    private void paintUpFolderIcon(Graphics2D g, JComponent c, int width, int height) {
        FolderUpIcon icon = new FolderUpIcon();
        icon.setDimension(new Dimension(width, height));
        icon.paintIcon(c, g, 0, 0);
    }

    private void paintDirectoryIcon(Graphics2D g, JComponent c, int width, int height) {
        FolderIcon icon = new FolderIcon();
        icon.setDimension(new Dimension(width, height));
        icon.paintIcon(c, g, 0, 0);
    }

    private void paintFileIcon(Graphics2D g, JComponent c, int width, int height) {
        FileIcon icon = new FileIcon();
        icon.setDimension(new Dimension(width, height));
        icon.paintIcon(c, g, 0, 0);
    }

    @Override
    protected AbstractRegionPainter.PaintContext getPaintContext() {
        return this.ctx;
    }

    public static enum Which {
        FILEICON_ENABLED,
        DIRECTORYICON_ENABLED,
        UPFOLDERICON_ENABLED,
        NEWFOLDERICON_ENABLED,
        HOMEFOLDERICON_ENABLED,
        DETAILSVIEWICON_ENABLED,
        LISTVIEWICON_ENABLED,
        HARDDRIVEICON_ENABLED,
        FLOPPYDRIVEICON_ENABLED;

    }
}

