/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.painter;

import com.seaglasslookandfeel.painter.AbstractRegionPainter;
import com.seaglasslookandfeel.painter.util.ShapeGenerator;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import javax.swing.JComponent;

public final class DesktopIconPainter
extends AbstractRegionPainter {
    private AbstractRegionPainter.TwoColors rootPaneActive = new AbstractRegionPainter.TwoColors(this.decodeColor("seaGlassToolBarActiveTopT"), this.decodeColor("seaGlassToolBarActiveBottomB"));
    private AbstractRegionPainter.TwoColors rootPaneInactive = new AbstractRegionPainter.TwoColors(this.decodeColor("seaGlassToolBarInactiveTopT"), this.decodeColor("seaGlassToolBarInactiveBottomB"));
    private Color frameBorderBase = this.decodeColor("frameBorderBase");
    private Color frameInnerHighlightInactive = this.decodeColor("frameInnerHighlightInactive");
    private Color frameInnerHighlightActive = this.decodeColor("frameInnerHighlightActive");
    private Color frameBorderActive = this.frameBorderBase;
    private Color frameBorderInactive = this.frameBorderBase;
    private Which state;
    private AbstractRegionPainter.PaintContext ctx;

    public DesktopIconPainter(Which state) {
        this.state = state;
        this.ctx = new AbstractRegionPainter.PaintContext(AbstractRegionPainter.PaintContext.CacheMode.FIXED_SIZES);
    }

    @Override
    protected void doPaint(Graphics2D g, JComponent c, int width, int height, Object[] extendedCacheKeys) {
        Shape s = this.shapeGenerator.createRoundRectangle(2, 0, width - 3, height - 2, ShapeGenerator.CornerSize.FRAME_BORDER);
        this.getFrameBorderPaint(s);
        s = this.shapeGenerator.createRoundRectangle(3, 1, width - 5, height - 4, ShapeGenerator.CornerSize.FRAME_INNER_HIGHLIGHT);
        g.setPaint(this.getFrameInnerHighlightPaint(s));
        g.fill(s);
        s = this.shapeGenerator.createRoundRectangle(4, 2, width - 7, height - 6, ShapeGenerator.CornerSize.FRAME_INTERIOR);
        g.setPaint(this.getRootPaneInteriorPaint(s));
        g.fill(s);
    }

    @Override
    protected AbstractRegionPainter.PaintContext getPaintContext() {
        return this.ctx;
    }

    public Paint getFrameBorderPaint(Shape s) {
        switch (this.state) {
            case BACKGROUND_ENABLED_WINDOWFOCUSED: {
                return this.frameBorderActive;
            }
        }
        return this.frameBorderInactive;
    }

    public Paint getFrameInnerHighlightPaint(Shape s) {
        switch (this.state) {
            case BACKGROUND_ENABLED_WINDOWFOCUSED: {
                return this.frameInnerHighlightActive;
            }
        }
        return this.frameInnerHighlightInactive;
    }

    public Paint getRootPaneInteriorPaint(Shape s) {
        return this.createVerticalGradient(s, this.getRootPaneInteriorColors());
    }

    private AbstractRegionPainter.TwoColors getRootPaneInteriorColors() {
        switch (this.state) {
            case BACKGROUND_ENABLED_WINDOWFOCUSED: {
                return this.rootPaneActive;
            }
        }
        return this.rootPaneInactive;
    }

    public static enum Which {
        BACKGROUND_ENABLED,
        BACKGROUND_ENABLED_WINDOWFOCUSED;

    }
}

