/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.painter;

import com.seaglasslookandfeel.effect.SeaGlassInternalShadowEffect;
import com.seaglasslookandfeel.painter.AbstractCommonColorsPainter;
import com.seaglasslookandfeel.painter.AbstractRegionPainter;
import com.seaglasslookandfeel.painter.util.ShapeGenerator;
import java.awt.Graphics2D;
import java.awt.Shape;
import javax.swing.JComponent;

public final class ComboBoxTextFieldPainter
extends AbstractCommonColorsPainter {
    private SeaGlassInternalShadowEffect internalShadow = new SeaGlassInternalShadowEffect();
    private AbstractRegionPainter.PaintContext ctx = new AbstractRegionPainter.PaintContext(AbstractRegionPainter.PaintContext.CacheMode.FIXED_SIZES);
    private AbstractCommonColorsPainter.CommonControlState type;

    public ComboBoxTextFieldPainter(Which state) {
        this.type = state == Which.BACKGROUND_DISABLED ? AbstractCommonColorsPainter.CommonControlState.DISABLED : AbstractCommonColorsPainter.CommonControlState.ENABLED;
    }

    @Override
    protected void doPaint(Graphics2D g, JComponent c, int width, int height, Object[] extendedCacheKeys) {
        Shape s = this.shapeGenerator.createRoundRectangle(3, 3, width - 2, height - 6, ShapeGenerator.CornerSize.BORDER, ShapeGenerator.CornerStyle.ROUNDED, ShapeGenerator.CornerStyle.ROUNDED, ShapeGenerator.CornerStyle.SQUARE, ShapeGenerator.CornerStyle.SQUARE);
        g.setColor(c.getBackground());
        g.fill(s);
        if (this.type != AbstractCommonColorsPainter.CommonControlState.DISABLED) {
            s = this.shapeGenerator.createRoundRectangle(3, 3, width - 2, height - 6, ShapeGenerator.CornerSize.BORDER, ShapeGenerator.CornerStyle.ROUNDED, ShapeGenerator.CornerStyle.ROUNDED, ShapeGenerator.CornerStyle.SQUARE, ShapeGenerator.CornerStyle.SQUARE);
            this.internalShadow.fill(g, s, false, false);
        }
        s = this.shapeGenerator.createRoundRectangle(2, 2, width - 2, height - 5, ShapeGenerator.CornerSize.BORDER, ShapeGenerator.CornerStyle.ROUNDED, ShapeGenerator.CornerStyle.ROUNDED, ShapeGenerator.CornerStyle.SQUARE, ShapeGenerator.CornerStyle.SQUARE);
        g.setPaint(this.getTextBorderPaint(this.type, false));
        g.draw(s);
    }

    @Override
    protected AbstractRegionPainter.PaintContext getPaintContext() {
        return this.ctx;
    }

    public static enum Which {
        BACKGROUND_DISABLED,
        BACKGROUND_ENABLED,
        BACKGROUND_SELECTED;

    }
}

