/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.painter;

import com.seaglasslookandfeel.painter.AbstractCommonColorsPainter;
import com.seaglasslookandfeel.painter.AbstractRegionPainter;
import com.seaglasslookandfeel.painter.ComboBoxArrowButtonPainter;
import com.seaglasslookandfeel.painter.util.ShapeGenerator;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import javax.swing.JComponent;

public final class ComboBoxPainter
extends AbstractCommonColorsPainter {
    public AbstractCommonColorsPainter.CommonControlState type;
    private ComboBoxArrowButtonPainter buttonPainter;
    private static final int buttonWidth = 21;
    private Which state;
    private AbstractRegionPainter.PaintContext ctx;
    private boolean editable;

    public ComboBoxPainter(Which state) {
        this.state = state;
        this.ctx = new AbstractRegionPainter.PaintContext(AbstractRegionPainter.PaintContext.CacheMode.FIXED_SIZES);
        this.editable = false;
        if (state == Which.BACKGROUND_DISABLED_EDITABLE || state == Which.BACKGROUND_ENABLED_EDITABLE || state == Which.BACKGROUND_PRESSED_EDITABLE || state == Which.BACKGROUND_FOCUSED_EDITABLE) {
            this.editable = true;
        } else {
            ComboBoxArrowButtonPainter.Which arrowState = state == Which.BACKGROUND_DISABLED || state == Which.BACKGROUND_DISABLED_PRESSED ? ComboBoxArrowButtonPainter.Which.BACKGROUND_DISABLED : (state == Which.BACKGROUND_PRESSED || state == Which.BACKGROUND_PRESSED_FOCUSED ? ComboBoxArrowButtonPainter.Which.BACKGROUND_PRESSED : ComboBoxArrowButtonPainter.Which.BACKGROUND_ENABLED);
            this.buttonPainter = new ComboBoxArrowButtonPainter(arrowState);
        }
        this.type = this.getButtonType(state);
    }

    @Override
    protected void doPaint(Graphics2D g, JComponent c, int width, int height, Object[] extendedCacheKeys) {
        switch (this.state) {
            case BACKGROUND_DISABLED: 
            case BACKGROUND_DISABLED_PRESSED: {
                this.paintDropShadow(g, width, height, true);
                this.paintButton(g, c, width, height);
                break;
            }
            case BACKGROUND_ENABLED: {
                this.paintDropShadow(g, width, height, true);
                this.paintButton(g, c, width, height);
                break;
            }
            case BACKGROUND_FOCUSED: {
                this.paintFocus(g, c, width, height);
                this.paintButton(g, c, width, height);
                break;
            }
            case BACKGROUND_PRESSED_FOCUSED: {
                this.paintFocus(g, c, width, height);
                this.paintButton(g, c, width, height);
                break;
            }
            case BACKGROUND_PRESSED: 
            case BACKGROUND_ENABLED_SELECTED: {
                this.paintDropShadow(g, width, height, true);
                this.paintButton(g, c, width, height);
                break;
            }
            case BACKGROUND_FOCUSED_EDITABLE: {
                this.paintFocus(g, c, width, height);
                break;
            }
            case BACKGROUND_DISABLED_EDITABLE: 
            case BACKGROUND_ENABLED_EDITABLE: 
            case BACKGROUND_PRESSED_EDITABLE: {
                this.paintDropShadow(g, width, height, false);
            }
        }
    }

    @Override
    protected AbstractRegionPainter.PaintContext getPaintContext() {
        return this.ctx;
    }

    private AbstractCommonColorsPainter.CommonControlState getButtonType(Which state) {
        switch (state) {
            case BACKGROUND_DISABLED: 
            case BACKGROUND_DISABLED_PRESSED: 
            case BACKGROUND_DISABLED_EDITABLE: {
                return AbstractCommonColorsPainter.CommonControlState.DISABLED;
            }
            case BACKGROUND_ENABLED: 
            case BACKGROUND_FOCUSED: 
            case BACKGROUND_FOCUSED_EDITABLE: 
            case BACKGROUND_ENABLED_EDITABLE: {
                return AbstractCommonColorsPainter.CommonControlState.ENABLED;
            }
            case BACKGROUND_PRESSED_FOCUSED: 
            case BACKGROUND_PRESSED: 
            case BACKGROUND_ENABLED_SELECTED: 
            case BACKGROUND_PRESSED_EDITABLE: {
                return AbstractCommonColorsPainter.CommonControlState.PRESSED;
            }
        }
        return null;
    }

    private void paintButton(Graphics2D g, JComponent c, int width, int height) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int leftWidth = width - 21;
        Shape s = this.createButtonPath(ShapeGenerator.CornerSize.BORDER, 2, 2, leftWidth - 2, height - 4);
        g.setPaint(this.getComboBoxBackgroundBorderPaint(s, this.type));
        g.fill(s);
        s = this.createButtonPath(ShapeGenerator.CornerSize.INTERIOR, 3, 3, leftWidth - 3, height - 6);
        g.setPaint(this.getComboBoxBackgroundInteriorPaint(s, this.type));
        g.fill(s);
        Graphics2D g2 = (Graphics2D)g.create();
        g2.translate(leftWidth, 0);
        this.buttonPainter.doPaint(g2, c, 21, height, null);
    }

    private void paintFocus(Graphics2D g, JComponent c, int width, int height) {
        boolean useToolBarFocus = this.isInToolBar(c);
        Shape s = this.createFocusPath(ShapeGenerator.CornerSize.OUTER_FOCUS, 0, 0, width, height);
        g.setPaint(this.getFocusPaint(s, AbstractRegionPainter.FocusType.OUTER_FOCUS, useToolBarFocus));
        g.fill(s);
        s = this.createFocusPath(ShapeGenerator.CornerSize.INNER_FOCUS, 1, 1, width - 2, height - 2);
        g.setPaint(this.getFocusPaint(s, AbstractRegionPainter.FocusType.INNER_FOCUS, useToolBarFocus));
        g.fill(s);
    }

    private void paintDropShadow(Graphics2D g, int width, int height, boolean full) {
    }

    private Shape createButtonPath(ShapeGenerator.CornerSize size, int left, int top, int width, int height) {
        return this.shapeGenerator.createRoundRectangle(left, top, width, height, size, ShapeGenerator.CornerStyle.ROUNDED, ShapeGenerator.CornerStyle.ROUNDED, ShapeGenerator.CornerStyle.SQUARE, ShapeGenerator.CornerStyle.SQUARE);
    }

    private Shape createFocusPath(ShapeGenerator.CornerSize size, int x, int y, int width, int height) {
        ShapeGenerator.CornerStyle leftStyle = ShapeGenerator.CornerStyle.ROUNDED;
        return this.shapeGenerator.createRoundRectangle(x, y, width, height, size, leftStyle, leftStyle, ShapeGenerator.CornerStyle.ROUNDED, ShapeGenerator.CornerStyle.ROUNDED);
    }

    public Paint getComboBoxBackgroundBorderPaint(Shape s, AbstractCommonColorsPainter.CommonControlState type) {
        AbstractRegionPainter.TwoColors colors = this.getCommonBorderColors(type);
        return this.createVerticalGradient(s, colors);
    }

    public Paint getComboBoxBackgroundInteriorPaint(Shape s, AbstractCommonColorsPainter.CommonControlState type) {
        AbstractRegionPainter.FourColors colors = this.getCommonInteriorColors(type);
        return this.createVerticalGradient(s, colors);
    }

    @Override
    public AbstractRegionPainter.TwoColors getCommonBorderColors(AbstractCommonColorsPainter.CommonControlState type) {
        switch (type) {
            case DISABLED: {
                return super.getCommonBorderColors(AbstractCommonColorsPainter.CommonControlState.DISABLED);
            }
            case ENABLED: 
            case PRESSED: {
                return super.getCommonBorderColors(AbstractCommonColorsPainter.CommonControlState.ENABLED);
            }
        }
        return null;
    }

    @Override
    public AbstractRegionPainter.FourColors getCommonInteriorColors(AbstractCommonColorsPainter.CommonControlState type) {
        switch (type) {
            case DISABLED: {
                return super.getCommonInteriorColors(AbstractCommonColorsPainter.CommonControlState.DISABLED);
            }
            case ENABLED: 
            case PRESSED: {
                return super.getCommonInteriorColors(AbstractCommonColorsPainter.CommonControlState.ENABLED);
            }
        }
        return null;
    }

    public static enum Which {
        BACKGROUND_DISABLED,
        BACKGROUND_DISABLED_PRESSED,
        BACKGROUND_ENABLED,
        BACKGROUND_FOCUSED,
        BACKGROUND_PRESSED_FOCUSED,
        BACKGROUND_PRESSED,
        BACKGROUND_ENABLED_SELECTED,
        BACKGROUND_DISABLED_EDITABLE,
        BACKGROUND_ENABLED_EDITABLE,
        BACKGROUND_FOCUSED_EDITABLE,
        BACKGROUND_PRESSED_EDITABLE;

    }
}

