/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.painter;

import com.seaglasslookandfeel.painter.AbstractCommonColorsPainter;
import com.seaglasslookandfeel.painter.AbstractRegionPainter;
import com.seaglasslookandfeel.painter.util.ShapeGenerator;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import javax.swing.JComponent;

public final class ComboBoxArrowButtonPainter
extends AbstractCommonColorsPainter {
    private Which state;
    private AbstractRegionPainter.PaintContext ctx;
    private AbstractCommonColorsPainter.CommonControlState type;

    public ComboBoxArrowButtonPainter(Which state) {
        this.state = state;
        this.ctx = new AbstractRegionPainter.PaintContext(AbstractRegionPainter.PaintContext.CacheMode.FIXED_SIZES);
        this.type = this.getButtonType(state);
    }

    @Override
    protected void doPaint(Graphics2D g, JComponent c, int width, int height, Object[] extendedCacheKeys) {
        switch (this.state) {
            case BACKGROUND_DISABLED: 
            case BACKGROUND_ENABLED: 
            case BACKGROUND_PRESSED: 
            case BACKGROUND_SELECTED: {
                this.paintButton(g, c, width, height);
                break;
            }
            case FOREGROUND_ENABLED: 
            case FOREGROUND_DISABLED: 
            case FOREGROUND_PRESSED: 
            case FOREGROUND_SELECTED: {
                this.paintArrows(g, c, width, height);
                break;
            }
            case FOREGROUND_ENABLED_EDITABLE: 
            case FOREGROUND_DISABLED_EDITABLE: {
                this.paintArrowDown(g, c, width, height);
            }
        }
    }

    @Override
    protected AbstractRegionPainter.PaintContext getPaintContext() {
        return this.ctx;
    }

    private AbstractCommonColorsPainter.CommonControlState getButtonType(Which state) {
        switch (state) {
            case BACKGROUND_DISABLED: {
                return AbstractCommonColorsPainter.CommonControlState.DISABLED;
            }
            case BACKGROUND_ENABLED: {
                return AbstractCommonColorsPainter.CommonControlState.ENABLED;
            }
            case BACKGROUND_PRESSED: 
            case BACKGROUND_SELECTED: {
                return AbstractCommonColorsPainter.CommonControlState.PRESSED;
            }
            case FOREGROUND_ENABLED: 
            case FOREGROUND_PRESSED: 
            case FOREGROUND_SELECTED: 
            case FOREGROUND_ENABLED_EDITABLE: {
                return AbstractCommonColorsPainter.CommonControlState.ENABLED;
            }
            case FOREGROUND_DISABLED: 
            case FOREGROUND_DISABLED_EDITABLE: {
                return AbstractCommonColorsPainter.CommonControlState.DISABLED;
            }
        }
        return null;
    }

    private void paintButton(Graphics2D g, JComponent c, int width, int height) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Shape s = this.createButtonPath(ShapeGenerator.CornerSize.BORDER, 0, 2, width - 2, height - 4);
        g.setPaint(this.getComboBoxButtonBorderPaint(s, this.type));
        g.fill(s);
        s = this.createButtonPath(ShapeGenerator.CornerSize.INTERIOR, 1, 3, width - 4, height - 6);
        g.setPaint(this.getComboBoxButtonInteriorPaint(s, this.type));
        g.fill(s);
    }

    private void paintArrows(Graphics2D g, JComponent c, int width, int height) {
        int xOffset = width / 2 - 5;
        int yOffset = height / 2 - 3;
        g.translate(xOffset, yOffset);
        Shape s = this.shapeGenerator.createArrowLeft(0.5, 0.5, 3.0, 4.0);
        g.setPaint(this.getCommonArrowPaint(s, this.type));
        g.fill(s);
        s = this.shapeGenerator.createArrowRight(6.5, 0.5, 3.0, 4.0);
        g.setPaint(this.getCommonArrowPaint(s, this.type));
        g.fill(s);
        g.translate(-xOffset, -yOffset);
    }

    private void paintArrowDown(Graphics2D g, JComponent c, int width, int height) {
        int xOffset = width / 2 - 3;
        int yOffset = height / 2 - 5;
        g.translate(xOffset, yOffset);
        Shape s = this.shapeGenerator.createArrowLeft(1.0, 1.0, 4.2, 6.0);
        g.setPaint(this.getCommonArrowPaint(s, this.type));
        g.fill(s);
        g.translate(-xOffset, -yOffset);
    }

    private Shape createButtonPath(ShapeGenerator.CornerSize size, int x, int y, int w, int h) {
        return this.shapeGenerator.createRoundRectangle(x, y, w, h, size, ShapeGenerator.CornerStyle.SQUARE, ShapeGenerator.CornerStyle.SQUARE, ShapeGenerator.CornerStyle.ROUNDED, ShapeGenerator.CornerStyle.ROUNDED);
    }

    public Paint getComboBoxButtonBorderPaint(Shape s, AbstractCommonColorsPainter.CommonControlState type) {
        AbstractRegionPainter.TwoColors colors = this.getCommonBorderColors(type);
        return this.createVerticalGradient(s, colors);
    }

    public Paint getComboBoxButtonInteriorPaint(Shape s, AbstractCommonColorsPainter.CommonControlState type) {
        AbstractRegionPainter.FourColors colors = this.getCommonInteriorColors(type);
        return this.createVerticalGradient(s, colors);
    }

    @Override
    public AbstractRegionPainter.TwoColors getCommonBorderColors(AbstractCommonColorsPainter.CommonControlState type) {
        switch (type) {
            case DISABLED: {
                return super.getCommonBorderColors(AbstractCommonColorsPainter.CommonControlState.DISABLED);
            }
            case ENABLED: {
                return super.getCommonBorderColors(AbstractCommonColorsPainter.CommonControlState.PRESSED);
            }
            case PRESSED: {
                return super.getCommonBorderColors(AbstractCommonColorsPainter.CommonControlState.PRESSED_SELECTED);
            }
        }
        return null;
    }

    @Override
    public AbstractRegionPainter.FourColors getCommonInteriorColors(AbstractCommonColorsPainter.CommonControlState type) {
        switch (type) {
            case DISABLED: {
                return super.getCommonInteriorColors(AbstractCommonColorsPainter.CommonControlState.DISABLED);
            }
            case ENABLED: {
                return super.getCommonInteriorColors(AbstractCommonColorsPainter.CommonControlState.PRESSED);
            }
            case PRESSED: {
                return super.getCommonInteriorColors(AbstractCommonColorsPainter.CommonControlState.PRESSED_SELECTED);
            }
        }
        return null;
    }

    public static enum Which {
        BACKGROUND_DISABLED,
        BACKGROUND_ENABLED,
        BACKGROUND_PRESSED,
        BACKGROUND_SELECTED,
        FOREGROUND_ENABLED,
        FOREGROUND_DISABLED,
        FOREGROUND_PRESSED,
        FOREGROUND_SELECTED,
        FOREGROUND_ENABLED_EDITABLE,
        FOREGROUND_DISABLED_EDITABLE;

    }
}

