/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.painter;

import com.seaglasslookandfeel.effect.Effect;
import com.seaglasslookandfeel.effect.SeaGlassDropShadowEffect;
import com.seaglasslookandfeel.painter.AbstractCommonColorsPainter;
import com.seaglasslookandfeel.painter.AbstractRegionPainter;
import com.seaglasslookandfeel.painter.util.ShapeGenerator;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;

public final class CheckBoxPainter
extends AbstractCommonColorsPainter {
    private static final double SIZE_MULTIPLIER = 0.6666666666666666;
    private static final double X_MULTIPLIER = 0.2777777777777778;
    private static final double Y_MULTIPLIER = 0.05555555555555555;
    private Color buttonBulletBottomEnabled = this.decodeColor("buttonBulletBottomEnabled");
    private AbstractRegionPainter.TwoColors buttonBulletEnabled = new AbstractRegionPainter.TwoColors(this.deriveColor(this.buttonBulletBottomEnabled, 0.0f, 0.0f, 0.2f, 0), this.buttonBulletBottomEnabled);
    private AbstractRegionPainter.TwoColors buttonbulletDisabled = this.disable(this.buttonBulletEnabled);
    private AbstractRegionPainter.PaintContext ctx;
    private boolean focused;
    private boolean selected;
    private Effect dropShadow = new SeaGlassDropShadowEffect();
    private AbstractCommonColorsPainter.CommonControlState type;

    public CheckBoxPainter(Which state) {
        this.ctx = new AbstractRegionPainter.PaintContext(AbstractRegionPainter.PaintContext.CacheMode.FIXED_SIZES);
        this.type = this.getControlType(state);
        this.focused = false;
        this.selected = false;
        if (state == Which.ICON_FOCUSED || state == Which.ICON_PRESSED_FOCUSED || state == Which.ICON_SELECTED_FOCUSED || state == Which.ICON_PRESSED_SELECTED_FOCUSED) {
            this.focused = true;
        }
        if (state == Which.ICON_SELECTED || state == Which.ICON_PRESSED_SELECTED || state == Which.ICON_DISABLED_SELECTED || state == Which.ICON_SELECTED_FOCUSED || state == Which.ICON_PRESSED_SELECTED_FOCUSED) {
            this.selected = true;
        }
    }

    @Override
    protected void doPaint(Graphics2D g, JComponent c, int width, int height, Object[] extendedCacheKeys) {
        Shape s;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int size = width < height ? width : height;
        int x = (width - size) / 2;
        int y = (height - size) / 2;
        if (this.focused) {
            boolean useToolBarFocus = this.isInToolBar(c);
            s = this.shapeGenerator.createRoundRectangle(x, y, size, size, ShapeGenerator.CornerSize.CHECKBOX_OUTER_FOCUS);
            g.setPaint(this.getFocusPaint(s, AbstractRegionPainter.FocusType.OUTER_FOCUS, useToolBarFocus));
            g.fill(s);
            s = this.shapeGenerator.createRoundRectangle(x + 1, y + 1, size - 2, size - 2, ShapeGenerator.CornerSize.CHECKBOX_INNER_FOCUS);
            g.setPaint(this.getFocusPaint(s, AbstractRegionPainter.FocusType.INNER_FOCUS, useToolBarFocus));
            g.fill(s);
        }
        s = this.shapeGenerator.createRoundRectangle(x + 2, y + 2, size - 4, size - 4, ShapeGenerator.CornerSize.CHECKBOX_BORDER);
        if (!this.focused) {
            this.dropShadow.fill(g, s);
        }
        g.setPaint(this.getCommonBorderPaint(s, this.type));
        g.fill(s);
        s = this.shapeGenerator.createRoundRectangle(x + 3, y + 3, size - 6, size - 6, ShapeGenerator.CornerSize.CHECKBOX_INTERIOR);
        g.setPaint(this.getCommonInteriorPaint(s, this.type));
        g.fill(s);
        if (this.selected) {
            s = this.createCheckMark(x, y, size);
            g.setPaint(this.getCheckBoxBulletPaint(s, this.type));
            g.fill(s);
        }
    }

    @Override
    protected AbstractRegionPainter.PaintContext getPaintContext() {
        return this.ctx;
    }

    private AbstractCommonColorsPainter.CommonControlState getControlType(Which state) {
        switch (state) {
            case ICON_DISABLED: {
                return AbstractCommonColorsPainter.CommonControlState.DISABLED;
            }
            case ICON_ENABLED: 
            case ICON_FOCUSED: {
                return AbstractCommonColorsPainter.CommonControlState.ENABLED;
            }
            case ICON_PRESSED: 
            case ICON_PRESSED_FOCUSED: {
                return AbstractCommonColorsPainter.CommonControlState.PRESSED;
            }
            case ICON_SELECTED: 
            case ICON_SELECTED_FOCUSED: {
                return AbstractCommonColorsPainter.CommonControlState.SELECTED;
            }
            case ICON_PRESSED_SELECTED: 
            case ICON_PRESSED_SELECTED_FOCUSED: {
                return AbstractCommonColorsPainter.CommonControlState.PRESSED_SELECTED;
            }
            case ICON_DISABLED_SELECTED: {
                return AbstractCommonColorsPainter.CommonControlState.DISABLED_SELECTED;
            }
        }
        return null;
    }

    private Shape createCheckMark(int x, int y, int size) {
        int markSize = (int)((double)size * 0.6666666666666666 + 0.5);
        int markX = x + (int)((double)size * 0.2777777777777778 + 0.5);
        int markY = y + (int)((double)size * 0.05555555555555555 + 0.5);
        return this.shapeGenerator.createCheckMark(markX, markY, markSize, markSize);
    }

    public Paint getCheckBoxBulletPaint(Shape s, AbstractCommonColorsPainter.CommonControlState type) {
        return this.createCheckMarkGradient(s, this.getCheckBoxBulletColors(type));
    }

    private AbstractRegionPainter.TwoColors getCheckBoxBulletColors(AbstractCommonColorsPainter.CommonControlState type) {
        switch (type) {
            case DISABLED: 
            case DISABLED_SELECTED: {
                return this.buttonbulletDisabled;
            }
            case ENABLED: 
            case PRESSED: 
            case SELECTED: 
            case PRESSED_SELECTED: {
                return this.buttonBulletEnabled;
            }
        }
        return null;
    }

    private Paint createCheckMarkGradient(Shape s, AbstractRegionPainter.TwoColors colors) {
        Rectangle2D bounds = s.getBounds2D();
        float x = (float)bounds.getX();
        float y = (float)bounds.getY();
        float w = (float)bounds.getWidth();
        float h = (float)bounds.getHeight();
        return this.createGradient(x + w, y, 0.3f * w + x, h + y, new float[]{0.0f, 1.0f}, new Color[]{colors.top, colors.bottom});
    }

    public static enum Which {
        ICON_DISABLED,
        ICON_ENABLED,
        ICON_FOCUSED,
        ICON_PRESSED,
        ICON_PRESSED_FOCUSED,
        ICON_SELECTED,
        ICON_SELECTED_FOCUSED,
        ICON_PRESSED_SELECTED,
        ICON_PRESSED_SELECTED_FOCUSED,
        ICON_DISABLED_SELECTED;

    }
}

