/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.painter;

import com.seaglasslookandfeel.painter.AbstractRegionPainter;
import com.seaglasslookandfeel.painter.MenuItemPainter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import javax.swing.JComponent;

public final class CheckBoxMenuItemPainter
extends MenuItemPainter {
    private Which state;
    private AbstractRegionPainter.PaintContext ctx;
    private Color iconDisabledSelected = this.decodeColor("seaGlassDisabledText");
    private Color iconEnabledSelected = this.decodeColor("seaGlassMenuIcon");
    private Color iconEnabled = this.decodeColor("seaGlassMenuIcon");
    private Color iconSelectedMouseOver = this.decodeColor("seaGlassSelectedText");

    public CheckBoxMenuItemPainter(Which state) {
        super(MenuItemPainter.Which.BACKGROUND_ENABLED);
        this.state = state;
        switch (state) {
            case BACKGROUND_DISABLED: 
            case BACKGROUND_ENABLED: 
            case BACKGROUND_MOUSEOVER: 
            case BACKGROUND_SELECTED_MOUSEOVER: {
                this.ctx = new AbstractRegionPainter.PaintContext(AbstractRegionPainter.PaintContext.CacheMode.NO_CACHING);
                break;
            }
            default: {
                this.ctx = new AbstractRegionPainter.PaintContext(AbstractRegionPainter.PaintContext.CacheMode.FIXED_SIZES);
            }
        }
    }

    @Override
    protected void doPaint(Graphics2D g, JComponent c, int width, int height, Object[] extendedCacheKeys) {
        switch (this.state) {
            case BACKGROUND_MOUSEOVER: {
                this.paintBackgroundMouseOver(g, c, width, height);
                break;
            }
            case BACKGROUND_SELECTED_MOUSEOVER: {
                this.paintBackgroundMouseOver(g, c, width, height);
                break;
            }
            case CHECKICON_DISABLED_SELECTED: {
                this.paintCheckIconDisabledAndSelected(g, width, height);
                break;
            }
            case CHECKICON_ENABLED_SELECTED: {
                this.paintCheckIconEnabledAndSelected(g, width, height);
                break;
            }
            case CHECKICON_ENABLED: {
                this.paintCheckIconEnabled(g, width, height);
                break;
            }
            case CHECKICON_ENABLED_MOUSEOVER: {
                this.paintCheckIconEnabledAndMouseOver(g, width, height);
                break;
            }
            case CHECKICON_SELECTED_MOUSEOVER: {
                this.paintCheckIconSelectedAndMouseOver(g, width, height);
            }
        }
    }

    @Override
    protected AbstractRegionPainter.PaintContext getPaintContext() {
        return this.ctx;
    }

    private void paintCheckIconDisabledAndSelected(Graphics2D g, int width, int height) {
        Shape s = this.shapeGenerator.createCheckMark(0, 0, width, height);
        g.setPaint(this.iconDisabledSelected);
        g.fill(s);
    }

    private void paintCheckIconEnabledAndSelected(Graphics2D g, int width, int height) {
        Shape s = this.shapeGenerator.createCheckMark(0, 0, width, height);
        g.setPaint(this.iconEnabledSelected);
        g.fill(s);
    }

    private void paintCheckIconEnabled(Graphics2D g, int width, int height) {
        g.setPaint(this.iconEnabled);
        g.drawRoundRect(0, 1, width - 1, height - 2, 4, 4);
    }

    private void paintCheckIconSelectedAndMouseOver(Graphics2D g, int width, int height) {
        Shape s = this.shapeGenerator.createCheckMark(0, 0, width, height);
        g.setPaint(this.iconSelectedMouseOver);
        g.fill(s);
    }

    private void paintCheckIconEnabledAndMouseOver(Graphics2D g, int width, int height) {
        g.setPaint(this.iconSelectedMouseOver);
        g.drawRoundRect(0, 1, width - 1, height - 2, 4, 4);
    }

    public static enum Which {
        BACKGROUND_DISABLED,
        BACKGROUND_ENABLED,
        BACKGROUND_MOUSEOVER,
        BACKGROUND_SELECTED_MOUSEOVER,
        CHECKICON_DISABLED_SELECTED,
        CHECKICON_ENABLED_SELECTED,
        CHECKICON_SELECTED_MOUSEOVER,
        CHECKICON_ENABLED_MOUSEOVER,
        CHECKICON_ENABLED;

    }
}

