/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.painter;

import com.seaglasslookandfeel.painter.AbstractRegionPainter;
import com.seaglasslookandfeel.painter.button.ButtonVariantPainter;
import com.seaglasslookandfeel.painter.button.SegmentedButtonPainter;
import com.seaglasslookandfeel.painter.button.TexturedButtonPainter;
import java.awt.Graphics2D;
import javax.swing.JComponent;

public final class ButtonPainter
extends AbstractRegionPainter {
    private AbstractRegionPainter.PaintContext ctx = new AbstractRegionPainter.PaintContext(AbstractRegionPainter.PaintContext.CacheMode.FIXED_SIZES);
    private ButtonVariantPainter standard;
    private ButtonVariantPainter textured;

    public ButtonPainter(Which state) {
        this.standard = new SegmentedButtonPainter(state, this.ctx);
        this.textured = new TexturedButtonPainter(state, this.ctx);
    }

    @Override
    protected Object[] getExtendedCacheKeys(JComponent c) {
        Object[] extendedCacheKeys = new Object[]{};
        return extendedCacheKeys;
    }

    @Override
    protected AbstractRegionPainter.PaintContext getPaintContext() {
        return this.ctx;
    }

    @Override
    protected void doPaint(Graphics2D g, JComponent c, int width, int height, Object[] extendedCacheKeys) {
        this.getButtonPainter(c).doPaint(g, c, width, height, extendedCacheKeys);
    }

    private ButtonVariantPainter getButtonPainter(JComponent c) {
        Object buttonType = c.getClientProperty("JButton.buttonType");
        ButtonVariantPainter button = this.standard;
        if ("textured".equals(buttonType) || "segmentedTextured".equals(buttonType)) {
            button = this.textured;
        }
        return button;
    }

    public static enum Which {
        BACKGROUND_DEFAULT,
        BACKGROUND_DEFAULT_FOCUSED,
        BACKGROUND_PRESSED_DEFAULT,
        BACKGROUND_PRESSED_DEFAULT_FOCUSED,
        BACKGROUND_DISABLED,
        BACKGROUND_ENABLED,
        BACKGROUND_FOCUSED,
        BACKGROUND_PRESSED,
        BACKGROUND_PRESSED_FOCUSED,
        BACKGROUND_SELECTED,
        BACKGROUND_SELECTED_FOCUSED,
        BACKGROUND_PRESSED_SELECTED,
        BACKGROUND_PRESSED_SELECTED_FOCUSED,
        BACKGROUND_DISABLED_SELECTED;

    }
}

