/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.painter;

import com.seaglasslookandfeel.painter.AbstractRegionPainter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import javax.swing.JComponent;

public final class ArrowButtonPainter
extends AbstractRegionPainter {
    private Color disabledColor = this.decodeColor("ArrowButton[Disabled].foreground");
    private Color enabledColor = this.decodeColor("ArrowButton[Enabled].foreground");
    private Color pressedColor = this.decodeColor("ArrowButton[Pressed].foreground");
    private Which state;
    private AbstractRegionPainter.PaintContext ctx;

    public ArrowButtonPainter(Which state) {
        this.state = state;
        this.ctx = new AbstractRegionPainter.PaintContext(AbstractRegionPainter.PaintContext.CacheMode.FIXED_SIZES);
    }

    @Override
    protected void doPaint(Graphics2D g, JComponent c, int width, int height, Object[] extendedCacheKeys) {
        switch (this.state) {
            case FOREGROUND_DISABLED: {
                this.paintForegroundDisabled(g, width, height);
                break;
            }
            case FOREGROUND_ENABLED: {
                this.paintForegroundEnabled(g, width, height);
                break;
            }
            case FOREGROUND_PRESSED: {
                this.paintForegroundPressed(g, width, height);
            }
        }
    }

    @Override
    protected AbstractRegionPainter.PaintContext getPaintContext() {
        return this.ctx;
    }

    private void paintForegroundDisabled(Graphics2D g, int width, int height) {
        Shape s = this.decodeArrowPath(width, height);
        g.setPaint(this.disabledColor);
        g.fill(s);
    }

    private void paintForegroundEnabled(Graphics2D g, int width, int height) {
        Shape s = this.decodeArrowPath(width, height);
        g.setPaint(this.enabledColor);
        g.fill(s);
    }

    private void paintForegroundPressed(Graphics2D g, int width, int height) {
        Shape s = this.decodeArrowPath(width, height);
        g.setPaint(this.pressedColor);
        g.fill(s);
    }

    private Shape decodeArrowPath(int width, int height) {
        return this.shapeGenerator.createArrowLeft((double)width * 0.2, (double)height * 0.2, (double)width * 0.6, (double)height * 0.6);
    }

    public static enum Which {
        BACKGROUND_ENABLED,
        FOREGROUND_DISABLED,
        FOREGROUND_ENABLED,
        FOREGROUND_PRESSED;

    }
}

