/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.painter;

import com.seaglasslookandfeel.SeaGlassLookAndFeel;
import com.seaglasslookandfeel.painter.SeaGlassPainter;
import com.seaglasslookandfeel.painter.util.ShapeGenerator;
import com.seaglasslookandfeel.state.ControlInToolBarState;
import com.seaglasslookandfeel.state.State;
import com.seaglasslookandfeel.util.ImageCache;
import com.seaglasslookandfeel.util.SeaGlassGraphicsUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.image.VolatileImage;
import java.awt.print.PrinterGraphics;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;

public abstract class AbstractRegionPainter
implements SeaGlassPainter<JComponent> {
    private static final State inToolBarState = new ControlInToolBarState();
    private PaintContext ctx;
    protected ShapeGenerator shapeGenerator = new ShapeGenerator();
    protected Insets focusInsets;
    private Color outerFocus = this.decodeColor("seaGlassOuterFocus");
    private Color innerFocus = this.decodeColor("seaGlassFocus");
    private Color outerToolBarFocus = this.decodeColor("seaGlassToolBarOuterFocus");
    private Color innerToolBarFocus = this.decodeColor("seaGlassToolBarFocus");

    protected AbstractRegionPainter() {
        this.focusInsets = UIManager.getInsets("seaGlassFocusInsets");
    }

    protected boolean isInToolBar(JComponent c) {
        return inToolBarState.isInState(c);
    }

    @Override
    public final void paint(Graphics2D g, JComponent c, int w, int h) {
        PaintContext.CacheMode cacheMode;
        if (w <= 0 || h <= 0) {
            return;
        }
        Object[] extendedCacheKeys = this.getExtendedCacheKeys(c);
        this.ctx = this.getPaintContext();
        PaintContext.CacheMode cacheMode2 = cacheMode = this.ctx == null ? PaintContext.CacheMode.NO_CACHING : this.ctx.getCacheMode();
        if (cacheMode == PaintContext.CacheMode.NO_CACHING || !ImageCache.getInstance().isImageCachable(w, h) || g instanceof PrinterGraphics) {
            this.paintDirectly(g, c, w, h, extendedCacheKeys);
        } else {
            this.paintWithCaching(g, c, w, h, extendedCacheKeys);
        }
    }

    protected Object[] getExtendedCacheKeys(JComponent c) {
        return null;
    }

    protected abstract PaintContext getPaintContext();

    public Paint getFocusPaint(Shape s, FocusType focusType, boolean useToolBarFocus) {
        if (focusType == FocusType.OUTER_FOCUS) {
            return useToolBarFocus ? this.outerToolBarFocus : this.outerFocus;
        }
        return useToolBarFocus ? this.innerToolBarFocus : this.innerFocus;
    }

    protected void configureGraphics(Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    protected abstract void doPaint(Graphics2D var1, JComponent var2, int var3, int var4, Object[] var5);

    protected final Color decodeColor(String key) {
        return this.decodeColor(key, 0.0f, 0.0f, 0.0f, 0);
    }

    protected final Color decodeColor(String key, float hOffset, float sOffset, float bOffset, int aOffset) {
        if (UIManager.getLookAndFeel() instanceof SeaGlassLookAndFeel) {
            SeaGlassLookAndFeel laf = (SeaGlassLookAndFeel)UIManager.getLookAndFeel();
            return laf.getDerivedColor(key, hOffset, sOffset, bOffset, aOffset, true);
        }
        return Color.getHSBColor(hOffset, sOffset, bOffset);
    }

    protected Color deriveColor(Color src, float hOffset, float sOffset, float bOffset, int aOffset) {
        float[] tmp = Color.RGBtoHSB(src.getRed(), src.getGreen(), src.getBlue(), null);
        tmp[0] = this.clamp(tmp[0] + hOffset);
        tmp[1] = this.clamp(tmp[1] + sOffset);
        tmp[2] = this.clamp(tmp[2] + bOffset);
        int alpha = this.clamp(src.getAlpha() + aOffset);
        return new Color(Color.HSBtoRGB(tmp[0], tmp[1], tmp[2]) & 0xFFFFFF | alpha << 24, true);
    }

    protected final Color decodeColor(Color color1, Color color2, float midPoint) {
        return new Color(AbstractRegionPainter.deriveARGB(color1, color2, midPoint));
    }

    public static int deriveARGB(Color color1, Color color2, float midPoint) {
        int r = color1.getRed() + (int)((float)(color2.getRed() - color1.getRed()) * midPoint + 0.5f);
        int g = color1.getGreen() + (int)((float)(color2.getGreen() - color1.getGreen()) * midPoint + 0.5f);
        int b = color1.getBlue() + (int)((float)(color2.getBlue() - color1.getBlue()) * midPoint + 0.5f);
        int a = color1.getAlpha() + (int)((float)(color2.getAlpha() - color1.getAlpha()) * midPoint + 0.5f);
        return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    protected final LinearGradientPaint createGradient(float x1, float y1, float x2, float y2, float[] midpoints, Color[] colors) {
        if (x1 == x2 && y1 == y2) {
            y2 += 1.0E-5f;
        }
        return new LinearGradientPaint(x1, y1, x2, y2, midpoints, colors);
    }

    protected final RadialGradientPaint createRadialGradient(float x, float y, float r, float[] midpoints, Color[] colors) {
        if (r == 0.0f) {
            r = 1.0E-5f;
        }
        return new RadialGradientPaint(x, y, r, midpoints, colors);
    }

    protected Paint createVerticalGradient(Shape s, TwoColors colors) {
        Rectangle2D bounds = s.getBounds2D();
        float xCenter = (float)bounds.getCenterX();
        float yMin = (float)bounds.getMinY();
        float yMax = (float)bounds.getMaxY();
        return this.createGradient(xCenter, yMin, xCenter, yMax, new float[]{0.0f, 1.0f}, new Color[]{colors.top, colors.bottom});
    }

    protected Paint createVerticalGradient(Shape s, FourColors colors) {
        Rectangle2D bounds = s.getBounds2D();
        float xCenter = (float)bounds.getCenterX();
        float yMin = (float)bounds.getMinY();
        float yMax = (float)bounds.getMaxY();
        return this.createGradient(xCenter, yMin, xCenter, yMax, new float[]{0.0f, 0.45f, 0.62f, 1.0f}, new Color[]{colors.top, colors.upperMid, colors.lowerMid, colors.bottom});
    }

    protected Paint createHorizontalGradient(Shape s, TwoColors colors) {
        Rectangle2D bounds = s.getBounds2D();
        float xMin = (float)bounds.getMinX();
        float xMax = (float)bounds.getMaxX();
        float yCenter = (float)bounds.getCenterY();
        return this.createGradient(xMin, yCenter, xMax, yCenter, new float[]{0.0f, 1.0f}, new Color[]{colors.top, colors.bottom});
    }

    protected Paint createHorizontalGradient(Shape s, FourColors colors) {
        Rectangle2D bounds = s.getBounds2D();
        float x = (float)bounds.getX();
        float y = (float)bounds.getY();
        float w = (float)bounds.getWidth();
        float h = (float)bounds.getHeight();
        return this.createGradient(x, 0.5f * h + y, x + w, 0.5f * h + y, new float[]{0.0f, 0.45f, 0.62f, 1.0f}, new Color[]{colors.top, colors.upperMid, colors.lowerMid, colors.bottom});
    }

    protected final Color getComponentColor(JComponent c, String property, Color defaultColor, float saturationOffset, float brightnessOffset, int alphaOffset) {
        Color color = null;
        if (c != null) {
            if ("background".equals(property)) {
                color = c.getBackground();
            } else if ("foreground".equals(property)) {
                color = c.getForeground();
            } else if (c instanceof JList && "selectionForeground".equals(property)) {
                color = ((JList)c).getSelectionForeground();
            } else if (c instanceof JList && "selectionBackground".equals(property)) {
                color = ((JList)c).getSelectionBackground();
            } else if (c instanceof JTable && "selectionForeground".equals(property)) {
                color = ((JTable)c).getSelectionForeground();
            } else if (c instanceof JTable && "selectionBackground".equals(property)) {
                color = ((JTable)c).getSelectionBackground();
            } else {
                Object value;
                String s = "get" + Character.toUpperCase(property.charAt(0)) + property.substring(1);
                try {
                    Method method = c.getClass().getMethod(s, new Class[0]);
                    color = (Color)method.invoke((Object)c, new Object[0]);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (color == null && (value = c.getClientProperty(property)) instanceof Color) {
                    color = (Color)value;
                }
            }
        }
        if (color == null || color instanceof UIResource) {
            return defaultColor;
        }
        if (saturationOffset != 0.0f || brightnessOffset != 0.0f || alphaOffset != 0) {
            float[] tmp = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
            tmp[1] = this.clamp(tmp[1] + saturationOffset);
            tmp[2] = this.clamp(tmp[2] + brightnessOffset);
            int alpha = this.clamp(color.getAlpha() + alphaOffset);
            return new Color(Color.HSBtoRGB(tmp[0], tmp[1], tmp[2]) & 0xFFFFFF | alpha << 24);
        }
        return color;
    }

    protected Color disable(Color color) {
        return SeaGlassGraphicsUtils.disable(color);
    }

    protected Color desaturate(Color color) {
        float[] tmp = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        tmp[1] = tmp[1] / 3.0f;
        tmp[2] = this.clamp(1.0f - (1.0f - tmp[2]) / 3.0f);
        return new Color(Color.HSBtoRGB(tmp[0], tmp[1], tmp[2]) & 0xFFFFFF);
    }

    protected TwoColors disable(TwoColors colors) {
        return new TwoColors(this.disable(colors.top), this.disable(colors.bottom));
    }

    protected TwoColors desaturate(TwoColors colors) {
        return new TwoColors(this.desaturate(colors.top), this.desaturate(colors.bottom));
    }

    protected FourColors disable(FourColors colors) {
        return new FourColors(this.disable(colors.top), this.disable(colors.upperMid), this.disable(colors.lowerMid), this.disable(colors.bottom));
    }

    protected FourColors desaturate(FourColors colors) {
        return new FourColors(this.desaturate(colors.top), this.desaturate(colors.upperMid), this.desaturate(colors.lowerMid), this.desaturate(colors.bottom));
    }

    private void paintWithCaching(Graphics2D g, JComponent c, int w, int h, Object[] extendedCacheKeys) {
        VolatileImage img = this.getImage(g.getDeviceConfiguration(), c, w, h, extendedCacheKeys);
        if (img != null) {
            g.drawImage(img, 0, 0, null);
        } else {
            this.paintDirectly(g, c, w, h, extendedCacheKeys);
        }
    }

    private void paintDirectly(Graphics2D g, JComponent c, int w, int h, Object[] extendedCacheKeys) {
        g = (Graphics2D)g.create();
        this.configureGraphics(g);
        this.doPaint(g, c, w, h, extendedCacheKeys);
        g.dispose();
    }

    private VolatileImage getImage(GraphicsConfiguration config, JComponent c, int w, int h, Object[] extendedCacheKeys) {
        ImageCache imageCache = ImageCache.getInstance();
        VolatileImage buffer = (VolatileImage)imageCache.getImage(config, w, h, this, extendedCacheKeys);
        int renderCounter = 0;
        do {
            int bufferStatus = 2;
            if (buffer != null) {
                bufferStatus = buffer.validate(config);
            }
            if (bufferStatus != 2 && bufferStatus != 1) continue;
            if (buffer == null || buffer.getWidth() != w || buffer.getHeight() != h || bufferStatus == 2) {
                if (buffer != null) {
                    buffer.flush();
                    buffer = null;
                }
                buffer = config.createCompatibleVolatileImage(w, h, 3);
                imageCache.setImage(buffer, config, w, h, this, extendedCacheKeys);
            }
            Graphics2D bg = buffer.createGraphics();
            bg.setComposite(AlphaComposite.Clear);
            bg.fillRect(0, 0, w, h);
            bg.setComposite(AlphaComposite.SrcOver);
            this.configureGraphics(bg);
            this.paintDirectly(bg, c, w, h, extendedCacheKeys);
            bg.dispose();
        } while (buffer.contentsLost() && renderCounter++ < 3);
        if (renderCounter == 3) {
            return null;
        }
        return buffer;
    }

    private float clamp(float value) {
        if (value < 0.0f) {
            value = 0.0f;
        } else if (value > 1.0f) {
            value = 1.0f;
        }
        return value;
    }

    private int clamp(int value) {
        if (value < 0) {
            value = 0;
        } else if (value > 255) {
            value = 255;
        }
        return value;
    }

    public static class FourColors
    extends TwoColors {
        public Color upperMid;
        public Color lowerMid;

        public FourColors(Color top, Color upperMid, Color lowerMid, Color bottom) {
            super(top, bottom);
            this.upperMid = upperMid;
            this.lowerMid = lowerMid;
        }
    }

    public static class ThreeColors
    extends TwoColors {
        public Color mid;

        public ThreeColors(Color top, Color mid, Color bottom) {
            super(top, bottom);
            this.mid = mid;
        }
    }

    public static class TwoColors {
        public Color top;
        public Color bottom;

        public TwoColors(Color top, Color bottom) {
            this.top = top;
            this.bottom = bottom;
        }
    }

    public static class PaintContext {
        private CacheMode cacheMode;

        public PaintContext(CacheMode cacheMode) {
            this.cacheMode = cacheMode == null ? CacheMode.NO_CACHING : cacheMode;
        }

        public CacheMode getCacheMode() {
            return this.cacheMode;
        }

        public static enum CacheMode {
            NO_CACHING,
            FIXED_SIZES;

        }
    }

    public static enum FocusType {
        INNER_FOCUS,
        OUTER_FOCUS;

    }
}

