/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.effect;

import com.seaglasslookandfeel.painter.AbstractRegionPainter;
import com.seaglasslookandfeel.painter.util.ShapeGenerator;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import javax.swing.UIManager;

public class SeaGlassInternalShadowEffect {
    private Color transparentColor = UIManager.getColor("seaGlassTransparent");
    private Color innerShadowBase = UIManager.getColor("seaGlassInnerShadow");
    private Color innerShadowLight = new Color(this.innerShadowBase.getRed(), this.innerShadowBase.getGreen(), this.innerShadowBase.getBlue(), this.innerShadowBase.getAlpha() / 2);
    private AbstractRegionPainter.TwoColors innerShadow = new AbstractRegionPainter.TwoColors(this.innerShadowBase, this.innerShadowLight);
    private ShapeGenerator shapeGenerator = new ShapeGenerator();

    public void fill(Graphics2D g, Shape s, boolean isRounded, boolean paintRightShadow) {
        if (isRounded) {
            this.fillInternalShadowRounded(g, s);
        } else {
            this.fillInternalShadow(g, s, paintRightShadow);
        }
    }

    private void fillInternalShadow(Graphics2D g, Shape s, boolean paintRightShadow) {
        Rectangle bounds = s.getBounds();
        int x = bounds.x;
        int y = bounds.y;
        int w = bounds.width;
        int h = bounds.height;
        s = this.shapeGenerator.createRectangle(x, y, w, 2);
        g.setPaint(this.getTopShadowGradient(s));
        g.fill(s);
        s = this.shapeGenerator.createRectangle(x, y, 1, h);
        g.setPaint(this.getLeftShadowGradient(s));
        g.fill(s);
        if (paintRightShadow) {
            s = this.shapeGenerator.createRectangle(x + w - 1, y, 1, h);
            g.setPaint(this.getRightShadowGradient(s));
            g.fill(s);
        }
    }

    private void fillInternalShadowRounded(Graphics2D g, Shape s) {
        g.setPaint(this.getRoundedShadowGradient(s));
        g.fill(s);
    }

    public Paint getRoundedShadowGradient(Shape s) {
        Rectangle r = s.getBounds();
        int x = r.x + r.width / 2;
        int y1 = r.y;
        float frac = 1.0f / (float)r.height;
        int y2 = r.y + r.height;
        return new LinearGradientPaint(x, y1, x, y2, new float[]{0.0f, frac, 1.0f}, new Color[]{this.innerShadow.top, this.innerShadow.bottom, this.innerShadow.bottom});
    }

    public Paint getTopShadowGradient(Shape s) {
        Rectangle2D bounds = s.getBounds2D();
        float minY = (float)bounds.getMinY();
        float maxY = (float)bounds.getMaxY();
        float midX = (float)bounds.getCenterX();
        return new LinearGradientPaint(midX, minY, midX, maxY, new float[]{0.0f, 1.0f}, new Color[]{this.innerShadow.top, this.transparentColor});
    }

    public Paint getLeftShadowGradient(Shape s) {
        Rectangle2D bounds = s.getBounds2D();
        float minX = (float)bounds.getMinX();
        float maxX = (float)bounds.getMaxX();
        float midY = (float)bounds.getCenterY();
        return new LinearGradientPaint(minX, midY, maxX, midY, new float[]{0.0f, 1.0f}, new Color[]{this.innerShadow.bottom, this.transparentColor});
    }

    public Paint getRightShadowGradient(Shape s) {
        Rectangle2D bounds = s.getBounds2D();
        float minX = (float)bounds.getMinX() - 1.0f;
        float maxX = (float)bounds.getMaxX() - 1.0f;
        float midY = (float)bounds.getCenterY();
        return new LinearGradientPaint(minX, midY, maxX, midY, new float[]{0.0f, 1.0f}, new Color[]{this.transparentColor, this.innerShadow.bottom});
    }
}

