/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.effect;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import java.lang.ref.SoftReference;
import javax.swing.ImageIcon;
import sun.awt.AppContext;

public abstract class Effect {
    protected abstract EffectType getEffectType();

    protected abstract float getOpacity();

    public abstract BufferedImage applyEffect(BufferedImage var1, BufferedImage var2, int var3, int var4);

    public void fill(Graphics2D g, Shape s) {
        Rectangle bounds = s.getBounds();
        int width = bounds.width;
        int height = bounds.height;
        BufferedImage bimage = Effect.createBufferedImage(width, height, true);
        Graphics2D gbi = bimage.createGraphics();
        gbi.setColor(Color.BLACK);
        gbi.fill(s);
        g.drawImage((Image)this.applyEffect(bimage, null, width, height), 0, 0, null);
    }

    protected static ArrayCache getArrayCache() {
        ArrayCache cache = (ArrayCache)AppContext.getAppContext().get(ArrayCache.class);
        if (cache == null) {
            cache = new ArrayCache();
            AppContext.getAppContext().put(ArrayCache.class, cache);
        }
        return cache;
    }

    protected static BufferedImage createBufferedImage(int width, int height, boolean hasAlpha) {
        BufferedImage bimage = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            int transparency = 1;
            if (hasAlpha) {
                transparency = 3;
            }
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gs.getDefaultConfiguration();
            bimage = gc.createCompatibleImage(width, height, transparency);
        }
        catch (HeadlessException e) {
            // empty catch block
        }
        if (bimage == null) {
            int type = 1;
            if (hasAlpha) {
                type = 2;
            }
            bimage = new BufferedImage(width, height, type);
        }
        return bimage;
    }

    protected static BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        boolean hasAlpha = Effect.hasAlpha(image);
        BufferedImage bimage = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            int transparency = 1;
            if (hasAlpha) {
                transparency = 2;
            }
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gs.getDefaultConfiguration();
            bimage = gc.createCompatibleImage(image.getWidth(null), image.getHeight(null), transparency);
        }
        catch (HeadlessException e) {
            // empty catch block
        }
        if (bimage == null) {
            int type = 1;
            if (hasAlpha) {
                type = 2;
            }
            bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
        }
        Graphics2D g = bimage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bimage;
    }

    private static boolean hasAlpha(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bimage = (BufferedImage)image;
            return bimage.getColorModel().hasAlpha();
        }
        PixelGrabber pg = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        ColorModel cm = pg.getColorModel();
        return cm.hasAlpha();
    }

    protected static class ArrayCache {
        private SoftReference<int[]> tmpIntArray = null;
        private SoftReference<byte[]> tmpByteArray1 = null;
        private SoftReference<byte[]> tmpByteArray2 = null;
        private SoftReference<byte[]> tmpByteArray3 = null;

        protected ArrayCache() {
        }

        protected int[] getTmpIntArray(int size) {
            int[] tmp;
            if (this.tmpIntArray == null || (tmp = this.tmpIntArray.get()) == null || tmp.length < size) {
                tmp = new int[size];
                this.tmpIntArray = new SoftReference<int[]>(tmp);
            }
            return tmp;
        }

        protected byte[] getTmpByteArray1(int size) {
            byte[] tmp;
            if (this.tmpByteArray1 == null || (tmp = this.tmpByteArray1.get()) == null || tmp.length < size) {
                tmp = new byte[size];
                this.tmpByteArray1 = new SoftReference<byte[]>(tmp);
            }
            return tmp;
        }

        protected byte[] getTmpByteArray2(int size) {
            byte[] tmp;
            if (this.tmpByteArray2 == null || (tmp = this.tmpByteArray2.get()) == null || tmp.length < size) {
                tmp = new byte[size];
                this.tmpByteArray2 = new SoftReference<byte[]>(tmp);
            }
            return tmp;
        }

        protected byte[] getTmpByteArray3(int size) {
            byte[] tmp;
            if (this.tmpByteArray3 == null || (tmp = this.tmpByteArray3.get()) == null || tmp.length < size) {
                tmp = new byte[size];
                this.tmpByteArray3 = new SoftReference<byte[]>(tmp);
            }
            return tmp;
        }
    }

    public static enum EffectType {
        UNDER,
        BLENDED,
        OVER;

    }
}

