/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.component;

import com.seaglasslookandfeel.SeaGlassContext;
import com.seaglasslookandfeel.SeaGlassLookAndFeel;
import com.seaglasslookandfeel.ui.SeaGlassButtonUI;
import com.seaglasslookandfeel.ui.SeaGlassRootPaneUI;
import com.seaglasslookandfeel.ui.SeaglassUI;
import com.seaglasslookandfeel.util.SeaGlassGraphicsUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.RootPaneContainer;
import javax.swing.UIManager;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthGraphicsUtils;
import javax.swing.plaf.synth.SynthStyle;
import sun.swing.SwingUtilities2;

public class SeaGlassTitlePane
extends JComponent
implements SeaglassUI,
PropertyChangeListener {
    private static final long serialVersionUID = 7006086880911744060L;
    private static final String WINDOW_DOCUMENT_MODIFIED = "Window.documentModified";
    private static final String CLOSE_CMD = UIManager.getString("InternalFrameTitlePane.closeButtonText");
    private static final String ICONIFY_CMD = UIManager.getString("InternalFrameTitlePane.minimizeButtonText");
    private static final String RESTORE_CMD = UIManager.getString("InternalFrameTitlePane.restoreButtonText");
    private static final String MAXIMIZE_CMD = UIManager.getString("InternalFrameTitlePane.maximizeButtonText");
    private static final String MOVE_CMD = UIManager.getString("InternalFrameTitlePane.moveButtonText");
    private static final String SIZE_CMD = UIManager.getString("InternalFrameTitlePane.sizeButtonText");
    private JButton iconButton;
    private JButton maxButton;
    private JButton closeButton;
    private JButton menuButton;
    private JPopupMenu windowMenu;
    private JRootPane rootPane;
    private RootPaneContainer rootParent;
    private Action closeAction;
    private Action maximizeAction;
    private Action iconifyAction;
    private Action restoreAction;
    private Action moveAction;
    private Action sizeAction;
    private Color DEFAULT_EMPHASIS_COLOR = UIManager.getColor("seaGlassTextEmphasis");
    private String closeButtonToolTip;
    private String iconButtonToolTip;
    private String restoreButtonToolTip;
    private String maxButtonToolTip;
    private int state = -1;
    private SeaGlassRootPaneUI rootPaneUI;
    private SynthStyle style;
    private int titleSpacing;

    public SeaGlassTitlePane(JRootPane rootPane, SeaGlassRootPaneUI ui) {
        this.rootPane = rootPane;
        this.rootPaneUI = ui;
        this.rootParent = (RootPaneContainer)((Object)rootPane.getParent());
        this.installTitlePane();
    }

    @Override
    public JRootPane getRootPane() {
        return this.rootPane;
    }

    @Override
    public String getUIClassID() {
        return "InternalFrameTitlePaneUI";
    }

    @Override
    public SeaGlassContext getContext(JComponent c) {
        return this.getContext(c, this.getComponentState(c));
    }

    public SeaGlassContext getContext(JComponent c, int state) {
        return SeaGlassContext.getContext(SeaGlassContext.class, c, SeaGlassLookAndFeel.getRegion(c), this.style, state);
    }

    private int getComponentState(JComponent c) {
        if (this.rootParent != null && this.isParentSelected()) {
            return 512;
        }
        return SeaGlassLookAndFeel.getComponentState(c);
    }

    private boolean isParentSelected() {
        if (this.rootParent instanceof JFrame) {
            return ((JFrame)this.rootParent).isActive();
        }
        if (this.rootParent instanceof JDialog) {
            return ((JDialog)this.rootParent).isActive();
        }
        return true;
    }

    private boolean isParentIcon() {
        if (this.rootParent instanceof JFrame) {
            return (((JFrame)this.rootParent).getExtendedState() & 1) != 0;
        }
        return false;
    }

    private boolean isParentMaximum() {
        if (this.rootParent instanceof JFrame) {
            return (((JFrame)this.rootParent).getExtendedState() & 6) != 0;
        }
        return false;
    }

    private boolean isParentLeftToRight() {
        if (this.rootParent instanceof JFrame) {
            return SeaGlassLookAndFeel.isLeftToRight((JFrame)this.rootParent);
        }
        if (this.rootParent instanceof JDialog) {
            return SeaGlassLookAndFeel.isLeftToRight((JDialog)this.rootParent);
        }
        return false;
    }

    private void doParentDefaultCloseAction() {
        ((Window)((Object)this.rootParent)).dispatchEvent(new WindowEvent((Window)((Object)this.rootParent), 201));
    }

    private void setParentIcon(boolean iconify) {
        if (this.rootParent instanceof JFrame) {
            JFrame frame = (JFrame)this.rootParent;
            int state = frame.getExtendedState();
            ((JFrame)this.rootParent).setExtendedState(iconify ? state | 1 : state & 0xFFFFFFFE);
        }
    }

    private void setParentMaximum(boolean maximize) {
        if (this.rootParent instanceof JFrame) {
            JFrame frame = (JFrame)this.rootParent;
            int state = frame.getExtendedState();
            if (maximize) {
                GraphicsConfiguration gc = frame.getGraphicsConfiguration();
                Insets i = Toolkit.getDefaultToolkit().getScreenInsets(gc);
                Rectangle r = gc.getBounds();
                r.x += i.left;
                r.y += i.top;
                r.width -= i.left + i.right;
                r.height -= i.top + i.bottom;
                frame.setMaximizedBounds(r);
            }
            frame.setExtendedState(maximize ? state | 6 : state & 0xFFFFFFF9);
        }
    }

    private void addParentPropertyChangeListener(PropertyChangeListener listener) {
        if (this.rootParent instanceof JFrame) {
            ((JFrame)this.rootParent).addPropertyChangeListener(listener);
        } else if (this.rootParent instanceof JDialog) {
            ((JDialog)this.rootParent).addPropertyChangeListener(listener);
        }
        this.rootPane.addPropertyChangeListener(listener);
    }

    private void removeParentPropertyChangeListener(PropertyChangeListener listener) {
        if (this.rootParent instanceof JFrame) {
            ((JFrame)this.rootParent).removePropertyChangeListener(listener);
        } else if (this.rootParent instanceof JDialog) {
            ((JDialog)this.rootParent).removePropertyChangeListener(listener);
        }
    }

    private boolean isParentClosable() {
        return true;
    }

    private boolean isParentIconifiable() {
        return true;
    }

    private boolean isParentMaximizable() {
        return true;
    }

    private void installTitlePane() {
        this.installDefaults();
        this.installListeners();
        this.createActions();
        this.enableActions();
        this.createActionMap();
        this.setLayout(this.createLayout());
        this.assembleSystemMenu();
        this.createButtons();
        this.addSubComponents();
    }

    private void assembleSystemMenu() {
        this.windowMenu = new JPopupMenu();
        this.addSystemMenuItems(this.windowMenu);
        this.enableActions();
        this.menuButton = new JButton();
        this.menuButton.setName("InternalFrameTitlePane.menuButtonAccessibleName");
        this.updateMenuIcon();
        this.menuButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                SeaGlassTitlePane.this.showSystemMenu();
            }
        });
        this.setInheritsPopupMenu(true);
    }

    private void addSystemMenuItems(JPopupMenu menu) {
        JMenuItem mi = menu.add(this.restoreAction);
        mi.setMnemonic('R');
        mi = menu.add(this.moveAction);
        mi.setMnemonic('M');
        mi = menu.add(this.sizeAction);
        mi.setMnemonic('S');
        mi = menu.add(this.iconifyAction);
        mi.setMnemonic('n');
        mi = menu.add(this.maximizeAction);
        mi.setMnemonic('x');
        menu.add(new JSeparator());
        mi = menu.add(this.closeAction);
        mi.setMnemonic('C');
    }

    private void showSystemMenu() {
        Insets insets = this.rootPane.getInsets();
        this.windowMenu.show(this.menuButton, this.getX() - insets.left - insets.right, this.getY() + this.getPreferredSize().height);
    }

    private void updateMenuIcon() {
        List<Image> iconList = null;
        if (this.rootParent instanceof JFrame) {
            iconList = ((JFrame)this.rootParent).getIconImages();
        } else if (this.rootParent instanceof JDialog) {
            iconList = ((JDialog)this.rootParent).getIconImages();
        }
        Image frameIcon = iconList != null && iconList.size() > 0 ? iconList.get(0) : null;
        SeaGlassContext context = this.getContext(this);
        if (frameIcon != null) {
            Dimension maxSize = (Dimension)context.getStyle().get(context, "InternalFrameTitlePane.maxFrameIconSize");
            int maxWidth = 16;
            int maxHeight = 16;
            if (maxSize != null) {
                maxWidth = maxSize.width;
                maxHeight = maxSize.height;
            }
            this.menuButton.setIcon(new ImageIcon(frameIcon.getScaledInstance(maxWidth, maxHeight, 4)));
        }
        context.dispose();
    }

    private void addSubComponents() {
        this.menuButton.setName("InternalFrameTitlePane.menuButton");
        this.iconButton.setName("InternalFrameTitlePane.iconifyButton");
        this.maxButton.setName("InternalFrameTitlePane.maximizeButton");
        this.closeButton.setName("InternalFrameTitlePane.closeButton");
        this.add(this.menuButton);
        this.add(this.iconButton);
        this.add(this.maxButton);
        this.add(this.closeButton);
    }

    private void createActions() {
        this.maximizeAction = new MaximizeAction();
        this.iconifyAction = new IconifyAction();
        this.closeAction = new CloseAction();
        this.restoreAction = new RestoreAction();
        this.moveAction = new MoveAction();
        this.sizeAction = new SizeAction();
    }

    ActionMap createActionMap() {
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("showSystemMenu", new ShowSystemMenuAction(true));
        map.put("hideSystemMenu", new ShowSystemMenuAction(false));
        return map;
    }

    protected void installListeners() {
        this.addParentPropertyChangeListener(this);
    }

    protected void uninstallListeners() {
        this.removeParentPropertyChangeListener(this);
    }

    private void installDefaults() {
        this.setFont(UIManager.getFont("InternalFrame.titleFont"));
        this.closeButtonToolTip = UIManager.getString("InternalFrame.closeButtonToolTip");
        this.iconButtonToolTip = UIManager.getString("InternalFrame.iconButtonToolTip");
        this.restoreButtonToolTip = UIManager.getString("InternalFrame.restoreButtonToolTip");
        this.maxButtonToolTip = UIManager.getString("InternalFrame.maxButtonToolTip");
        this.updateStyle(this);
    }

    public void uninstallDefaults() {
        SeaGlassContext context = this.getContext(this, 1);
        this.style.uninstallDefaults(context);
        context.dispose();
        this.style = null;
    }

    private void updateStyle(JComponent c) {
        SeaGlassContext context = this.getContext(this, 1);
        SynthStyle oldStyle = this.style;
        this.style = SeaGlassLookAndFeel.updateSeaglassStyle(context, this);
        if (this.style != oldStyle) {
            this.titleSpacing = this.style.getInt(context, "InternalFrameTitlePane.titleSpacing", 2);
        }
        context.dispose();
    }

    private void createButtons() {
        this.iconButton = new NoFocusButton("InternalFrameTitlePane.iconifyButtonAccessibleName");
        this.iconButton.addActionListener(this.iconifyAction);
        if (this.iconButtonToolTip != null && this.iconButtonToolTip.length() != 0) {
            this.iconButton.setToolTipText(this.iconButtonToolTip);
        }
        this.maxButton = new NoFocusButton("InternalFrameTitlePane.maximizeButtonAccessibleName");
        this.maxButton.addActionListener(this.maximizeAction);
        this.closeButton = new NoFocusButton("InternalFrameTitlePane.closeButtonAccessibleName");
        this.closeButton.addActionListener(this.closeAction);
        if (this.closeButtonToolTip != null && this.closeButtonToolTip.length() != 0) {
            this.closeButton.setToolTipText(this.closeButtonToolTip);
        }
        this.setButtonTooltips();
    }

    private void setButtonTooltips() {
        if (this.isParentIcon()) {
            if (this.restoreButtonToolTip != null && this.restoreButtonToolTip.length() != 0) {
                this.iconButton.setToolTipText(this.restoreButtonToolTip);
            }
            if (this.maxButtonToolTip != null && this.maxButtonToolTip.length() != 0) {
                this.maxButton.setToolTipText(this.maxButtonToolTip);
            }
        } else if (this.isParentMaximum()) {
            if (this.iconButtonToolTip != null && this.iconButtonToolTip.length() != 0) {
                this.iconButton.setToolTipText(this.iconButtonToolTip);
            }
            if (this.restoreButtonToolTip != null && this.restoreButtonToolTip.length() != 0) {
                this.maxButton.setToolTipText(this.restoreButtonToolTip);
            }
        } else {
            if (this.iconButtonToolTip != null && this.iconButtonToolTip.length() != 0) {
                this.iconButton.setToolTipText(this.iconButtonToolTip);
            }
            if (this.maxButtonToolTip != null && this.maxButtonToolTip.length() != 0) {
                this.maxButton.setToolTipText(this.maxButtonToolTip);
            }
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        SeaGlassContext context = this.getContext(this);
        SeaGlassLookAndFeel.update(context, g);
        context.getPainter().paintInternalFrameTitlePaneBackground(context, g, 0, 0, this.getWidth(), this.getHeight());
        this.paint(context, g);
        context.dispose();
    }

    private void paint(SeaGlassContext context, Graphics g) {
        String title = this.getTitle();
        if (title != null) {
            int minX;
            int maxX;
            SynthStyle style = context.getStyle();
            Color color = style.getColor(context, ColorType.TEXT_FOREGROUND);
            if ((context.getComponentState() & 0x200) != 0) {
                Object obj = style.get(context, "[WindowFocused].textForeground");
                if (obj != null && obj instanceof Color) {
                    color = (Color)obj;
                }
                color = Color.BLACK;
            }
            g.setColor(color);
            g.setFont(style.getFont(context));
            FontMetrics fm = SwingUtilities2.getFontMetrics((JComponent)this.rootPane, g);
            int baseline = (this.getHeight() + fm.getAscent() - fm.getLeading() - fm.getDescent()) / 2;
            JButton lastButton = null;
            if (this.isParentIconifiable()) {
                lastButton = this.iconButton;
            } else if (this.isParentMaximizable()) {
                lastButton = this.maxButton;
            } else if (this.isParentClosable()) {
                lastButton = this.closeButton;
            }
            boolean ltr = this.isParentLeftToRight();
            if (ltr) {
                maxX = lastButton != null ? lastButton.getX() - this.titleSpacing : this.getParentWidth() - this.getParentInsets().right - this.titleSpacing;
                minX = this.menuButton.getX() + this.menuButton.getWidth() + this.titleSpacing;
            } else {
                minX = lastButton != null ? lastButton.getX() + lastButton.getWidth() + this.titleSpacing : this.getParentInsets().left + this.titleSpacing;
                maxX = this.getParentWidth() - this.getParentInsets().right - this.menuButton.getX() - this.titleSpacing;
            }
            String clippedTitle = this.getTitle(title, fm, maxX - minX);
            if (clippedTitle == title) {
                int width = style.getGraphicsUtils(context).computeStringWidth(context, g.getFont(), fm, title);
                minX = Math.max(minX, (this.getWidth() - width) / 2);
                minX = Math.min(maxX - width, minX);
            }
            ((SeaGlassGraphicsUtils)style.getGraphicsUtils(context)).drawEmphasizedText(g, color, this.DEFAULT_EMPHASIS_COLOR, clippedTitle, minX, baseline);
        }
    }

    private String getTitle() {
        if (this.rootParent instanceof JFrame) {
            return ((JFrame)this.rootParent).getTitle();
        }
        if (this.rootParent instanceof JDialog) {
            return ((JDialog)this.rootParent).getTitle();
        }
        return null;
    }

    private Insets getParentInsets() {
        if (this.rootParent instanceof JApplet) {
            return ((JApplet)this.rootParent).getInsets();
        }
        return ((Window)((Object)this.rootParent)).getInsets();
    }

    private int getParentWidth() {
        if (this.rootParent instanceof JApplet) {
            return ((JApplet)this.rootParent).getWidth();
        }
        return ((Window)((Object)this.rootParent)).getWidth();
    }

    private String getTitle(String text, FontMetrics fm, int availTextWidth) {
        return SwingUtilities2.clipStringIfNecessary(this.rootPane, fm, text, availTextWidth);
    }

    @Override
    public void paintBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        ((SeaGlassContext)context).getPainter().paintInternalFrameTitlePaneBorder(context, g, x, y, w, h);
    }

    private LayoutManager createLayout() {
        SeaGlassContext context = this.getContext(this);
        LayoutManager lm = (LayoutManager)this.style.get(context, "InternalFrameTitlePane.titlePaneLayout");
        context.dispose();
        return lm != null ? lm : new SeaGlassTitlePaneLayout();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this) {
            if (SeaGlassLookAndFeel.shouldUpdateStyle(evt)) {
                this.updateStyle(this);
            }
        } else if (evt.getPropertyName() == "iconImage") {
            this.updateMenuIcon();
        }
        String prop = evt.getPropertyName();
        if (this.closeButton != null && WINDOW_DOCUMENT_MODIFIED.equals(prop)) {
            this.closeButton.revalidate();
            this.closeButton.repaint();
            return;
        }
        if (prop == "selected") {
            this.repaint();
            return;
        }
        if ("resizable".equals(prop) || "state".equals(prop)) {
            JFrame frame = (JFrame)this.rootParent;
            if (frame != null) {
                this.setState(frame.getExtendedState(), true);
            }
            if ("resizable".equals(prop)) {
                this.getRootPane().repaint();
            }
        } else if ("title".equals(prop)) {
            this.repaint();
        } else if ("componentOrientation" == prop) {
            this.revalidate();
            this.repaint();
        } else if ("iconImage" == prop) {
            this.revalidate();
            this.repaint();
        }
        if (prop == "icon" || prop == "maximum") {
            this.setButtonTooltips();
            this.enableActions();
            return;
        }
        if ("closable" == prop) {
            if ((Boolean)evt.getNewValue() == Boolean.TRUE) {
                this.add(this.closeButton);
            } else {
                this.remove(this.closeButton);
            }
        } else if ("maximizable" == prop) {
            if ((Boolean)evt.getNewValue() == Boolean.TRUE) {
                this.add(this.maxButton);
            } else {
                this.remove(this.maxButton);
            }
        } else if ("iconable" == prop) {
            if ((Boolean)evt.getNewValue() == Boolean.TRUE) {
                this.add(this.iconButton);
            } else {
                this.remove(this.iconButton);
            }
        }
        this.enableActions();
        this.revalidate();
        this.repaint();
    }

    private void setState(int state, boolean updateRegardless) {
        Window w = (Window)((Object)this.rootParent);
        if (w != null && this.rootPane.getWindowDecorationStyle() == 1) {
            if (this.state == state && !updateRegardless) {
                return;
            }
            JFrame frame = (JFrame)this.rootParent;
            if (frame != null) {
                JRootPane rootPane = this.getRootPane();
                if ((state & 6) != 0 && (rootPane.getBorder() == null || rootPane.getBorder() instanceof UIResource) && frame.isShowing()) {
                    rootPane.setBorder(null);
                } else if ((state & 6) == 0) {
                    this.rootPaneUI.installBorder(rootPane);
                }
                if (frame.isResizable()) {
                    if ((state & 6) != 0) {
                        this.maximizeAction.setEnabled(false);
                        this.restoreAction.setEnabled(true);
                    } else {
                        this.maximizeAction.setEnabled(true);
                        this.restoreAction.setEnabled(false);
                    }
                } else {
                    this.maximizeAction.setEnabled(false);
                    this.restoreAction.setEnabled(false);
                }
            } else {
                this.maximizeAction.setEnabled(false);
                this.restoreAction.setEnabled(false);
                this.iconifyAction.setEnabled(false);
                this.revalidate();
                this.repaint();
            }
            this.closeAction.setEnabled(true);
            this.state = state;
        }
    }

    private void enableActions() {
        this.restoreAction.setEnabled(this.isParentMaximum() || this.isParentIcon());
        this.maximizeAction.setEnabled(this.isParentMaximizable() && !this.isParentMaximum() && !this.isParentIcon() || this.isParentMaximizable() && this.isParentIcon());
        this.iconifyAction.setEnabled(this.isParentIconifiable() && !this.isParentIcon());
        this.closeAction.setEnabled(this.isParentClosable());
        this.sizeAction.setEnabled(false);
        this.moveAction.setEnabled(false);
    }

    private class NoFocusButton
    extends JButton {
        private static final long serialVersionUID = 5958100825982240844L;
        private String uiKey;

        public NoFocusButton(String uiKey) {
            this.setFocusPainted(false);
            this.setMargin(new Insets(0, 0, 0, 0));
            this.setFocusable(false);
            this.uiKey = uiKey;
            this.setUI(SeaGlassButtonUI.createUI(this));
        }

        @Override
        public boolean isFocusTraversable() {
            return false;
        }

        @Override
        public void requestFocus() {
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            AccessibleContext ac = super.getAccessibleContext();
            if (this.uiKey != null) {
                ac.setAccessibleName(UIManager.getString(this.uiKey));
                this.uiKey = null;
            }
            return ac;
        }
    }

    private class SizeAction
    extends AbstractAction {
        private static final long serialVersionUID = 210508132565915886L;

        public SizeAction() {
            super(SIZE_CMD);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    private class ShowSystemMenuAction
    extends AbstractAction {
        private static final long serialVersionUID = 3363009814611622667L;
        private boolean show;

        public ShowSystemMenuAction(boolean show) {
            this.show = show;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.show) {
                SeaGlassTitlePane.this.showSystemMenu();
            }
        }
    }

    private class MoveAction
    extends AbstractAction {
        private static final long serialVersionUID = 5637413107648659924L;

        public MoveAction() {
            super(MOVE_CMD);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    private class RestoreAction
    extends AbstractAction {
        private static final long serialVersionUID = -1621305056572434154L;

        public RestoreAction() {
            super(RESTORE_CMD);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (SeaGlassTitlePane.this.isParentMaximizable() && SeaGlassTitlePane.this.isParentMaximum() && SeaGlassTitlePane.this.isParentIcon()) {
                SeaGlassTitlePane.this.setParentIcon(false);
            } else if (SeaGlassTitlePane.this.isParentMaximizable() && SeaGlassTitlePane.this.isParentMaximum()) {
                SeaGlassTitlePane.this.setParentMaximum(false);
            } else if (SeaGlassTitlePane.this.isParentIconifiable() && SeaGlassTitlePane.this.isParentIcon()) {
                SeaGlassTitlePane.this.setParentIcon(false);
            }
            SeaGlassTitlePane.this.setButtonTooltips();
        }
    }

    private class IconifyAction
    extends AbstractAction {
        private static final long serialVersionUID = -9131330678177895337L;

        public IconifyAction() {
            super(ICONIFY_CMD);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SeaGlassTitlePane.this.isParentIconifiable()) {
                if (!SeaGlassTitlePane.this.isParentIcon()) {
                    SeaGlassTitlePane.this.setParentIcon(true);
                } else {
                    SeaGlassTitlePane.this.setParentIcon(false);
                }
            }
            SeaGlassTitlePane.this.setButtonTooltips();
        }
    }

    private class MaximizeAction
    extends AbstractAction {
        private static final long serialVersionUID = -74832854369507690L;

        public MaximizeAction() {
            super(MAXIMIZE_CMD);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (SeaGlassTitlePane.this.isParentMaximizable()) {
                if (SeaGlassTitlePane.this.isParentMaximum() && SeaGlassTitlePane.this.isParentIcon()) {
                    SeaGlassTitlePane.this.setParentIcon(false);
                } else if (!SeaGlassTitlePane.this.isParentMaximum()) {
                    SeaGlassTitlePane.this.setParentMaximum(true);
                } else {
                    SeaGlassTitlePane.this.setParentMaximum(false);
                }
                SeaGlassTitlePane.this.setButtonTooltips();
            }
        }
    }

    private class CloseAction
    extends AbstractAction {
        private static final long serialVersionUID = 7476072734719417639L;

        public CloseAction() {
            super(CLOSE_CMD);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SeaGlassTitlePane.this.isParentClosable()) {
                SeaGlassTitlePane.this.doParentDefaultCloseAction();
            }
        }
    }

    class SeaGlassTitlePaneLayout
    implements LayoutManager {
        SeaGlassTitlePaneLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            return this.minimumLayoutSize(c);
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            int subtitle_w;
            int title_length;
            Dimension pref;
            SeaGlassContext context = SeaGlassTitlePane.this.getContext(SeaGlassTitlePane.this);
            int width = 10;
            int height = 25;
            int buttonCount = 0;
            if (SeaGlassTitlePane.this.isParentClosable()) {
                pref = SeaGlassTitlePane.this.closeButton.getPreferredSize();
                width += pref.width;
                height = Math.max(pref.height, height);
                ++buttonCount;
            }
            if (SeaGlassTitlePane.this.isParentMaximizable()) {
                pref = SeaGlassTitlePane.this.maxButton.getPreferredSize();
                width += pref.width;
                height = Math.max(pref.height, height);
                ++buttonCount;
            }
            if (SeaGlassTitlePane.this.isParentIconifiable()) {
                pref = SeaGlassTitlePane.this.iconButton.getPreferredSize();
                width += pref.width;
                height = Math.max(pref.height, height);
                ++buttonCount;
            }
            pref = SeaGlassTitlePane.this.menuButton.getPreferredSize();
            width += pref.width;
            height = Math.max(pref.height, height);
            FontMetrics fm = SeaGlassTitlePane.this.getFontMetrics(SeaGlassTitlePane.this.getFont());
            SynthGraphicsUtils graphicsUtils = context.getStyle().getGraphicsUtils(context);
            String frameTitle = SeaGlassTitlePane.this.getTitle();
            int title_w = frameTitle != null ? graphicsUtils.computeStringWidth(context, fm.getFont(), fm, frameTitle) : 0;
            int n = title_length = frameTitle != null ? frameTitle.length() : 0;
            width = title_length > 3 ? (width += title_w < (subtitle_w = graphicsUtils.computeStringWidth(context, fm.getFont(), fm, frameTitle.substring(0, 3) + "...")) ? title_w : subtitle_w) : (width += title_w);
            height = Math.max(fm.getHeight(), height);
            width += SeaGlassTitlePane.this.titleSpacing + SeaGlassTitlePane.this.titleSpacing;
            Insets insets = SeaGlassTitlePane.this.getInsets();
            context.dispose();
            return new Dimension(width += insets.left + insets.right, height += insets.top + insets.bottom);
        }

        private int center(Component c, Insets insets, int x, boolean trailing) {
            Dimension pref = c.getPreferredSize();
            int width = pref.width;
            if (c instanceof JButton && ((JButton)c).getIcon() != null) {
                width = ((JButton)c).getIcon().getIconWidth();
            }
            if (trailing) {
                x -= width;
            }
            int y = 1;
            c.setBounds(x, y, pref.width, pref.height);
            if (pref.width > 0 && !trailing) {
                return x + width;
            }
            return x;
        }

        @Override
        public void layoutContainer(Container c) {
            Insets insets = c.getInsets();
            if (SeaGlassTitlePane.this.isParentLeftToRight()) {
                this.center(SeaGlassTitlePane.this.menuButton, insets, insets.left + 4, false);
                int x = SeaGlassTitlePane.this.getWidth() - insets.right - 5;
                if (SeaGlassTitlePane.this.isParentClosable()) {
                    x = this.center(SeaGlassTitlePane.this.closeButton, insets, x, true);
                }
                if (SeaGlassTitlePane.this.isParentMaximizable()) {
                    x = this.center(SeaGlassTitlePane.this.maxButton, insets, x, true);
                }
                if (SeaGlassTitlePane.this.isParentIconifiable()) {
                    x = this.center(SeaGlassTitlePane.this.iconButton, insets, x, true);
                }
            } else {
                this.center(SeaGlassTitlePane.this.menuButton, insets, SeaGlassTitlePane.this.getWidth() - insets.right - 4, true);
                int x = insets.left + 5;
                if (SeaGlassTitlePane.this.isParentClosable()) {
                    x = this.center(SeaGlassTitlePane.this.closeButton, insets, x, false);
                }
                if (SeaGlassTitlePane.this.isParentMaximizable()) {
                    x = this.center(SeaGlassTitlePane.this.maxButton, insets, x, false);
                }
                if (SeaGlassTitlePane.this.isParentIconifiable()) {
                    int n = this.center(SeaGlassTitlePane.this.iconButton, insets, x, false);
                }
            }
        }
    }
}

