/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.component;

import com.seaglasslookandfeel.SeaGlassContext;
import com.seaglasslookandfeel.SeaGlassLookAndFeel;
import com.seaglasslookandfeel.component.SeaGlassArrowButton;
import com.seaglasslookandfeel.ui.SeaGlassSplitPaneUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.plaf.synth.Region;
import sun.swing.DefaultLookup;

public class SeaGlassSplitPaneDivider
extends BasicSplitPaneDivider {
    private static final long serialVersionUID = 5876267823818018895L;
    protected static final int ONE_TOUCH_SIZE = 6;
    protected static final int ONE_TOUCH_OFFSET = 2;
    private int oneTouchSize;
    private int oneTouchOffset;
    private boolean centerOneTouchButtons;
    int oneTouchVOffset;

    public SeaGlassSplitPaneDivider(BasicSplitPaneUI ui) {
        super(ui);
        this.oneTouchSize = DefaultLookup.getInt(ui.getSplitPane(), ui, "SplitPane.oneTouchButtonSize", 6);
        this.oneTouchOffset = DefaultLookup.getInt(ui.getSplitPane(), ui, "SplitPane.oneTouchButtonOffset", 2);
        this.centerOneTouchButtons = DefaultLookup.getBoolean(ui.getSplitPane(), ui, "SplitPane.centerOneTouchButtons", true);
        this.oneTouchVOffset = DefaultLookup.getInt(ui.getSplitPane(), ui, "SplitPane.oneTouchButtonVOffset", 0);
        this.setLayout(new DividerLayout());
    }

    @Override
    protected void setMouseOver(boolean mouseOver) {
        if (this.isMouseOver() != mouseOver) {
            this.repaint();
        }
        super.setMouseOver(mouseOver);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        if (e.getSource() == this.splitPane && e.getPropertyName() == "orientation") {
            if (this.leftButton instanceof SeaGlassArrowButton) {
                ((SeaGlassArrowButton)this.leftButton).setDirection(this.mapDirection(true));
            }
            if (this.rightButton instanceof SeaGlassArrowButton) {
                ((SeaGlassArrowButton)this.rightButton).setDirection(this.mapDirection(false));
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        Graphics g2 = g.create();
        SeaGlassContext context = ((SeaGlassSplitPaneUI)this.splitPaneUI).getContext((JComponent)this.splitPane, Region.SPLIT_PANE_DIVIDER);
        Rectangle bounds = this.getBounds();
        bounds.y = 0;
        bounds.x = 0;
        SeaGlassLookAndFeel.updateSubregion(context, g, bounds);
        context.getPainter().paintSplitPaneDividerBackground(context, g, 0, 0, bounds.width, bounds.height, this.splitPane.getOrientation());
        context.getPainter().paintSplitPaneDividerForeground(context, g, 0, 0, this.getWidth(), this.getHeight(), this.splitPane.getOrientation());
        context.dispose();
        for (int counter = 0; counter < this.getComponentCount(); ++counter) {
            Component child = this.getComponent(counter);
            Rectangle childBounds = child.getBounds();
            Graphics childG = g.create(childBounds.x, childBounds.y, childBounds.width, childBounds.height);
            child.paint(childG);
            childG.dispose();
        }
        g2.dispose();
    }

    private int mapDirection(boolean isLeft) {
        if (isLeft) {
            if (this.splitPane.getOrientation() == 1) {
                return 7;
            }
            return 1;
        }
        if (this.splitPane.getOrientation() == 1) {
            return 3;
        }
        return 5;
    }

    @Override
    protected JButton createLeftOneTouchButton() {
        SeaGlassArrowButton b = new SeaGlassArrowButton(1);
        int oneTouchSize = this.lookupOneTouchSize();
        b.setName("SplitPaneDivider.leftOneTouchButton");
        b.setMinimumSize(new Dimension(oneTouchSize, oneTouchSize));
        b.setCursor(Cursor.getPredefinedCursor(this.splitPane.getOrientation() == 1 ? 10 : 8));
        b.setFocusPainted(false);
        b.setBorderPainted(false);
        b.setRequestFocusEnabled(false);
        b.setDirection(this.mapDirection(true));
        return b;
    }

    private int lookupOneTouchSize() {
        return DefaultLookup.getInt(this.splitPaneUI.getSplitPane(), this.splitPaneUI, "SplitPaneDivider.oneTouchButtonSize", 6);
    }

    @Override
    protected JButton createRightOneTouchButton() {
        SeaGlassArrowButton b = new SeaGlassArrowButton(1);
        int oneTouchSize = this.lookupOneTouchSize();
        b.setName("SplitPaneDivider.rightOneTouchButton");
        b.setMinimumSize(new Dimension(oneTouchSize, oneTouchSize));
        b.setCursor(Cursor.getPredefinedCursor(this.splitPane.getOrientation() == 1 ? 11 : 9));
        b.setFocusPainted(false);
        b.setBorderPainted(false);
        b.setRequestFocusEnabled(false);
        b.setDirection(this.mapDirection(false));
        return b;
    }

    protected class DividerLayout
    implements LayoutManager {
        protected DividerLayout() {
        }

        @Override
        public void layoutContainer(Container c) {
            if (SeaGlassSplitPaneDivider.this.leftButton != null && SeaGlassSplitPaneDivider.this.rightButton != null && c == SeaGlassSplitPaneDivider.this) {
                if (SeaGlassSplitPaneDivider.this.splitPane.isOneTouchExpandable()) {
                    Insets insets = SeaGlassSplitPaneDivider.this.getInsets();
                    if (SeaGlassSplitPaneDivider.this.orientation == 0) {
                        int extraX = insets != null ? insets.left : 0;
                        int blockSize = SeaGlassSplitPaneDivider.this.getHeight();
                        if (insets != null) {
                            blockSize -= insets.top + insets.bottom;
                            blockSize = Math.max(blockSize, 0);
                        }
                        blockSize = Math.min(blockSize, SeaGlassSplitPaneDivider.this.oneTouchSize);
                        int y = (c.getSize().height - blockSize) / 2;
                        if (!SeaGlassSplitPaneDivider.this.centerOneTouchButtons) {
                            y = insets != null ? insets.top : 0;
                            extraX = 0;
                        }
                        SeaGlassSplitPaneDivider.this.leftButton.setBounds(extraX + SeaGlassSplitPaneDivider.this.oneTouchOffset, y - SeaGlassSplitPaneDivider.this.oneTouchVOffset, blockSize * 2, blockSize);
                        SeaGlassSplitPaneDivider.this.rightButton.setBounds(extraX + SeaGlassSplitPaneDivider.this.oneTouchOffset, y + SeaGlassSplitPaneDivider.this.oneTouchVOffset + 1, blockSize * 2, blockSize);
                    } else {
                        int extraY = insets != null ? insets.top : 0;
                        int blockSize = SeaGlassSplitPaneDivider.this.getWidth();
                        if (insets != null) {
                            blockSize -= insets.left + insets.right;
                            blockSize = Math.max(blockSize, 0);
                        }
                        blockSize = Math.min(blockSize, SeaGlassSplitPaneDivider.this.oneTouchSize);
                        int x = (c.getSize().width - blockSize) / 2;
                        if (!SeaGlassSplitPaneDivider.this.centerOneTouchButtons) {
                            x = insets != null ? insets.left : 0;
                            extraY = 0;
                        }
                        SeaGlassSplitPaneDivider.this.leftButton.setBounds(x - SeaGlassSplitPaneDivider.this.oneTouchVOffset, extraY + SeaGlassSplitPaneDivider.this.oneTouchOffset, blockSize, blockSize * 2);
                        SeaGlassSplitPaneDivider.this.rightButton.setBounds(x + SeaGlassSplitPaneDivider.this.oneTouchVOffset + 1, extraY + SeaGlassSplitPaneDivider.this.oneTouchOffset, blockSize, blockSize * 2);
                    }
                } else {
                    SeaGlassSplitPaneDivider.this.leftButton.setBounds(-5, -5, 1, 1);
                    SeaGlassSplitPaneDivider.this.rightButton.setBounds(-5, -5, 1, 1);
                }
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            int width;
            if (c != SeaGlassSplitPaneDivider.this || SeaGlassSplitPaneDivider.this.splitPane == null) {
                return new Dimension(0, 0);
            }
            Dimension buttonMinSize = null;
            if (SeaGlassSplitPaneDivider.this.splitPane.isOneTouchExpandable() && SeaGlassSplitPaneDivider.this.leftButton != null) {
                buttonMinSize = SeaGlassSplitPaneDivider.this.leftButton.getMinimumSize();
            }
            Insets insets = SeaGlassSplitPaneDivider.this.getInsets();
            int height = width = SeaGlassSplitPaneDivider.this.getDividerSize();
            if (SeaGlassSplitPaneDivider.this.orientation == 0) {
                if (buttonMinSize != null) {
                    int size = buttonMinSize.height;
                    if (insets != null) {
                        size += insets.top + insets.bottom;
                    }
                    height = Math.max(height, size);
                }
                width = 1;
            } else {
                if (buttonMinSize != null) {
                    int size = buttonMinSize.width;
                    if (insets != null) {
                        size += insets.left + insets.right;
                    }
                    width = Math.max(width, size);
                }
                height = 1;
            }
            return new Dimension(width, height);
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            return this.minimumLayoutSize(c);
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public void addLayoutComponent(String string, Component c) {
        }
    }
}

