/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.component;

import com.seaglasslookandfeel.SeaGlassContext;
import com.seaglasslookandfeel.SeaGlassLookAndFeel;
import com.seaglasslookandfeel.ui.SeaglassUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.event.InternalFrameEvent;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthGraphicsUtils;
import javax.swing.plaf.synth.SynthStyle;
import sun.swing.SwingUtilities2;

public class SeaGlassInternalFrameTitlePane
extends JComponent
implements SeaglassUI,
PropertyChangeListener {
    private static final long serialVersionUID = 6852740789566412690L;
    private static final String CLOSE_CMD = UIManager.getString("InternalFrameTitlePane.closeButtonText");
    private static final String ICONIFY_CMD = UIManager.getString("InternalFrameTitlePane.minimizeButtonText");
    private static final String RESTORE_CMD = UIManager.getString("InternalFrameTitlePane.restoreButtonText");
    private static final String MAXIMIZE_CMD = UIManager.getString("InternalFrameTitlePane.maximizeButtonText");
    private static final String MOVE_CMD = UIManager.getString("InternalFrameTitlePane.moveButtonText");
    private static final String SIZE_CMD = UIManager.getString("InternalFrameTitlePane.sizeButtonText");
    private JButton iconButton;
    private JButton maxButton;
    private JButton closeButton;
    private JMenu windowMenu;
    private JInternalFrame frame;
    private Action closeAction;
    private Action maximizeAction;
    private Action iconifyAction;
    private Action restoreAction;
    private Action moveAction;
    private Action sizeAction;
    private String closeButtonToolTip;
    private String iconButtonToolTip;
    private String restoreButtonToolTip;
    private String maxButtonToolTip;
    private JPopupMenu systemPopupMenu;
    private JButton menuButton;
    private SynthStyle style;
    private int titleSpacing;

    public SeaGlassInternalFrameTitlePane(JInternalFrame f) {
        this.frame = f;
        this.installTitlePane();
    }

    @Override
    public String getUIClassID() {
        return "InternalFrameTitlePaneUI";
    }

    @Override
    public SeaGlassContext getContext(JComponent c) {
        return this.getContext(c, this.getComponentState(c));
    }

    public SeaGlassContext getContext(JComponent c, int state) {
        return SeaGlassContext.getContext(SeaGlassContext.class, c, SeaGlassLookAndFeel.getRegion(c), this.style, state);
    }

    private int getComponentState(JComponent c) {
        if (this.frame != null && this.frame.isSelected()) {
            return 512;
        }
        return SeaGlassLookAndFeel.getComponentState(c);
    }

    private void installTitlePane() {
        this.installDefaults();
        this.installListeners();
        this.createActions();
        this.enableActions();
        this.createActionMap();
        this.setLayout(this.createLayout());
        this.assembleSystemMenu();
        this.createButtons();
        this.addSubComponents();
    }

    private void addSubComponents() {
        this.menuButton.setName("InternalFrameTitlePane.menuButton");
        this.iconButton.setName("InternalFrameTitlePane.iconifyButton");
        this.maxButton.setName("InternalFrameTitlePane.maximizeButton");
        this.closeButton.setName("InternalFrameTitlePane.closeButton");
        this.add(this.menuButton);
        this.add(this.iconButton);
        this.add(this.maxButton);
        this.add(this.closeButton);
    }

    private void createActions() {
        this.maximizeAction = new MaximizeAction();
        this.iconifyAction = new IconifyAction();
        this.closeAction = new CloseAction();
        this.restoreAction = new RestoreAction();
        this.moveAction = new MoveAction();
        this.sizeAction = new SizeAction();
    }

    ActionMap createActionMap() {
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("showSystemMenu", new ShowSystemMenuAction(true));
        map.put("hideSystemMenu", new ShowSystemMenuAction(false));
        return map;
    }

    protected void installListeners() {
        this.frame.addPropertyChangeListener(this);
        this.addPropertyChangeListener(this);
    }

    protected void uninstallListeners() {
        this.frame.removePropertyChangeListener(this);
        this.removePropertyChangeListener(this);
    }

    private void installDefaults() {
        this.setFont(UIManager.getFont("InternalFrame.titleFont"));
        this.closeButtonToolTip = UIManager.getString("InternalFrame.closeButtonToolTip");
        this.iconButtonToolTip = UIManager.getString("InternalFrame.iconButtonToolTip");
        this.restoreButtonToolTip = UIManager.getString("InternalFrame.restoreButtonToolTip");
        this.maxButtonToolTip = UIManager.getString("InternalFrame.maxButtonToolTip");
        this.updateStyle(this);
    }

    public void uninstallDefaults() {
        SeaGlassContext context = this.getContext(this, 1);
        this.style.uninstallDefaults(context);
        context.dispose();
        this.style = null;
        JInternalFrame.JDesktopIcon di = this.frame.getDesktopIcon();
        if (di != null && di.getComponentPopupMenu() == this.systemPopupMenu) {
            di.setComponentPopupMenu(null);
        }
    }

    private void updateStyle(JComponent c) {
        SeaGlassContext context = this.getContext(this, 1);
        SynthStyle oldStyle = this.style;
        this.style = SeaGlassLookAndFeel.updateStyle(context, this);
        if (this.style != oldStyle) {
            this.titleSpacing = this.style.getInt(context, "InternalFrameTitlePane.titleSpacing", 2);
        }
        context.dispose();
    }

    private void createButtons() {
        this.iconButton = new NoFocusButton("InternalFrameTitlePane.iconifyButtonAccessibleName");
        this.iconButton.addActionListener(this.iconifyAction);
        if (this.iconButtonToolTip != null && this.iconButtonToolTip.length() != 0) {
            this.iconButton.setToolTipText(this.iconButtonToolTip);
        }
        this.maxButton = new NoFocusButton("InternalFrameTitlePane.maximizeButtonAccessibleName");
        this.maxButton.addActionListener(this.maximizeAction);
        this.closeButton = new NoFocusButton("InternalFrameTitlePane.closeButtonAccessibleName");
        this.closeButton.addActionListener(this.closeAction);
        if (this.closeButtonToolTip != null && this.closeButtonToolTip.length() != 0) {
            this.closeButton.setToolTipText(this.closeButtonToolTip);
        }
        this.setButtonTooltips();
    }

    private void setButtonTooltips() {
        if (this.frame.isIcon()) {
            if (this.restoreButtonToolTip != null && this.restoreButtonToolTip.length() != 0) {
                this.iconButton.setToolTipText(this.restoreButtonToolTip);
            }
            if (this.maxButtonToolTip != null && this.maxButtonToolTip.length() != 0) {
                this.maxButton.setToolTipText(this.maxButtonToolTip);
            }
        } else if (this.frame.isMaximum()) {
            if (this.iconButtonToolTip != null && this.iconButtonToolTip.length() != 0) {
                this.iconButton.setToolTipText(this.iconButtonToolTip);
            }
            if (this.restoreButtonToolTip != null && this.restoreButtonToolTip.length() != 0) {
                this.maxButton.setToolTipText(this.restoreButtonToolTip);
            }
        } else {
            if (this.iconButtonToolTip != null && this.iconButtonToolTip.length() != 0) {
                this.iconButton.setToolTipText(this.iconButtonToolTip);
            }
            if (this.maxButtonToolTip != null && this.maxButtonToolTip.length() != 0) {
                this.maxButton.setToolTipText(this.maxButtonToolTip);
            }
        }
    }

    private void assembleSystemMenu() {
        this.systemPopupMenu = new JPopupMenuUIResource();
        this.addSystemMenuItems(this.systemPopupMenu);
        this.enableActions();
        this.menuButton = new NoFocusButton("InternalFrameTitlePane.menuButtonAccessibleName");
        this.updateMenuIcon();
        this.menuButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                try {
                    SeaGlassInternalFrameTitlePane.this.frame.setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                SeaGlassInternalFrameTitlePane.this.showSystemMenu();
            }
        });
        JPopupMenu p = this.frame.getComponentPopupMenu();
        if (p == null || p instanceof UIResource) {
            this.frame.setComponentPopupMenu(this.systemPopupMenu);
        }
        if (this.frame.getDesktopIcon() != null && ((p = this.frame.getDesktopIcon().getComponentPopupMenu()) == null || p instanceof UIResource)) {
            this.frame.getDesktopIcon().setComponentPopupMenu(this.systemPopupMenu);
        }
        this.setInheritsPopupMenu(true);
    }

    private void addSystemMenuItems(JPopupMenu menu) {
        JMenuItem mi = menu.add(this.restoreAction);
        mi.setMnemonic('R');
        mi = menu.add(this.moveAction);
        mi.setMnemonic('M');
        mi = menu.add(this.sizeAction);
        mi.setMnemonic('S');
        mi = menu.add(this.iconifyAction);
        mi.setMnemonic('n');
        mi = menu.add(this.maximizeAction);
        mi.setMnemonic('x');
        menu.add(new JSeparator());
        mi = menu.add(this.closeAction);
        mi.setMnemonic('C');
    }

    private void showSystemMenu() {
        Insets insets = this.frame.getInsets();
        if (!this.frame.isIcon()) {
            this.systemPopupMenu.show(this.frame, insets.left, this.getY() + this.getHeight());
        } else {
            this.systemPopupMenu.show(this.menuButton, this.getX() - insets.left - insets.right, this.getY() - this.systemPopupMenu.getPreferredSize().height - insets.bottom - insets.top);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        SeaGlassContext context = this.getContext(this);
        SeaGlassLookAndFeel.update(context, g);
        context.getPainter().paintInternalFrameTitlePaneBackground(context, g, 0, 0, this.getWidth(), this.getHeight());
        this.paint(context, g);
        context.dispose();
    }

    private void paint(SeaGlassContext context, Graphics g) {
        String title = this.frame.getTitle();
        if (title != null) {
            int minX;
            int maxX;
            SynthStyle style = context.getStyle();
            Color color = style.getColor(context, ColorType.TEXT_FOREGROUND);
            if ((context.getComponentState() & 0x200) != 0) {
                Object obj = style.get(context, "[WindowFocused].textForeground");
                if (obj != null && obj instanceof Color) {
                    color = (Color)obj;
                }
                color = Color.WHITE;
            }
            g.setColor(color);
            g.setFont(style.getFont(context));
            FontMetrics fm = SwingUtilities2.getFontMetrics((JComponent)this.frame, g);
            int baseline = (this.getHeight() + fm.getAscent() - fm.getLeading() - fm.getDescent()) / 2;
            JButton lastButton = null;
            if (this.frame.isIconifiable()) {
                lastButton = this.iconButton;
            } else if (this.frame.isMaximizable()) {
                lastButton = this.maxButton;
            } else if (this.frame.isClosable()) {
                lastButton = this.closeButton;
            }
            boolean ltr = SeaGlassLookAndFeel.isLeftToRight(this.frame);
            if (ltr) {
                maxX = lastButton != null ? lastButton.getX() - this.titleSpacing : this.frame.getWidth() - this.frame.getInsets().right - this.titleSpacing;
                minX = this.menuButton.getX() + this.menuButton.getWidth() + this.titleSpacing;
            } else {
                minX = lastButton != null ? lastButton.getX() + lastButton.getWidth() + this.titleSpacing : this.frame.getInsets().left + this.titleSpacing;
                maxX = this.menuButton.getX() - this.titleSpacing;
            }
            String clippedTitle = this.getTitle(title, fm, maxX - minX);
            if (clippedTitle == title) {
                int width = style.getGraphicsUtils(context).computeStringWidth(context, g.getFont(), fm, title);
                minX = Math.max(minX, (this.getWidth() - width) / 2);
                minX = Math.min(maxX - width, minX);
            }
            style.getGraphicsUtils(context).paintText(context, g, clippedTitle, minX, baseline - fm.getAscent(), -1);
        }
    }

    private String getTitle(String text, FontMetrics fm, int availTextWidth) {
        return SwingUtilities2.clipStringIfNecessary(this.frame, fm, text, availTextWidth);
    }

    @Override
    public void paintBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        ((SeaGlassContext)context).getPainter().paintInternalFrameTitlePaneBorder(context, g, x, y, w, h);
    }

    private LayoutManager createLayout() {
        SeaGlassContext context = this.getContext(this);
        LayoutManager lm = (LayoutManager)this.style.get(context, "InternalFrameTitlePane.titlePaneLayout");
        context.dispose();
        return lm != null ? lm : new SeaGlassTitlePaneLayout();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String prop;
        if (evt.getSource() == this) {
            if (SeaGlassLookAndFeel.shouldUpdateStyle(evt)) {
                this.updateStyle(this);
            }
        } else if (evt.getPropertyName() == "frameIcon") {
            this.updateMenuIcon();
        }
        if ((prop = evt.getPropertyName()) == "selected") {
            this.repaint();
            return;
        }
        if (prop == "icon" || prop == "maximum") {
            this.setButtonTooltips();
            this.enableActions();
            return;
        }
        if ("closable" == prop) {
            if ((Boolean)evt.getNewValue() == Boolean.TRUE) {
                this.add(this.closeButton);
            } else {
                this.remove(this.closeButton);
            }
        } else if ("maximizable" == prop) {
            if ((Boolean)evt.getNewValue() == Boolean.TRUE) {
                this.add(this.maxButton);
            } else {
                this.remove(this.maxButton);
            }
        } else if ("iconable" == prop) {
            if ((Boolean)evt.getNewValue() == Boolean.TRUE) {
                this.add(this.iconButton);
            } else {
                this.remove(this.iconButton);
            }
        }
        this.enableActions();
        this.revalidate();
        this.repaint();
    }

    private void updateMenuIcon() {
        Icon frameIcon = this.frame.getFrameIcon();
        SeaGlassContext context = this.getContext(this);
        if (frameIcon != null) {
            Dimension maxSize = (Dimension)context.getStyle().get(context, "InternalFrameTitlePane.maxFrameIconSize");
            int maxWidth = 16;
            int maxHeight = 16;
            if (maxSize != null) {
                maxWidth = maxSize.width;
                maxHeight = maxSize.height;
            }
            if ((frameIcon.getIconWidth() > maxWidth || frameIcon.getIconHeight() > maxHeight) && frameIcon instanceof ImageIcon) {
                frameIcon = new ImageIcon(((ImageIcon)frameIcon).getImage().getScaledInstance(maxWidth, maxHeight, 4));
            }
        }
        context.dispose();
        this.menuButton.setIcon(frameIcon);
    }

    protected void postClosingEvent(JInternalFrame frame) {
        InternalFrameEvent e = new InternalFrameEvent(frame, 25550);
        if (JInternalFrame.class.getClassLoader() == null) {
            try {
                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(e);
                return;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        frame.dispatchEvent(e);
    }

    private void enableActions() {
        this.restoreAction.setEnabled(this.frame.isMaximum() || this.frame.isIcon());
        this.maximizeAction.setEnabled(this.frame.isMaximizable() && !this.frame.isMaximum() && !this.frame.isIcon() || this.frame.isMaximizable() && this.frame.isIcon());
        this.iconifyAction.setEnabled(this.frame.isIconifiable() && !this.frame.isIcon());
        this.closeAction.setEnabled(this.frame.isClosable());
        this.sizeAction.setEnabled(false);
        this.moveAction.setEnabled(false);
    }

    private class NoFocusButton
    extends JButton {
        private static final long serialVersionUID = 797986964401472674L;
        private String uiKey;

        public NoFocusButton(String uiKey) {
            this.setFocusPainted(false);
            this.setMargin(new Insets(0, 0, 0, 0));
            this.setFocusable(false);
            this.uiKey = uiKey;
        }

        @Override
        public boolean isFocusTraversable() {
            return false;
        }

        @Override
        public void requestFocus() {
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            AccessibleContext ac = super.getAccessibleContext();
            if (this.uiKey != null) {
                ac.setAccessibleName(UIManager.getString(this.uiKey));
                this.uiKey = null;
            }
            return ac;
        }
    }

    private class SizeAction
    extends AbstractAction {
        private static final long serialVersionUID = -1079290485715681580L;

        public SizeAction() {
            super(SIZE_CMD);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    private class ShowSystemMenuAction
    extends AbstractAction {
        private static final long serialVersionUID = 4020962135221310152L;
        private boolean show;

        public ShowSystemMenuAction(boolean show) {
            this.show = show;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.show) {
                SeaGlassInternalFrameTitlePane.this.windowMenu.doClick();
            } else {
                SeaGlassInternalFrameTitlePane.this.windowMenu.setVisible(false);
            }
        }
    }

    private class MoveAction
    extends AbstractAction {
        private static final long serialVersionUID = 7940900832761279111L;

        public MoveAction() {
            super(MOVE_CMD);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    private class RestoreAction
    extends AbstractAction {
        private static final long serialVersionUID = -961768442993544104L;

        public RestoreAction() {
            super(RESTORE_CMD);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (SeaGlassInternalFrameTitlePane.this.frame.isMaximizable() && SeaGlassInternalFrameTitlePane.this.frame.isMaximum() && SeaGlassInternalFrameTitlePane.this.frame.isIcon()) {
                try {
                    SeaGlassInternalFrameTitlePane.this.frame.setIcon(false);
                }
                catch (PropertyVetoException e) {}
            } else if (SeaGlassInternalFrameTitlePane.this.frame.isMaximizable() && SeaGlassInternalFrameTitlePane.this.frame.isMaximum()) {
                try {
                    SeaGlassInternalFrameTitlePane.this.frame.setMaximum(false);
                }
                catch (PropertyVetoException e) {}
            } else if (SeaGlassInternalFrameTitlePane.this.frame.isIconifiable() && SeaGlassInternalFrameTitlePane.this.frame.isIcon()) {
                try {
                    SeaGlassInternalFrameTitlePane.this.frame.setIcon(false);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }
    }

    private class IconifyAction
    extends AbstractAction {
        private static final long serialVersionUID = 4337075125371606258L;

        public IconifyAction() {
            super(ICONIFY_CMD);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SeaGlassInternalFrameTitlePane.this.frame.isIconifiable()) {
                if (!SeaGlassInternalFrameTitlePane.this.frame.isIcon()) {
                    try {
                        SeaGlassInternalFrameTitlePane.this.frame.setIcon(true);
                    }
                    catch (PropertyVetoException e1) {}
                } else {
                    try {
                        SeaGlassInternalFrameTitlePane.this.frame.setIcon(false);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private class MaximizeAction
    extends AbstractAction {
        private static final long serialVersionUID = 6286449065315966825L;

        public MaximizeAction() {
            super(MAXIMIZE_CMD);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (SeaGlassInternalFrameTitlePane.this.frame.isMaximizable()) {
                if (SeaGlassInternalFrameTitlePane.this.frame.isMaximum() && SeaGlassInternalFrameTitlePane.this.frame.isIcon()) {
                    try {
                        SeaGlassInternalFrameTitlePane.this.frame.setIcon(false);
                    }
                    catch (PropertyVetoException e) {}
                } else if (!SeaGlassInternalFrameTitlePane.this.frame.isMaximum()) {
                    try {
                        SeaGlassInternalFrameTitlePane.this.frame.setMaximum(true);
                    }
                    catch (PropertyVetoException e) {}
                } else {
                    try {
                        SeaGlassInternalFrameTitlePane.this.frame.setMaximum(false);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private class CloseAction
    extends AbstractAction {
        private static final long serialVersionUID = 1214165629626107441L;

        public CloseAction() {
            super(CLOSE_CMD);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SeaGlassInternalFrameTitlePane.this.frame.isClosable()) {
                SeaGlassInternalFrameTitlePane.this.frame.doDefaultCloseAction();
            }
        }
    }

    class SeaGlassTitlePaneLayout
    implements LayoutManager {
        SeaGlassTitlePaneLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            return this.minimumLayoutSize(c);
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            int subtitle_w;
            int title_length;
            Dimension pref;
            SeaGlassContext context = SeaGlassInternalFrameTitlePane.this.getContext(SeaGlassInternalFrameTitlePane.this);
            int width = 8;
            int height = 0;
            int buttonCount = 0;
            if (SeaGlassInternalFrameTitlePane.this.frame.isClosable()) {
                pref = SeaGlassInternalFrameTitlePane.this.closeButton.getPreferredSize();
                width += pref.width;
                height = Math.max(pref.height, height);
                ++buttonCount;
            }
            if (SeaGlassInternalFrameTitlePane.this.frame.isMaximizable()) {
                pref = SeaGlassInternalFrameTitlePane.this.maxButton.getPreferredSize();
                width += pref.width;
                height = Math.max(pref.height, height);
                ++buttonCount;
            }
            if (SeaGlassInternalFrameTitlePane.this.frame.isIconifiable()) {
                pref = SeaGlassInternalFrameTitlePane.this.iconButton.getPreferredSize();
                width += pref.width;
                height = Math.max(pref.height, height);
                ++buttonCount;
            }
            pref = SeaGlassInternalFrameTitlePane.this.menuButton.getPreferredSize();
            width += pref.width;
            height = Math.max(pref.height, height);
            FontMetrics fm = SeaGlassInternalFrameTitlePane.this.getFontMetrics(SeaGlassInternalFrameTitlePane.this.getFont());
            SynthGraphicsUtils graphicsUtils = context.getStyle().getGraphicsUtils(context);
            String frameTitle = SeaGlassInternalFrameTitlePane.this.frame.getTitle();
            int title_w = frameTitle != null ? graphicsUtils.computeStringWidth(context, fm.getFont(), fm, frameTitle) : 0;
            int n = title_length = frameTitle != null ? frameTitle.length() : 0;
            width = title_length > 3 ? (width += title_w < (subtitle_w = graphicsUtils.computeStringWidth(context, fm.getFont(), fm, frameTitle.substring(0, 3) + "...")) ? title_w : subtitle_w) : (width += title_w);
            height = Math.max(fm.getHeight() + 2, height);
            width += SeaGlassInternalFrameTitlePane.this.titleSpacing + SeaGlassInternalFrameTitlePane.this.titleSpacing;
            Insets insets = SeaGlassInternalFrameTitlePane.this.getInsets();
            context.dispose();
            return new Dimension(width += insets.left + insets.right, height += insets.top + insets.bottom);
        }

        private int center(Component c, Insets insets, int x, boolean trailing) {
            Dimension pref = c.getPreferredSize();
            int width = pref.width;
            if (c instanceof JButton && ((JButton)c).getIcon() != null) {
                width = ((JButton)c).getIcon().getIconWidth();
            }
            if (trailing) {
                x -= width;
            }
            int y = 0;
            if (c == SeaGlassInternalFrameTitlePane.this.menuButton) {
                // empty if block
            }
            c.setBounds(x, y, pref.width, pref.height);
            if (pref.width > 0 && !trailing) {
                return x + width;
            }
            return x;
        }

        @Override
        public void layoutContainer(Container c) {
            Insets insets = c.getInsets();
            if (SeaGlassLookAndFeel.isLeftToRight(SeaGlassInternalFrameTitlePane.this.frame)) {
                this.center(SeaGlassInternalFrameTitlePane.this.menuButton, insets, insets.left + 4, false);
                int x = SeaGlassInternalFrameTitlePane.this.getWidth() - insets.right - 4;
                if (SeaGlassInternalFrameTitlePane.this.frame.isClosable()) {
                    x = this.center(SeaGlassInternalFrameTitlePane.this.closeButton, insets, x, true);
                }
                if (SeaGlassInternalFrameTitlePane.this.frame.isMaximizable()) {
                    x = this.center(SeaGlassInternalFrameTitlePane.this.maxButton, insets, x, true);
                }
                if (SeaGlassInternalFrameTitlePane.this.frame.isIconifiable()) {
                    x = this.center(SeaGlassInternalFrameTitlePane.this.iconButton, insets, x, true);
                }
            } else {
                this.center(SeaGlassInternalFrameTitlePane.this.menuButton, insets, SeaGlassInternalFrameTitlePane.this.getWidth() - insets.right - 4, true);
                int x = insets.left + 4;
                if (SeaGlassInternalFrameTitlePane.this.frame.isClosable()) {
                    x = this.center(SeaGlassInternalFrameTitlePane.this.closeButton, insets, x, false);
                }
                if (SeaGlassInternalFrameTitlePane.this.frame.isMaximizable()) {
                    x = this.center(SeaGlassInternalFrameTitlePane.this.maxButton, insets, x, false);
                }
                if (SeaGlassInternalFrameTitlePane.this.frame.isIconifiable()) {
                    int n = this.center(SeaGlassInternalFrameTitlePane.this.iconButton, insets, x, false);
                }
            }
        }
    }

    private static class JPopupMenuUIResource
    extends JPopupMenu
    implements UIResource {
        private static final long serialVersionUID = 4511298062453723303L;

        private JPopupMenuUIResource() {
        }
    }
}

