/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.component;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.plaf.basic.BasicComboPopup;

public class SeaGlassComboPopup
extends BasicComboPopup {
    private static final long serialVersionUID = -2424496840321170560L;
    private static final int LEFT_SHIFT = 5;
    private Color BORDER_COLOR = UIManager.getColor("seaGlassPopupBorder");
    private Border LIST_BORDER = new LineBorder(this.BORDER_COLOR, 1);

    public SeaGlassComboPopup(JComboBox combo) {
        super(combo);
    }

    @Override
    public void updateUI() {
        super.updateUI();
    }

    private boolean isDropDown() {
        return this.comboBox.isEditable() || this.hasScrollBars();
    }

    private boolean hasScrollBars() {
        return this.comboBox.getModel().getSize() > this.getMaximumRowCount();
    }

    private boolean isEditable() {
        return this.comboBox.isEditable();
    }

    @Override
    protected void configureList() {
        this.list.setFont(this.comboBox.getFont());
        this.list.setBorder(null);
        this.list.setCellRenderer(this.comboBox.getRenderer());
        this.list.setFocusable(false);
        this.list.setSelectionMode(0);
        int selectedIndex = this.comboBox.getSelectedIndex();
        if (selectedIndex == -1) {
            this.list.clearSelection();
        } else {
            this.list.setSelectedIndex(selectedIndex);
            this.list.ensureIndexIsVisible(selectedIndex);
        }
        this.installListListeners();
    }

    @Override
    protected void configurePopup() {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorderPainted(true);
        this.setBorder(this.LIST_BORDER);
        this.setOpaque(false);
        this.add(this.scroller);
        this.setDoubleBuffered(true);
        this.setFocusable(false);
    }

    @Override
    protected Rectangle computePopupBounds(int px, int py, int pw, int ph) {
        Rectangle screenBounds;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        int listWidth = this.getList().getPreferredSize().width;
        Insets margin = this.comboBox.getInsets();
        if (this.hasScrollBars()) {
            px += margin.left;
            pw = Math.max(pw - margin.left - margin.right, listWidth + 16);
        } else {
            px += margin.left;
            pw = Math.max(pw - 5 - margin.left, listWidth);
        }
        GraphicsConfiguration gc = this.comboBox.getGraphicsConfiguration();
        Point p = new Point();
        SwingUtilities.convertPointFromScreen(p, this.comboBox);
        if (gc == null) {
            screenBounds = new Rectangle(p, toolkit.getScreenSize());
        } else {
            Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(gc);
            screenBounds = new Rectangle(gc.getBounds());
            screenBounds.width -= screenInsets.left + screenInsets.right;
            screenBounds.height -= screenInsets.top + screenInsets.bottom;
            screenBounds.x += screenInsets.left;
            screenBounds.y += screenInsets.top;
        }
        if (this.isDropDown()) {
            py = this.isEditable() ? (py -= margin.bottom + 2) : (py -= margin.bottom);
        } else {
            int yOffset = -margin.top;
            int selectedIndex = this.comboBox.getSelectedIndex();
            py = selectedIndex <= 0 ? -yOffset : -yOffset - this.list.getCellBounds((int)0, (int)(selectedIndex - 1)).height;
        }
        Rectangle rect = new Rectangle(px, Math.max(py, p.y + screenBounds.y), Math.min(screenBounds.width, pw), Math.min(screenBounds.height - 40, ph));
        if (rect.height < ph) {
            rect.width += 16;
        }
        return rect;
    }

    private void setListSelection(int selectedIndex) {
        if (selectedIndex == -1) {
            this.list.clearSelection();
        } else {
            this.list.setSelectedIndex(selectedIndex);
            this.list.ensureIndexIsVisible(selectedIndex);
        }
    }

    @Override
    public void show() {
        this.setListSelection(this.comboBox.getSelectedIndex());
        Point location = this.getPopupLocation();
        this.show(this.comboBox, location.x, location.y);
        this.list.repaint();
    }

    private int getMaximumRowCount() {
        return this.comboBox.getMaximumRowCount();
    }

    private Point getPopupLocation() {
        Dimension popupSize = this.comboBox.getSize();
        Insets insets = this.getInsets();
        popupSize.setSize(popupSize.width - (insets.right + insets.left), this.getPopupHeightForRowCount(this.getMaximumRowCount()));
        Rectangle popupBounds = this.computePopupBounds(0, this.comboBox.getBounds().height, popupSize.width, popupSize.height);
        Dimension scrollSize = popupBounds.getSize();
        Point popupLocation = popupBounds.getLocation();
        this.scroller.setMaximumSize(scrollSize);
        this.scroller.setPreferredSize(scrollSize);
        this.scroller.setMinimumSize(scrollSize);
        this.list.revalidate();
        return popupLocation;
    }
}

