/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.component;

import com.seaglasslookandfeel.SeaGlassContext;
import com.seaglasslookandfeel.SeaGlassLookAndFeel;
import com.seaglasslookandfeel.SeaGlassStyle;
import com.seaglasslookandfeel.ui.SeaglassUI;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JToolBar;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.Region;
import javax.swing.text.JTextComponent;

public class SeaGlassBorder
extends AbstractBorder
implements UIResource {
    private static final long serialVersionUID = 2565840147056359672L;
    private SeaglassUI ui;
    private Insets insets;

    public SeaGlassBorder(SeaglassUI ui, Insets insets) {
        this.ui = ui;
        this.insets = insets;
    }

    public SeaGlassBorder(SeaglassUI ui) {
        this(ui, null);
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        JComponent jc = (JComponent)c;
        SeaGlassContext context = (SeaGlassContext)this.ui.getContext(jc);
        SeaGlassStyle style = (SeaGlassStyle)context.getStyle();
        if (style == null) {
            assert (false) : "SeaGlassBorder is being used outside after the UI has been uninstalled";
            return;
        }
        this.ui.paintBorder(context, g, x, y, width, height);
        context.dispose();
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.getBorderInsets(c, null);
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        if (this.insets != null) {
            if (insets == null) {
                insets = new Insets(this.insets.top, this.insets.left, this.insets.bottom, this.insets.right);
            } else {
                insets.top = this.insets.top;
                insets.bottom = this.insets.bottom;
                insets.left = this.insets.left;
                insets.right = this.insets.right;
            }
        } else if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        } else {
            insets.right = 0;
            insets.left = 0;
            insets.bottom = 0;
            insets.top = 0;
        }
        if (c instanceof JComponent) {
            Insets margin = null;
            Region region = SeaGlassLookAndFeel.getRegion((JComponent)c);
            if ((region == Region.ARROW_BUTTON || region == Region.BUTTON || region == Region.CHECK_BOX || region == Region.CHECK_BOX_MENU_ITEM || region == Region.MENU || region == Region.MENU_ITEM || region == Region.RADIO_BUTTON || region == Region.RADIO_BUTTON_MENU_ITEM || region == Region.TOGGLE_BUTTON) && c instanceof AbstractButton) {
                margin = ((AbstractButton)c).getMargin();
            } else if ((region == Region.EDITOR_PANE || region == Region.FORMATTED_TEXT_FIELD || region == Region.PASSWORD_FIELD || region == Region.TEXT_AREA || region == Region.TEXT_FIELD || region == Region.TEXT_PANE) && c instanceof JTextComponent) {
                margin = ((JTextComponent)c).getMargin();
            } else if (region == Region.TOOL_BAR && c instanceof JToolBar) {
                margin = ((JToolBar)c).getMargin();
            } else if (region == Region.MENU_BAR && c instanceof JMenuBar) {
                margin = ((JMenuBar)c).getMargin();
            }
            if (margin != null) {
                insets.top += margin.top;
                insets.bottom += margin.bottom;
                insets.left += margin.left;
                insets.right += margin.right;
            }
        }
        return insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }
}

