/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel.component;

import com.seaglasslookandfeel.SeaGlassContext;
import com.seaglasslookandfeel.SeaGlassStyle;
import com.seaglasslookandfeel.ui.SeaGlassButtonUI;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.plaf.UIResource;

public class SeaGlassArrowButton
extends JButton
implements SwingConstants,
UIResource {
    private static final long serialVersionUID = 2673388860074501956L;
    private int direction;

    public SeaGlassArrowButton(int direction) {
        super.setFocusable(false);
        this.setDirection(direction);
        this.setDefaultCapable(false);
    }

    @Override
    public String getUIClassID() {
        return "ArrowButtonUI";
    }

    @Override
    public void updateUI() {
        this.setUI(new SeaGlassArrowButtonUI());
    }

    public void setDirection(int dir) {
        this.direction = dir;
        this.putClientProperty("__arrow_direction__", new Integer(dir));
        this.repaint();
    }

    public int getDirection() {
        return this.direction;
    }

    @Override
    public void setFocusable(boolean focusable) {
    }

    private static class SeaGlassArrowButtonUI
    extends SeaGlassButtonUI {
        private SeaGlassArrowButtonUI() {
        }

        @Override
        protected void installDefaults(AbstractButton b) {
            super.installDefaults(b);
            this.updateStyle(b);
        }

        @Override
        protected void paint(SeaGlassContext context, Graphics g) {
            SeaGlassArrowButton button = (SeaGlassArrowButton)context.getComponent();
            Double scale = (Double)button.getClientProperty("__arrow_scale__");
            if (scale == null) {
                scale = 1.0;
            }
            int width = (int)((double)button.getWidth() * scale);
            int height = (int)((double)button.getHeight() * scale);
            int x = (button.getWidth() - width) / 2 * (button.getDirection() == 3 ? -1 : 1);
            int y = (button.getHeight() - height) / 2 * (button.getDirection() == 5 ? -1 : 1);
            context.getPainter().paintArrowButtonForeground(context, g, x, y, width, height, button.getDirection());
        }

        void paintBackground(SeaGlassContext context, Graphics g, JComponent c) {
            context.getPainter().paintArrowButtonBackground(context, g, 0, 0, c.getWidth(), c.getHeight());
        }

        public void paintBorder(SeaGlassContext context, Graphics g, int x, int y, int w, int h) {
            context.getPainter().paintArrowButtonBorder(context, g, x, y, w, h);
        }

        public Dimension getMinimumSize() {
            return new Dimension(5, 5);
        }

        public Dimension getMaximumSize() {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        @Override
        public Dimension getPreferredSize(JComponent c) {
            String scaleKey;
            JComponent parent;
            SeaGlassContext context = this.getContext(c);
            Dimension dim = null;
            if (context.getComponent().getName() == "ScrollBar.button") {
                dim = (Dimension)context.getStyle().get(context, "ScrollBar.buttonSize");
            }
            if (dim == null) {
                int size = context.getStyle().getInt(context, "ArrowButton.size", 16);
                dim = new Dimension(size, size);
            }
            if ((parent = (JComponent)context.getComponent().getParent()) != null && !(parent instanceof JComboBox) && (scaleKey = SeaGlassStyle.getSizeVariant(parent)) != null) {
                if ("large".equals(scaleKey)) {
                    dim = new Dimension((int)((double)dim.width * 1.15), (int)((double)dim.height * 1.15));
                } else if ("small".equals(scaleKey)) {
                    dim = new Dimension((int)((double)dim.width * 0.857), (int)((double)dim.height * 0.857));
                } else if ("mini".equals(scaleKey)) {
                    dim = new Dimension((int)((double)dim.width * 0.714), (int)((double)dim.height * 0.714));
                }
            }
            context.dispose();
            return dim;
        }
    }
}

