/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel;

import com.seaglasslookandfeel.SeaGlassContext;
import com.seaglasslookandfeel.SeaGlassStyle;
import com.seaglasslookandfeel.SeaGlassSynthPainterImpl;
import com.seaglasslookandfeel.component.SeaGlassBorder;
import com.seaglasslookandfeel.painter.SeaGlassPainter;
import com.seaglasslookandfeel.ui.SeaglassUI;
import com.seaglasslookandfeel.util.SeaGlassGraphicsUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthGraphicsUtils;
import javax.swing.plaf.synth.SynthPainter;
import javax.swing.plaf.synth.SynthStyle;

public final class SeaGlassStyleWrapper
extends SeaGlassStyle {
    private static final SynthGraphicsUtils SEAGLASS_GRAPHICS = new SeaGlassGraphicsUtils();
    private SynthPainter painter;
    private SynthStyle style;

    SeaGlassStyleWrapper(SynthStyle style) {
        super(null, null);
        this.style = style;
        this.painter = new SeaGlassSynthPainterImpl(this);
    }

    @Override
    public SynthGraphicsUtils getGraphicsUtils(SynthContext context) {
        return SEAGLASS_GRAPHICS;
    }

    @Override
    public void installDefaults(SeaGlassContext context, SeaglassUI ui) {
        JComponent c;
        Border border;
        if (!context.isSubregion() && ((border = (c = context.getComponent()).getBorder()) == null || border instanceof UIResource)) {
            c.setBorder(new SeaGlassBorder(ui, this.getInsets(context, null)));
        }
        this.installDefaults(context);
    }

    @Override
    public void installDefaults(SynthContext ctx) {
        this.style.installDefaults(ctx);
    }

    @Override
    public Insets getInsets(SynthContext ctx, Insets in) {
        return this.style.getInsets(ctx, in);
    }

    @Override
    public Color getColorForState(SynthContext ctx, ColorType type) {
        return this.style.getColor(ctx, type);
    }

    @Override
    protected Font getFontForState(SynthContext ctx) {
        String scaleKey;
        Font f = (Font)this.get(ctx, "font");
        if (f == null) {
            f = UIManager.getFont("defaultFont");
        }
        if ((scaleKey = SeaGlassStyle.getSizeVariant(ctx.getComponent())) != null) {
            if ("large".equals(scaleKey)) {
                f = f.deriveFont(Math.round((double)f.getSize2D() * 1.15));
            } else if ("small".equals(scaleKey)) {
                f = f.deriveFont(Math.round((double)f.getSize2D() * 0.857));
            } else if ("mini".equals(scaleKey)) {
                f = f.deriveFont(Math.round((double)f.getSize2D() * 0.714));
            }
        }
        return f;
    }

    @Override
    public SynthPainter getPainter(SynthContext ctx) {
        return this.painter;
    }

    @Override
    public boolean isOpaque(SynthContext ctx) {
        return this.style.isOpaque(ctx);
    }

    @Override
    public Object get(SynthContext ctx, Object key) {
        return this.style.get(ctx, key);
    }

    @Override
    public SeaGlassPainter getBackgroundPainter(SynthContext ctx) {
        if (!(this.style instanceof SeaGlassStyle)) {
            return null;
        }
        return new PainterWrapper(((SeaGlassStyle)this.style).getBackgroundPainter(ctx));
    }

    @Override
    public SeaGlassPainter getForegroundPainter(SynthContext ctx) {
        if (!(this.style instanceof SeaGlassStyle)) {
            return null;
        }
        return new PainterWrapper(((SeaGlassStyle)this.style).getForegroundPainter(ctx));
    }

    @Override
    public SeaGlassPainter getBorderPainter(SynthContext ctx) {
        if (!(this.style instanceof SeaGlassStyle)) {
            return null;
        }
        return new PainterWrapper(((SeaGlassStyle)this.style).getBorderPainter(ctx));
    }

    public class PainterWrapper
    implements SeaGlassPainter {
        private SeaGlassPainter<Object> painter;

        public PainterWrapper(SeaGlassPainter<Object> painter) {
            this.painter = painter;
        }

        @Override
        public void paint(Graphics2D g, Object object, int width, int height) {
            this.painter.paint(g, object, width, height);
        }
    }
}

