/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel;

import com.seaglasslookandfeel.SeaGlassStyle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthPainter;
import javax.swing.plaf.synth.SynthStyle;

public class SeaGlassContext
extends SynthContext {
    private static final SynthPainter EMPTY_PAINTER = new SynthPainter(){};
    private static final JButton FAKE_BUTTON;
    private static final JButton fakeComponent;
    private static Region fakeRegion;
    private static SynthStyle fakeStyle;
    private static final Map contextMap;
    private JComponent component;
    private Region region;
    private SynthStyle style;
    private int state;

    public SeaGlassContext() {
        super(fakeComponent, fakeRegion, fakeStyle, 0);
    }

    public SeaGlassContext(JComponent component, Region region, SynthStyle style, int state) {
        super(component, region, style, state);
        if (component == fakeComponent) {
            this.component = null;
            this.region = null;
            this.style = null;
            return;
        }
        if (component == null || region == null || style == null) {
            throw new NullPointerException("You must supply a non-null component, region and style");
        }
        this.reset(component, region, style, state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SeaGlassContext getContext(Class type, JComponent component, Region region, SynthStyle style, int state) {
        SeaGlassContext context = null;
        Map map = contextMap;
        synchronized (map) {
            int size;
            List instances = (List)contextMap.get(type);
            if (instances != null && (size = instances.size()) > 0) {
                context = (SeaGlassContext)instances.remove(size - 1);
            }
        }
        if (context == null) {
            try {
                context = (SeaGlassContext)type.newInstance();
            }
            catch (IllegalAccessException iae) {
                iae.printStackTrace();
            }
            catch (InstantiationException ie) {
                ie.printStackTrace();
            }
        }
        context.reset(component, region, style, state);
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void releaseContext(SeaGlassContext context) {
        Map map = contextMap;
        synchronized (map) {
            ArrayList<SeaGlassContext> instances = (ArrayList<SeaGlassContext>)contextMap.get(context.getClass());
            if (instances == null) {
                instances = new ArrayList<SeaGlassContext>(5);
                contextMap.put(context.getClass(), instances);
            }
            instances.add(context);
        }
    }

    @Override
    public JComponent getComponent() {
        return this.component;
    }

    @Override
    public Region getRegion() {
        return this.region;
    }

    public boolean isSubregion() {
        return this.getRegion().isSubregion();
    }

    public void setStyle(SynthStyle style) {
        this.style = style;
    }

    @Override
    public SynthStyle getStyle() {
        return this.style;
    }

    public void setComponentState(int state) {
        this.state = state;
    }

    @Override
    public int getComponentState() {
        return this.state;
    }

    public void reset(JComponent component, Region region, SynthStyle style, int state) {
        this.component = component;
        this.region = region;
        this.style = style;
        this.state = state;
    }

    public void dispose() {
        this.component = null;
        this.style = null;
        SeaGlassContext.releaseContext(this);
    }

    public SynthPainter getPainter() {
        SynthPainter painter = this.getStyle().getPainter(this);
        if (painter != null) {
            return painter;
        }
        return EMPTY_PAINTER;
    }

    static {
        fakeComponent = FAKE_BUTTON = new JButton(){

            @Override
            public void updateUI() {
            }
        };
        fakeRegion = Region.BUTTON;
        fakeStyle = new SeaGlassStyle(null, null);
        contextMap = new HashMap();
    }
}

