/*
 * Decompiled with CFR 0.152.
 */
package com.seaglasslookandfeel;

import java.awt.Font;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public class DerivedFont
implements UIDefaults.ActiveValue {
    private float sizeOffset;
    private Boolean bold;
    private Boolean italic;
    private String parentKey;

    public DerivedFont(String key, float sizeOffset, Boolean bold, Boolean italic) {
        if (key == null) {
            throw new IllegalArgumentException("You must specify a key");
        }
        this.parentKey = key;
        this.sizeOffset = sizeOffset;
        this.bold = bold;
        this.italic = italic;
    }

    @Override
    public Object createValue(UIDefaults defaults) {
        Font f = UIManager.getFont(this.parentKey);
        if (f != null) {
            float size = Math.round(f.getSize2D() * this.sizeOffset);
            int style = f.getStyle();
            if (this.bold != null) {
                style = this.bold.booleanValue() ? (style |= 1) : (style &= 0xFFFFFFFE);
            }
            if (this.italic != null) {
                style = this.italic.booleanValue() ? (style |= 2) : (style &= 0xFFFFFFFD);
            }
            return f.deriveFont(style, size);
        }
        return null;
    }
}

