/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.pdf.PRStream;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfImportedPage;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfReaderInstance;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.ListIterator;

public class PdfLister {
    PrintStream out;

    public PdfLister(PrintStream printStream) {
        this.out = printStream;
    }

    public void listAnyObject(PdfObject pdfObject) {
        switch (pdfObject.type()) {
            case 5: {
                this.listArray((PdfArray)pdfObject);
                break;
            }
            case 6: {
                this.listDict((PdfDictionary)pdfObject);
                break;
            }
            case 3: {
                this.out.println("(" + pdfObject.toString() + ")");
                break;
            }
            default: {
                this.out.println(pdfObject.toString());
            }
        }
    }

    public void listDict(PdfDictionary pdfDictionary) {
        this.out.println("<<");
        Iterator iterator = pdfDictionary.getKeys().iterator();
        while (iterator.hasNext()) {
            PdfName pdfName = (PdfName)iterator.next();
            PdfObject pdfObject = pdfDictionary.get(pdfName);
            this.out.print(pdfName.toString());
            this.out.print(' ');
            this.listAnyObject(pdfObject);
        }
        this.out.println(">>");
    }

    public void listArray(PdfArray pdfArray) {
        this.out.println('[');
        ListIterator listIterator = pdfArray.listIterator();
        while (listIterator.hasNext()) {
            PdfObject pdfObject = (PdfObject)listIterator.next();
            this.listAnyObject(pdfObject);
        }
        this.out.println(']');
    }

    public void listStream(PRStream pRStream, PdfReaderInstance pdfReaderInstance) {
        try {
            this.listDict(pRStream);
            this.out.println("startstream");
            byte[] byArray = PdfReader.getStreamBytes(pRStream);
            int n = byArray.length - 1;
            for (int i = 0; i < n; ++i) {
                if (byArray[i] != 13 || byArray[i + 1] == 10) continue;
                byArray[i] = 10;
            }
            this.out.println(new String(byArray));
            this.out.println("endstream");
        }
        catch (IOException iOException) {
            System.err.println("I/O exception: " + iOException);
        }
    }

    public void listPage(PdfImportedPage pdfImportedPage) {
        int n = pdfImportedPage.getPageNumber();
        PdfReaderInstance pdfReaderInstance = pdfImportedPage.getPdfReaderInstance();
        PdfReader pdfReader = pdfReaderInstance.getReader();
        PdfDictionary pdfDictionary = pdfReader.getPageN(n);
        this.listDict(pdfDictionary);
        PdfObject pdfObject = PdfReader.getPdfObject(pdfDictionary.get(PdfName.CONTENTS));
        if (pdfObject == null) {
            return;
        }
        switch (pdfObject.type) {
            case 7: {
                this.listStream((PRStream)pdfObject, pdfReaderInstance);
                break;
            }
            case 5: {
                ListIterator listIterator = ((PdfArray)pdfObject).listIterator();
                while (listIterator.hasNext()) {
                    PdfObject pdfObject2 = PdfReader.getPdfObject((PdfObject)listIterator.next());
                    this.listStream((PRStream)pdfObject2, pdfReaderInstance);
                    this.out.println("-----------");
                }
                break;
            }
        }
    }
}

