/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.DocumentException;
import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.pdf.AcroFields;
import com.itextpdf.text.pdf.IntHashtable;
import com.itextpdf.text.pdf.PdfCopyFieldsImp;
import com.itextpdf.text.pdf.PdfReader;
import java.io.OutputStream;
import java.util.HashMap;

class PdfCopyFormsImp
extends PdfCopyFieldsImp {
    PdfCopyFormsImp(OutputStream outputStream) throws DocumentException {
        super(outputStream);
    }

    public void copyDocumentFields(PdfReader pdfReader) throws DocumentException {
        if (!pdfReader.isOpenedWithFullPermissions()) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("pdfreader.not.opened.with.owner.password"));
        }
        if (this.readers2intrefs.containsKey(pdfReader)) {
            pdfReader = new PdfReader(pdfReader);
        } else {
            if (pdfReader.isTampered()) {
                throw new DocumentException(MessageLocalization.getComposedMessage("the.document.was.reused"));
            }
            pdfReader.consolidateNamedDestinations();
            pdfReader.setTampered(true);
        }
        pdfReader.shuffleSubsetNames();
        this.readers2intrefs.put(pdfReader, new IntHashtable());
        this.fields.add(pdfReader.getAcroFields());
        this.updateCalculationOrder(pdfReader);
    }

    void mergeFields() {
        for (int i = 0; i < this.fields.size(); ++i) {
            HashMap hashMap = ((AcroFields)this.fields.get(i)).getFields();
            this.mergeWithMaster(hashMap);
        }
    }
}

