/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfString;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;

public class FdfReader
extends PdfReader {
    HashMap fields;
    String fileSpec;
    PdfName encoding;

    public FdfReader(String string) throws IOException {
        super(string);
    }

    public FdfReader(byte[] byArray) throws IOException {
        super(byArray);
    }

    public FdfReader(URL uRL) throws IOException {
        super(uRL);
    }

    public FdfReader(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readPdf() throws IOException {
        this.fields = new HashMap();
        try {
            this.tokens.checkFdfHeader();
            this.rebuildXref();
            this.readDocObj();
        }
        finally {
            try {
                this.tokens.close();
            }
            catch (Exception exception) {}
        }
        this.readFields();
    }

    protected void kidNode(PdfDictionary pdfDictionary, String string) {
        PdfArray pdfArray = pdfDictionary.getAsArray(PdfName.KIDS);
        if (pdfArray == null || pdfArray.isEmpty()) {
            if (string.length() > 0) {
                string = string.substring(1);
            }
            this.fields.put(string, pdfDictionary);
        } else {
            pdfDictionary.remove(PdfName.KIDS);
            for (int i = 0; i < pdfArray.size(); ++i) {
                PdfDictionary pdfDictionary2 = new PdfDictionary();
                pdfDictionary2.merge(pdfDictionary);
                PdfDictionary pdfDictionary3 = pdfArray.getAsDict(i);
                PdfString pdfString = pdfDictionary3.getAsString(PdfName.T);
                String string2 = string;
                if (pdfString != null) {
                    string2 = string2 + "." + pdfString.toUnicodeString();
                }
                pdfDictionary2.merge(pdfDictionary3);
                pdfDictionary2.remove(PdfName.T);
                this.kidNode(pdfDictionary2, string2);
            }
        }
    }

    protected void readFields() {
        PdfArray pdfArray;
        this.catalog = this.trailer.getAsDict(PdfName.ROOT);
        PdfDictionary pdfDictionary = this.catalog.getAsDict(PdfName.FDF);
        if (pdfDictionary == null) {
            return;
        }
        PdfString pdfString = pdfDictionary.getAsString(PdfName.F);
        if (pdfString != null) {
            this.fileSpec = pdfString.toUnicodeString();
        }
        if ((pdfArray = pdfDictionary.getAsArray(PdfName.FIELDS)) == null) {
            return;
        }
        this.encoding = pdfDictionary.getAsName(PdfName.ENCODING);
        PdfDictionary pdfDictionary2 = new PdfDictionary();
        pdfDictionary2.put(PdfName.KIDS, pdfArray);
        this.kidNode(pdfDictionary2, "");
    }

    public HashMap getFields() {
        return this.fields;
    }

    public PdfDictionary getField(String string) {
        return (PdfDictionary)this.fields.get(string);
    }

    public String getFieldValue(String string) {
        PdfDictionary pdfDictionary = (PdfDictionary)this.fields.get(string);
        if (pdfDictionary == null) {
            return null;
        }
        PdfObject pdfObject = FdfReader.getPdfObject(pdfDictionary.get(PdfName.V));
        if (pdfObject == null) {
            return null;
        }
        if (pdfObject.isName()) {
            return PdfName.decodeName(((PdfName)pdfObject).toString());
        }
        if (pdfObject.isString()) {
            PdfString pdfString = (PdfString)pdfObject;
            if (this.encoding == null || pdfString.getEncoding() != null) {
                return pdfString.toUnicodeString();
            }
            byte[] byArray = pdfString.getBytes();
            if (byArray.length >= 2 && byArray[0] == -2 && byArray[1] == -1) {
                return pdfString.toUnicodeString();
            }
            try {
                if (this.encoding.equals(PdfName.SHIFT_JIS)) {
                    return new String(byArray, "SJIS");
                }
                if (this.encoding.equals(PdfName.UHC)) {
                    return new String(byArray, "MS949");
                }
                if (this.encoding.equals(PdfName.GBK)) {
                    return new String(byArray, "GBK");
                }
                if (this.encoding.equals(PdfName.BIGFIVE)) {
                    return new String(byArray, "Big5");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return pdfString.toUnicodeString();
        }
        return null;
    }

    public String getFileSpec() {
        return this.fileSpec;
    }
}

