/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.error_messages;

import com.itextpdf.text.pdf.BaseFont;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;

public final class MessageLocalization {
    private static HashMap defaultLanguage = new HashMap();
    private static HashMap currentLanguage;
    private static final String BASE_PATH = "com.itextpdf/text/error_messages/";

    private MessageLocalization() {
    }

    public static String getMessage(String string) {
        String string2;
        HashMap hashMap = currentLanguage;
        if (hashMap != null && (string2 = (String)hashMap.get(string)) != null) {
            return string2;
        }
        hashMap = defaultLanguage;
        string2 = (String)hashMap.get(string);
        if (string2 != null) {
            return string2;
        }
        return "No message found for " + string;
    }

    public static String getComposedMessage(String string) {
        return MessageLocalization.getComposedMessage(string, null, null, null, null);
    }

    public static String getComposedMessage(String string, Object object) {
        return MessageLocalization.getComposedMessage(string, object, null, null, null);
    }

    public static String getComposedMessage(String string, int n) {
        return MessageLocalization.getComposedMessage(string, String.valueOf(n), null, null, null);
    }

    public static String getComposedMessage(String string, Object object, Object object2) {
        return MessageLocalization.getComposedMessage(string, object, object2, null, null);
    }

    public static String getComposedMessage(String string, Object object, Object object2, Object object3) {
        return MessageLocalization.getComposedMessage(string, object, object2, object3, null);
    }

    public static String getComposedMessage(String string, Object object, Object object2, Object object3, Object object4) {
        String string2 = MessageLocalization.getMessage(string);
        if (object != null) {
            string2 = string2.replaceAll("\\{1\\}", object.toString());
        }
        if (object2 != null) {
            string2 = string2.replaceAll("\\{2\\}", object2.toString());
        }
        if (object3 != null) {
            string2 = string2.replaceAll("\\{3\\}", object3.toString());
        }
        if (object4 != null) {
            string2 = string2.replaceAll("\\{4\\}", object4.toString());
        }
        return string2;
    }

    public static boolean setLanguage(String string, String string2) throws IOException {
        HashMap hashMap = MessageLocalization.getLanguageMessages(string, string2);
        if (hashMap == null) {
            return false;
        }
        currentLanguage = hashMap;
        return true;
    }

    public static void setMessages(Reader reader) throws IOException {
        currentLanguage = MessageLocalization.readLanguageStream(reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static HashMap getLanguageMessages(String string, String string2) throws IOException {
        if (string == null) {
            throw new IllegalArgumentException("The language cannot be null.");
        }
        InputStream inputStream = null;
        try {
            String string3 = string2 != null ? string + "_" + string2 + ".lng" : string + ".lng";
            inputStream = BaseFont.getResourceStream(BASE_PATH + string3, new MessageLocalization().getClass().getClassLoader());
            if (inputStream != null) {
                HashMap hashMap = MessageLocalization.readLanguageStream(inputStream);
                return hashMap;
            }
            if (string2 == null) {
                HashMap hashMap = null;
                return hashMap;
            }
            string3 = string + ".lng";
            inputStream = BaseFont.getResourceStream(BASE_PATH + string3, new MessageLocalization().getClass().getClassLoader());
            if (inputStream != null) {
                HashMap hashMap = MessageLocalization.readLanguageStream(inputStream);
                return hashMap;
            }
            HashMap hashMap = null;
            return hashMap;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    private static HashMap readLanguageStream(InputStream inputStream) throws IOException {
        return MessageLocalization.readLanguageStream(new InputStreamReader(inputStream, "UTF-8"));
    }

    private static HashMap readLanguageStream(Reader reader) throws IOException {
        String string;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        BufferedReader bufferedReader = new BufferedReader(reader);
        while ((string = bufferedReader.readLine()) != null) {
            String string2;
            int n = string.indexOf(61);
            if (n < 0 || (string2 = string.substring(0, n).trim()).startsWith("#")) continue;
            hashMap.put(string2, string.substring(n + 1));
        }
        return hashMap;
    }

    static {
        try {
            defaultLanguage = MessageLocalization.getLanguageMessages("en", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (defaultLanguage == null) {
            defaultLanguage = new HashMap();
        }
    }
}

