/*
 * Decompiled with CFR 0.152.
 */
package org.python.icu.text;

import org.python.icu.text.Replaceable;
import org.python.icu.text.Transliterator;
import org.python.icu.text.UnicodeReplacer;
import org.python.icu.text.UnicodeSet;

class FunctionReplacer
implements UnicodeReplacer {
    private Transliterator translit;
    private UnicodeReplacer replacer;

    public FunctionReplacer(Transliterator theTranslit, UnicodeReplacer theReplacer) {
        this.translit = theTranslit;
        this.replacer = theReplacer;
    }

    public int replace(Replaceable text2, int start, int limit, int[] cursor) {
        int len = this.replacer.replace(text2, start, limit, cursor);
        limit = start + len;
        limit = this.translit.transliterate(text2, start, limit);
        return limit - start;
    }

    public String toReplacerPattern(boolean escapeUnprintable) {
        StringBuilder rule = new StringBuilder("&");
        rule.append(this.translit.getID());
        rule.append("( ");
        rule.append(this.replacer.toReplacerPattern(escapeUnprintable));
        rule.append(" )");
        return rule.toString();
    }

    public void addReplacementSetTo(UnicodeSet toUnionTo) {
        toUnionTo.addAll(this.translit.getTargetSet());
    }
}

