/*
 * Decompiled with CFR 0.152.
 */
package syntaxhighlight;

import java.awt.Color;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class Style
implements Cloneable {
    protected boolean changed = true;
    protected SimpleAttributeSet attributeSet = null;
    protected boolean bold = false;
    protected Color color = Color.black;
    protected Color background = null;
    protected boolean underline = false;
    protected boolean italic = false;

    public SimpleAttributeSet getAttributeSet() {
        if (this.changed) {
            this.attributeSet = new SimpleAttributeSet();
            StyleConstants.setBold(this.attributeSet, this.bold);
            StyleConstants.setForeground(this.attributeSet, this.color);
            if (this.background != null) {
                StyleConstants.setBackground(this.attributeSet, this.background);
            }
            StyleConstants.setUnderline(this.attributeSet, this.underline);
            StyleConstants.setItalic(this.attributeSet, this.italic);
            this.changed = false;
        }
        return this.attributeSet;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color background) {
        this.changed = true;
        this.background = background;
    }

    public boolean isBold() {
        return this.bold;
    }

    public void setBold(boolean bold) {
        this.changed = true;
        this.bold = bold;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new NullPointerException("argument 'color' cannot be null");
        }
        this.changed = true;
        this.color = color;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public void setItalic(boolean italic) {
        this.changed = true;
        this.italic = italic;
    }

    public boolean isUnderline() {
        return this.underline;
    }

    public void setUnderline(boolean underline) {
        this.changed = true;
        this.underline = underline;
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + (this.bold ? 1 : 0);
        hash = 97 * hash + (this.color != null ? this.color.hashCode() : 0);
        hash = 97 * hash + (this.background != null ? this.background.hashCode() : 0);
        hash = 97 * hash + (this.underline ? 1 : 0);
        hash = 97 * hash + (this.italic ? 1 : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Style)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Style _object = (Style)obj;
        return _object.bold == this.bold && _object.color.equals(this.color) && _object.background.equals(this.background) && _object.underline == this.underline && _object.italic == this.italic;
    }

    public Style clone() {
        Style object = null;
        try {
            object = (Style)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return object;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append(this.getClass().getName());
        sb.append(": ");
        sb.append("bold: ").append(this.bold);
        sb.append(", ");
        sb.append("color: ").append(this.color);
        sb.append(", ");
        sb.append("background: ").append(this.background);
        sb.append(", ");
        sb.append("underline: ").append(this.underline);
        sb.append(", ");
        sb.append("italic: ").append(this.italic);
        sb.append("]");
        return sb.toString();
    }
}

