/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.parser.client.eval.dfp;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.math3.dfp.Dfp;
import org.apache.commons.math3.dfp.DfpField;
import org.apache.commons.math3.dfp.DfpMath;
import org.matheclipse.parser.client.Parser;
import org.matheclipse.parser.client.SyntaxError;
import org.matheclipse.parser.client.ast.ASTNode;
import org.matheclipse.parser.client.ast.FractionNode;
import org.matheclipse.parser.client.ast.FunctionNode;
import org.matheclipse.parser.client.ast.IntegerNode;
import org.matheclipse.parser.client.ast.NumberNode;
import org.matheclipse.parser.client.ast.SymbolNode;
import org.matheclipse.parser.client.eval.BooleanVariable;
import org.matheclipse.parser.client.eval.IBooleanBoolean1Function;
import org.matheclipse.parser.client.eval.IBooleanBoolean2Function;
import org.matheclipse.parser.client.eval.dfp.DfpNode;
import org.matheclipse.parser.client.eval.dfp.DfpVariable;
import org.matheclipse.parser.client.eval.dfp.IBooleanDfp2Function;
import org.matheclipse.parser.client.eval.dfp.IDfp0Function;
import org.matheclipse.parser.client.eval.dfp.IDfp1Function;
import org.matheclipse.parser.client.eval.dfp.IDfp2Function;
import org.matheclipse.parser.client.eval.dfp.IDfpCallbackFunction;
import org.matheclipse.parser.client.eval.dfp.IDfpFunction;
import org.matheclipse.parser.client.eval.dfp.IDfpValue;
import org.matheclipse.parser.client.math.ArithmeticMathException;
import org.matheclipse.parser.client.operator.ASTNodeFactory;

public class DfpEvaluator {
    private static final boolean DEBUG = false;
    private Map<String, Dfp> SYMBOL_DFP_MAP;
    private static Map<String, Boolean> SYMBOL_BOOLEAN_MAP;
    private static Map<String, Object> FUNCTION_DFP_MAP;
    private static Map<String, Object> FUNCTION_BOOLEAN_MAP;
    private IDfpCallbackFunction fCallbackFunction = null;
    private Map<String, IDfpValue> fVariableMap;
    private Map<String, BooleanVariable> fBooleanVariables;
    private final DfpField fDfpField;
    private final DfpNode fZERO;
    private ASTNode fNode;
    private final boolean fRelaxedSyntax;
    private final ASTNodeFactory fASTFactory;

    public IDfpCallbackFunction getCallbackFunction() {
        return this.fCallbackFunction;
    }

    public void setCallbackFunction(IDfpCallbackFunction callbackFunction) {
        this.fCallbackFunction = callbackFunction;
    }

    void init() {
        this.SYMBOL_DFP_MAP = new ConcurrentHashMap<String, Dfp>();
        this.SYMBOL_DFP_MAP.put("Catalan", this.fDfpField.newDfp(0.915965594177219));
        this.SYMBOL_DFP_MAP.put("Degree", this.fDfpField.newDfp(Math.PI / 180));
        this.SYMBOL_DFP_MAP.put("E", this.fDfpField.getE());
        this.SYMBOL_DFP_MAP.put("Pi", this.fDfpField.getPi());
        this.SYMBOL_DFP_MAP.put("EulerGamma", this.fDfpField.newDfp(0.5772156649015329));
        this.SYMBOL_DFP_MAP.put("Glaisher", this.fDfpField.newDfp(1.2824271291006226));
        this.SYMBOL_DFP_MAP.put("GoldenRatio", this.fDfpField.newDfp(1.618033988749895));
        this.SYMBOL_DFP_MAP.put("Khinchin", this.fDfpField.newDfp(2.6854520010653062));
        SYMBOL_BOOLEAN_MAP = new ConcurrentHashMap<String, Boolean>();
        SYMBOL_BOOLEAN_MAP.put("False", Boolean.FALSE);
        SYMBOL_BOOLEAN_MAP.put("True", Boolean.TRUE);
        FUNCTION_BOOLEAN_MAP = new ConcurrentHashMap<String, Object>();
        FUNCTION_BOOLEAN_MAP.put("And", new IBooleanBoolean2Function(){

            @Override
            public boolean evaluate(boolean arg1, boolean arg2) {
                return arg1 && arg2;
            }
        });
        FUNCTION_BOOLEAN_MAP.put("Not", new IBooleanBoolean1Function(){

            @Override
            public boolean evaluate(boolean arg1) {
                return !arg1;
            }
        });
        FUNCTION_BOOLEAN_MAP.put("Or", new IBooleanBoolean2Function(){

            @Override
            public boolean evaluate(boolean arg1, boolean arg2) {
                return arg1 || arg2;
            }
        });
        FUNCTION_BOOLEAN_MAP.put("Equal", new IBooleanDfp2Function(){

            @Override
            public boolean evaluate(Dfp arg1, Dfp arg2) {
                return arg1.equals(arg2);
            }
        });
        FUNCTION_BOOLEAN_MAP.put("Greater", new IBooleanDfp2Function(){

            @Override
            public boolean evaluate(Dfp arg1, Dfp arg2) {
                return arg1.greaterThan(arg2);
            }
        });
        FUNCTION_BOOLEAN_MAP.put("GreaterEqual", new IBooleanDfp2Function(){

            @Override
            public boolean evaluate(Dfp arg1, Dfp arg2) {
                return !arg1.lessThan(arg2);
            }
        });
        FUNCTION_BOOLEAN_MAP.put("Less", new IBooleanDfp2Function(){

            @Override
            public boolean evaluate(Dfp arg1, Dfp arg2) {
                return arg1.lessThan(arg2);
            }
        });
        FUNCTION_BOOLEAN_MAP.put("LessEqual", new IBooleanDfp2Function(){

            @Override
            public boolean evaluate(Dfp arg1, Dfp arg2) {
                return !arg1.greaterThan(arg2);
            }
        });
        FUNCTION_BOOLEAN_MAP.put("Unequal", new IBooleanDfp2Function(){

            @Override
            public boolean evaluate(Dfp arg1, Dfp arg2) {
                return !arg1.equals(arg2);
            }
        });
        FUNCTION_DFP_MAP = new ConcurrentHashMap<String, Object>();
        FUNCTION_DFP_MAP.put("ArcTan", new ArcTanFunction());
        FUNCTION_DFP_MAP.put("CompoundExpression", new CompoundExpressionFunction());
        FUNCTION_DFP_MAP.put("Set", new SetFunction());
        FUNCTION_DFP_MAP.put("Log", new LogFunction());
        FUNCTION_DFP_MAP.put("Max", new MaxFunction());
        FUNCTION_DFP_MAP.put("Min", new MinFunction());
        FUNCTION_DFP_MAP.put("Plus", new PlusFunction());
        FUNCTION_DFP_MAP.put("Times", new TimesFunction());
        FUNCTION_DFP_MAP.put("ArcCos", new IDfp1Function(){

            @Override
            public Dfp evaluate(Dfp arg1) {
                return DfpMath.acos(arg1);
            }
        });
        FUNCTION_DFP_MAP.put("ArcSin", new IDfp1Function(){

            @Override
            public Dfp evaluate(Dfp arg1) {
                return DfpMath.asin(arg1);
            }
        });
        FUNCTION_DFP_MAP.put("Ceiling", new IDfp1Function(){

            @Override
            public Dfp evaluate(Dfp arg1) {
                return arg1.ceil();
            }
        });
        FUNCTION_DFP_MAP.put("Cos", new IDfp1Function(){

            @Override
            public Dfp evaluate(Dfp arg1) {
                return arg1.cos();
            }
        });
        FUNCTION_DFP_MAP.put("Cosh", new IDfp1Function(){

            @Override
            public Dfp evaluate(Dfp arg1) {
                return arg1.cosh();
            }
        });
        FUNCTION_DFP_MAP.put("Exp", new IDfp1Function(){

            @Override
            public Dfp evaluate(Dfp arg1) {
                return DfpMath.exp(arg1);
            }
        });
        FUNCTION_DFP_MAP.put("Floor", new IDfp1Function(){

            @Override
            public Dfp evaluate(Dfp arg1) {
                return arg1.floor();
            }
        });
        FUNCTION_DFP_MAP.put("Sign", new IDfp1Function(){

            @Override
            public Dfp evaluate(Dfp arg1) {
                return arg1.signum();
            }
        });
        FUNCTION_DFP_MAP.put("Sin", new IDfp1Function(){

            @Override
            public Dfp evaluate(Dfp arg1) {
                return DfpMath.sin(arg1);
            }
        });
        FUNCTION_DFP_MAP.put("Sinh", new IDfp1Function(){

            @Override
            public Dfp evaluate(Dfp arg1) {
                return arg1.sinh();
            }
        });
        FUNCTION_DFP_MAP.put("Sqrt", new IDfp1Function(){

            @Override
            public Dfp evaluate(Dfp arg1) {
                return arg1.sqrt();
            }
        });
        FUNCTION_DFP_MAP.put("Tan", new IDfp1Function(){

            @Override
            public Dfp evaluate(Dfp arg1) {
                return DfpMath.tan(arg1);
            }
        });
        FUNCTION_DFP_MAP.put("Tanh", new IDfp1Function(){

            @Override
            public Dfp evaluate(Dfp arg1) {
                return arg1.tanh();
            }
        });
        FUNCTION_DFP_MAP.put("Power", new IDfp2Function(){

            @Override
            public Dfp evaluate(Dfp arg1, Dfp arg2) {
                return arg1.pow(arg2);
            }
        });
    }

    public DfpEvaluator(int decimalDigits) {
        this(decimalDigits, null, false);
    }

    public DfpEvaluator(int decimalDigits, boolean relaxedSyntax) {
        this(decimalDigits, null, relaxedSyntax);
    }

    public DfpEvaluator(int decimalDigits, ASTNode node, boolean relaxedSyntax) {
        this.fASTFactory = new ASTNodeFactory(relaxedSyntax);
        this.fVariableMap = new HashMap<String, IDfpValue>();
        this.fBooleanVariables = new HashMap<String, BooleanVariable>();
        this.fNode = node;
        this.fRelaxedSyntax = relaxedSyntax;
        this.fDfpField = new DfpField(decimalDigits);
        this.fZERO = new DfpNode(this.fDfpField.getZero());
        this.init();
        if (this.fRelaxedSyntax && this.SYMBOL_DFP_MAP.get("pi") == null) {
            for (String key : this.SYMBOL_DFP_MAP.keySet()) {
                this.SYMBOL_DFP_MAP.put(key.toLowerCase(), this.SYMBOL_DFP_MAP.get(key));
            }
            for (String key : SYMBOL_BOOLEAN_MAP.keySet()) {
                SYMBOL_BOOLEAN_MAP.put(key.toLowerCase(), SYMBOL_BOOLEAN_MAP.get(key));
            }
            for (String key : FUNCTION_DFP_MAP.keySet()) {
                FUNCTION_DFP_MAP.put(key.toLowerCase(), FUNCTION_DFP_MAP.get(key));
            }
            for (String key : FUNCTION_BOOLEAN_MAP.keySet()) {
                FUNCTION_BOOLEAN_MAP.put(key.toLowerCase(), FUNCTION_BOOLEAN_MAP.get(key));
            }
        }
    }

    public ASTNode parse(String expression) {
        Parser p = this.fRelaxedSyntax ? new Parser(ASTNodeFactory.RELAXED_STYLE_FACTORY, true) : new Parser(ASTNodeFactory.MMA_STYLE_FACTORY, false);
        this.fNode = p.parse(expression);
        if (this.fNode instanceof FunctionNode) {
            this.fNode = this.optimizeFunction((FunctionNode)this.fNode);
        }
        return this.fNode;
    }

    public static ASTNode parseNode(int decimalDigits, String expression, boolean relaxedSyntax) {
        DfpEvaluator dfpEvaluator = new DfpEvaluator(decimalDigits, relaxedSyntax);
        return dfpEvaluator.parse(expression);
    }

    public Dfp evaluate(String expression) {
        Parser p = this.fRelaxedSyntax ? new Parser(ASTNodeFactory.RELAXED_STYLE_FACTORY, true) : new Parser(ASTNodeFactory.MMA_STYLE_FACTORY, false);
        this.fNode = p.parse(expression);
        if (this.fNode instanceof FunctionNode) {
            this.fNode = this.optimizeFunction((FunctionNode)this.fNode);
        }
        return this.evaluateNode(this.fNode);
    }

    public Dfp evaluate() {
        if (this.fNode == null) {
            throw new SyntaxError(0, 0, 0, " ", "No parser input defined", 1);
        }
        return this.evaluateNode(this.fNode);
    }

    public Dfp evaluateNode(ASTNode node) {
        if (node instanceof DfpNode) {
            return this.fDfpField.newDfp(((DfpNode)node).getDfpValue());
        }
        if (node instanceof FunctionNode) {
            return this.evaluateFunction((FunctionNode)node);
        }
        if (node instanceof SymbolNode) {
            IDfpValue v = this.fVariableMap.get(node.toString());
            if (v != null) {
                return v.getValue();
            }
            Dfp dbl = this.SYMBOL_DFP_MAP.get(node.toString());
            if (dbl != null) {
                return dbl;
            }
        } else if (node instanceof NumberNode) {
            if (node instanceof FractionNode) {
                return this.fDfpField.newDfp(((FractionNode)node).getNumerator().toString()).divide(this.fDfpField.newDfp(((FractionNode)node).getDenominator().toString()));
            }
            if (node instanceof IntegerNode) {
                String iStr = ((NumberNode)node).getString();
                if (iStr != null) {
                    return this.fDfpField.newDfp(iStr);
                }
                return this.fDfpField.newDfp(((IntegerNode)node).getIntValue());
            }
            return this.fDfpField.newDfp(((NumberNode)node).getString());
        }
        throw new ArithmeticMathException("DfpEvaluator#evaluateNode(ASTNode) not possible for: " + node.toString());
    }

    public Dfp evaluateFunction(FunctionNode functionNode) {
        if (functionNode.size() > 0 && functionNode.getNode(0) instanceof SymbolNode) {
            String symbol = functionNode.getNode(0).toString();
            if (symbol.equals("If") || this.fRelaxedSyntax && symbol.equalsIgnoreCase("if")) {
                if (functionNode.size() == 3) {
                    if (this.evaluateNodeLogical(functionNode.getNode(1))) {
                        return this.evaluateNode(functionNode.getNode(2));
                    }
                } else if (functionNode.size() == 4) {
                    if (this.evaluateNodeLogical(functionNode.getNode(1))) {
                        return this.evaluateNode(functionNode.getNode(2));
                    }
                    return this.evaluateNode(functionNode.getNode(3));
                }
            } else {
                Object obj = FUNCTION_DFP_MAP.get(symbol);
                if (obj instanceof IDfpFunction) {
                    return ((IDfpFunction)obj).evaluate(this, functionNode);
                }
                if (functionNode.size() == 1) {
                    if (obj instanceof IDfp0Function) {
                        return ((IDfp0Function)obj).evaluate();
                    }
                } else if (functionNode.size() == 2) {
                    if (obj instanceof IDfp1Function) {
                        return ((IDfp1Function)obj).evaluate(this.evaluateNode(functionNode.getNode(1)));
                    }
                } else if (functionNode.size() == 3 && obj instanceof IDfp2Function) {
                    return ((IDfp2Function)obj).evaluate(this.evaluateNode(functionNode.getNode(1)), this.evaluateNode(functionNode.getNode(2)));
                }
                if (this.fCallbackFunction != null) {
                    Dfp[] dfpArgs = new Dfp[functionNode.size() - 1];
                    for (int i = 0; i < dfpArgs.length; ++i) {
                        dfpArgs[i] = this.evaluateNode(functionNode.getNode(i + 1));
                    }
                    return this.fCallbackFunction.evaluate(this, functionNode, dfpArgs);
                }
            }
        }
        throw new ArithmeticMathException("DfpEvaluator#evaluateFunction(FunctionNode) not possible for: " + functionNode.toString());
    }

    public boolean isSymbol(SymbolNode symbol1, String symbol2Name) {
        if (this.fRelaxedSyntax) {
            return symbol1.getString().equalsIgnoreCase(symbol2Name);
        }
        return symbol1.getString().equals(symbol2Name);
    }

    public boolean isSymbol(SymbolNode symbol1, SymbolNode symbol2) {
        if (this.fRelaxedSyntax) {
            return symbol1.getString().equalsIgnoreCase(symbol2.getString());
        }
        return symbol1.equals(symbol2);
    }

    public ASTNode derivative(ASTNode node, String var) {
        SymbolNode sym = this.fASTFactory.createSymbol(var);
        return this.derivative(node, sym);
    }

    public ASTNode derivative(ASTNode node, SymbolNode var) {
        if (node.isFree(var)) {
            return new DfpNode(this.fDfpField.getZero());
        }
        if (node instanceof FunctionNode) {
            FunctionNode f = (FunctionNode)node;
            if (f.size() > 1 && f.getNode(0) instanceof SymbolNode) {
                SymbolNode head = (SymbolNode)f.getNode(0);
                if (f.size() == 2) {
                    ASTNode arg1Derived = this.derivative(f.getNode(1), var);
                    if (this.isSymbol(head, "Exp")) {
                        FunctionNode fun = new FunctionNode(this.fASTFactory.createSymbol("Exp"));
                        fun.add(f.getNode(1));
                        return this.getDerivativeResult(arg1Derived, fun);
                    }
                    if (this.isSymbol(head, "Cos")) {
                        FunctionNode fun = new FunctionNode(this.fASTFactory.createSymbol("Times"));
                        fun.add(new DfpNode(this.fDfpField.newDfp(-1)));
                        fun.add(new FunctionNode(this.fASTFactory.createSymbol("Cos"), f.getNode(1)));
                        return this.getDerivativeResult(arg1Derived, fun);
                    }
                    if (this.isSymbol(head, "Sin")) {
                        FunctionNode fun = new FunctionNode(this.fASTFactory.createSymbol("Cos"));
                        fun.add(f.getNode(1));
                        return this.getDerivativeResult(arg1Derived, fun);
                    }
                } else if (f.size() == 3 && this.isSymbol(head, "Power")) {
                    if (f.get(2).isFree(var)) {
                        ASTNode arg1Derived = this.derivative(f.getNode(1), var);
                        FunctionNode exponent = this.fASTFactory.createFunction(this.fASTFactory.createSymbol("Plus"), new DfpNode(this.fDfpField.newDfp(-1)), f.get(2));
                        FunctionNode fun = this.fASTFactory.createFunction(this.fASTFactory.createSymbol("Times"), f.get(2), this.fASTFactory.createFunction(this.fASTFactory.createSymbol("Power"), f.get(1), exponent));
                        return this.getDerivativeResult(arg1Derived, fun);
                    }
                    if (f.get(1).isFree(var)) {
                        ASTNode arg2Derived = this.derivative(f.getNode(2), var);
                        FunctionNode fun = this.fASTFactory.createFunction(this.fASTFactory.createSymbol("Times"), this.fASTFactory.createFunction(this.fASTFactory.createSymbol("Log"), f.get(1)), f);
                        return this.getDerivativeResult(arg2Derived, fun);
                    }
                } else {
                    if (this.isSymbol(head, "Plus")) {
                        FunctionNode result = new FunctionNode(f.getNode(0));
                        for (int i = 1; i < f.size(); ++i) {
                            ASTNode deriv = this.derivative(f.getNode(i), var);
                            if (deriv.equals(this.fZERO)) continue;
                            result.add(deriv);
                        }
                        return result;
                    }
                    if (this.isSymbol(head, "Times")) {
                        FunctionNode plusResult = new FunctionNode(this.fASTFactory.createSymbol("Plus"));
                        for (int i = 1; i < f.size(); ++i) {
                            FunctionNode timesResult = new FunctionNode(f.getNode(0));
                            boolean valid = true;
                            for (int j = 1; j < f.size(); ++j) {
                                if (j == i) {
                                    ASTNode deriv = this.derivative(f.getNode(j), var);
                                    if (deriv.equals(this.fZERO)) {
                                        valid = false;
                                        continue;
                                    }
                                    timesResult.add(deriv);
                                    continue;
                                }
                                timesResult.add(f.getNode(j));
                            }
                            if (!valid) continue;
                            plusResult.add(timesResult);
                        }
                        return plusResult;
                    }
                }
            }
            return new FunctionNode(new SymbolNode("D"), node, var);
        }
        if (node instanceof SymbolNode) {
            if (this.isSymbol((SymbolNode)node, var)) {
                return new DfpNode(this.fDfpField.getOne());
            }
            IDfpValue v = this.fVariableMap.get(node.toString());
            if (v != null) {
                return new DfpNode(this.fDfpField.getZero());
            }
            Dfp dbl = this.SYMBOL_DFP_MAP.get(node.toString());
            if (dbl != null) {
                return new DfpNode(this.fDfpField.getZero());
            }
            return new DfpNode(this.fDfpField.getZero());
        }
        if (node instanceof NumberNode) {
            return new DfpNode(this.fDfpField.getZero());
        }
        throw new ArithmeticMathException("DfpEvaluator#derivative(ASTNode, SymbolNode) not possible for: " + node.toString());
    }

    private ASTNode getDerivativeResult(ASTNode arg1Derived, FunctionNode fun) {
        if (!arg1Derived.equals(new DfpNode(this.fDfpField.getOne()))) {
            FunctionNode res = new FunctionNode(this.fASTFactory.createSymbol("Times"));
            res.add(arg1Derived);
            res.add(fun);
            return res;
        }
        return fun;
    }

    public boolean evaluateNodeLogical(ASTNode node) {
        if (node instanceof FunctionNode) {
            return this.evaluateFunctionLogical((FunctionNode)node);
        }
        if (node instanceof SymbolNode) {
            BooleanVariable v = this.fBooleanVariables.get(node.toString());
            if (v != null) {
                return v.getValue();
            }
            Boolean boole = SYMBOL_BOOLEAN_MAP.get(node.toString());
            if (boole != null) {
                return boole;
            }
        }
        throw new ArithmeticMathException("DfpEvaluator#evaluateNodeLogical(ASTNode) not possible for: " + node.toString());
    }

    public boolean evaluateFunctionLogical(FunctionNode functionNode) {
        if (functionNode.size() > 0 && functionNode.getNode(0) instanceof SymbolNode) {
            String symbol = functionNode.getNode(0).toString();
            if (functionNode.size() == 2) {
                Object obj = FUNCTION_BOOLEAN_MAP.get(symbol);
                if (obj instanceof IBooleanBoolean1Function) {
                    return ((IBooleanBoolean1Function)obj).evaluate(this.evaluateNodeLogical(functionNode.getNode(1)));
                }
            } else if (functionNode.size() == 3) {
                Object obj = FUNCTION_BOOLEAN_MAP.get(symbol);
                if (obj instanceof IBooleanDfp2Function) {
                    return ((IBooleanDfp2Function)obj).evaluate(this.evaluateNode(functionNode.getNode(1)), this.evaluateNode(functionNode.getNode(2)));
                }
                if (obj instanceof IBooleanBoolean2Function) {
                    return ((IBooleanBoolean2Function)obj).evaluate(this.evaluateNodeLogical(functionNode.getNode(1)), this.evaluateNodeLogical(functionNode.getNode(2)));
                }
            }
        }
        throw new ArithmeticMathException("DfpEvaluator#evaluateFunctionLogical(FunctionNode) not possible for: " + functionNode.toString());
    }

    public ASTNode optimizeFunction(FunctionNode functionNode) {
        if (functionNode.size() > 0) {
            boolean dfpOnly = true;
            for (int i = 1; i < functionNode.size(); ++i) {
                ASTNode node = functionNode.getNode(i);
                if (node instanceof NumberNode) {
                    if (node instanceof FractionNode) {
                        functionNode.set(i, new DfpNode(this.fDfpField.newDfp(((FractionNode)node).getNumerator().toString()).divide(this.fDfpField.newDfp(((FractionNode)node).getDenominator().toString()))));
                        continue;
                    }
                    if (node instanceof IntegerNode) {
                        String iStr = ((NumberNode)functionNode.getNode(i)).getString();
                        if (iStr != null) {
                            functionNode.set(i, new DfpNode(this.fDfpField.newDfp(iStr)));
                            continue;
                        }
                        functionNode.set(i, new DfpNode(this.fDfpField.newDfp(((IntegerNode)functionNode.getNode(i)).getIntValue())));
                        continue;
                    }
                    functionNode.set(i, new DfpNode(this.fDfpField.newDfp(((NumberNode)functionNode.getNode(i)).getString())));
                    continue;
                }
                if (functionNode.getNode(i) instanceof FunctionNode) {
                    ASTNode optNode = this.optimizeFunction((FunctionNode)functionNode.getNode(i));
                    if (!(optNode instanceof DfpNode)) {
                        dfpOnly = false;
                    }
                    functionNode.set(i, optNode);
                    continue;
                }
                if (node instanceof SymbolNode) {
                    Dfp dbl = this.SYMBOL_DFP_MAP.get(node.toString());
                    if (dbl != null) {
                        functionNode.set(i, new DfpNode(dbl));
                        continue;
                    }
                    dfpOnly = false;
                    continue;
                }
                dfpOnly = false;
            }
            if (dfpOnly) {
                try {
                    return new DfpNode(this.evaluateFunction(functionNode));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return functionNode;
    }

    public void defineVariable(String variableName, Dfp value) {
        if (this.fRelaxedSyntax) {
            this.fVariableMap.put(variableName.toLowerCase(), new DfpVariable(value));
        } else {
            this.fVariableMap.put(variableName, new DfpVariable(value));
        }
    }

    public IDfpValue defineVariable(String variableName, IDfpValue value) {
        if (this.fRelaxedSyntax) {
            this.fVariableMap.put(variableName.toLowerCase(), value);
        } else {
            this.fVariableMap.put(variableName, value);
        }
        return value;
    }

    public IDfpValue defineVariable(String variableName, double value) {
        DfpVariable val = new DfpVariable(this.fDfpField.newDfp(value));
        if (this.fRelaxedSyntax) {
            this.fVariableMap.put(variableName.toLowerCase(), val);
        } else {
            this.fVariableMap.put(variableName, val);
        }
        return val;
    }

    public void setValue(IDfpValue variable, double value) {
        variable.setValue(this.fDfpField.newDfp(value));
    }

    public void defineVariable(String variableName) {
        if (this.fRelaxedSyntax) {
            this.fVariableMap.put(variableName.toLowerCase(), new DfpVariable(this.fDfpField.getZero()));
        } else {
            this.fVariableMap.put(variableName, new DfpVariable(this.fDfpField.getZero()));
        }
    }

    public IDfpValue getVariable(String variableName) {
        if (this.fRelaxedSyntax) {
            return this.fVariableMap.get(variableName.toLowerCase());
        }
        return this.fVariableMap.get(variableName);
    }

    public void defineVariable(String variableName, BooleanVariable value) {
        if (this.fRelaxedSyntax) {
            this.fBooleanVariables.put(variableName.toLowerCase(), value);
        } else {
            this.fBooleanVariables.put(variableName, value);
        }
    }

    public void clearVariables() {
        this.fVariableMap.clear();
        this.fBooleanVariables.clear();
    }

    public void getVariables(String expression, Set<String> result) {
        this.getVariables(expression, result, true);
    }

    public void getVariables(String expression, Set<String> result, boolean relaxedSyntax) {
        Parser p = new Parser(relaxedSyntax ? ASTNodeFactory.RELAXED_STYLE_FACTORY : ASTNodeFactory.MMA_STYLE_FACTORY, relaxedSyntax);
        ASTNode node = p.parse(expression);
        this.getVariables(node, result);
    }

    public void getVariables(ASTNode node, Set<String> result) {
        Object obj;
        FunctionNode functionNode;
        if (node instanceof FunctionNode && (functionNode = (FunctionNode)node).size() > 0 && functionNode.getNode(0) instanceof SymbolNode) {
            for (int i = 1; i < functionNode.size(); ++i) {
                this.getVariables(functionNode.getNode(i), result);
            }
        }
        if (node instanceof SymbolNode && (obj = this.SYMBOL_DFP_MAP.get(node.toString())) == null && (obj = SYMBOL_BOOLEAN_MAP.get(node.toString())) == null) {
            result.add(node.toString());
        }
    }

    class TimesFunction
    implements IDfpFunction,
    IDfp2Function {
        TimesFunction() {
        }

        @Override
        public Dfp evaluate(Dfp arg1, Dfp arg2) {
            return arg1.multiply(arg2);
        }

        @Override
        public Dfp evaluate(DfpEvaluator engine, FunctionNode function) {
            Dfp result = DfpEvaluator.this.fDfpField.getOne();
            for (int i = 1; i < function.size(); ++i) {
                result = result.multiply(engine.evaluateNode(function.getNode(i)));
            }
            return result;
        }
    }

    class PlusFunction
    implements IDfpFunction,
    IDfp2Function {
        PlusFunction() {
        }

        @Override
        public Dfp evaluate(Dfp arg1, Dfp arg2) {
            return arg1.add(arg2);
        }

        @Override
        public Dfp evaluate(DfpEvaluator engine, FunctionNode function) {
            Dfp result = DfpEvaluator.this.fDfpField.getZero();
            for (int i = 1; i < function.size(); ++i) {
                result = result.add(engine.evaluateNode(function.getNode(i)));
            }
            return result;
        }
    }

    static class MinFunction
    implements IDfpFunction,
    IDfp2Function {
        MinFunction() {
        }

        @Override
        public Dfp evaluate(Dfp arg1, Dfp arg2) {
            return arg1.lessThan(arg2) ? arg1 : arg2;
        }

        @Override
        public Dfp evaluate(DfpEvaluator engine, FunctionNode function) {
            Dfp result = null;
            int end = function.size();
            if (end > 1) {
                result = engine.evaluateNode(function.getNode(1));
                for (int i = 2; i < end; ++i) {
                    result = this.evaluate(result, engine.evaluateNode(function.getNode(i)));
                }
            }
            return result;
        }
    }

    static class MaxFunction
    implements IDfpFunction,
    IDfp2Function {
        MaxFunction() {
        }

        @Override
        public Dfp evaluate(Dfp arg1, Dfp arg2) {
            return arg1.greaterThan(arg2) ? arg1 : arg2;
        }

        @Override
        public Dfp evaluate(DfpEvaluator engine, FunctionNode function) {
            Dfp result = null;
            int end = function.size();
            if (end > 1) {
                result = engine.evaluateNode(function.getNode(1));
                for (int i = 2; i < end; ++i) {
                    result = this.evaluate(result, engine.evaluateNode(function.getNode(i)));
                }
            }
            return result;
        }
    }

    static class SetFunction
    implements IDfpFunction {
        SetFunction() {
        }

        @Override
        public Dfp evaluate(DfpEvaluator engine, FunctionNode function) {
            if (function.size() != 3) {
                throw new ArithmeticMathException("SetFunction#evaluate(DfpEvaluator, FunctionNode) needs 2 arguments: " + function.toString());
            }
            if (!(function.getNode(1) instanceof SymbolNode)) {
                throw new ArithmeticMathException("SetFunction#evaluate(DfpEvaluator, FunctionNode) symbol required on the left hand side: " + function.toString());
            }
            String variableName = ((SymbolNode)function.getNode(1)).getString();
            Dfp result = engine.evaluateNode(function.getNode(2));
            IDfpValue dv = engine.getVariable(variableName);
            if (dv == null) {
                dv = new DfpVariable(result);
            } else {
                dv.setValue(result);
            }
            engine.defineVariable(variableName, dv);
            return result;
        }
    }

    static class CompoundExpressionFunction
    implements IDfpFunction {
        CompoundExpressionFunction() {
        }

        @Override
        public Dfp evaluate(DfpEvaluator engine, FunctionNode function) {
            Dfp result = null;
            int end = function.size();
            for (int i = 1; i < end; ++i) {
                result = engine.evaluateNode(function.getNode(i));
            }
            return result;
        }
    }

    static class LogFunction
    implements IDfp1Function,
    IDfp2Function {
        LogFunction() {
        }

        @Override
        public Dfp evaluate(Dfp arg1) {
            return DfpMath.log(arg1);
        }

        @Override
        public Dfp evaluate(Dfp base, Dfp z) {
            return DfpMath.log(z).divide(DfpMath.log(base));
        }
    }

    static class ArcTanFunction
    implements IDfp1Function,
    IDfp2Function {
        ArcTanFunction() {
        }

        @Override
        public Dfp evaluate(Dfp arg1) {
            return DfpMath.atan(arg1);
        }

        @Override
        public Dfp evaluate(Dfp arg1, Dfp arg2) {
            return arg1.atan2(arg2);
        }
    }
}

